/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  FP fixups for 16-bit code. These fixups allow the program
* loader to replace FP instructions by calls to an FP emulation library.
* Used by Win16 and OS/2 16bit.
*
****************************************************************************/

#include "globals.h"
#include "parser.h"
#include "directiv.h"
#include "extern.h"
#include "fixup.h"
#include "mangle.h"
#include "myassert.h"
#include "segment.h"

extern int_8           Frame;          // Frame of current fixup

typedef enum {
    FPP_NONE,
    FPP_WAIT,
    FPP_NORMAL,
    FPP_ES,
    FPP_CS,
    FPP_SS,
    FPP_DS,
    FPP_FS,
    FPP_GS,
    FPP_NUMBER_OF_TYPES
} fp_patches;

static char *FPPatchName[] = {
    NULL,
    "FIWRQQ",
    "FIDRQQ",
    "FIERQQ",
    "FICRQQ",
    "FISRQQ",
    "FIARQQ",
    "FIFRQQ",
    "FIGRQQ"
};

static char *FPPatchAltName[] = {
    NULL,
    NULL,
    NULL,
    NULL,
    "FJCRQQ",
    "FJSRQQ",
    "FJARQQ",
    "FJFRQQ",
    "FJGRQQ"
};

static ret_code MakeFpFixup( struct code_info *CodeInfo, struct asm_sym *sym )
/*************************************/
{
    if ( write_to_file ) {
        CodeInfo->InsFixup[2] = AddFixup( sym, FIX_OFF16, OPTJ_NONE );
        CodeInfo->InsFixup[2]->frame = FRAME_LOC;
        CodeInfo->InsFixup[2]->fixup_loc = GetCurrOffset();
        CodeInfo->data[2] = 0;
        return ( store_fixup( CodeInfo, 2 ) );
    }
    return( NOT_ERROR );
}

ret_code AddFloatingPointEmulationFixup( struct code_info *CodeInfo, bool secondary )
/************************************************************************************/
{
    fp_patches patch;
    struct asm_sym *sym;
    char **patch_name_array;

    patch_name_array = ( secondary ? FPPatchAltName : FPPatchName );

    if( CodeInfo->token == T_FWAIT ) {
        patch = FPP_WAIT;
    } else {
        switch( CodeInfo->prefix.RegOverride ) {
        case EMPTY:
            patch = FPP_NORMAL;
            break;
        case PREFIX_ES:
            patch = FPP_ES;
            break;
        case PREFIX_CS:
            patch = FPP_CS;
            break;
        case PREFIX_SS:
            patch = FPP_SS;
            break;
        case PREFIX_DS:
            patch = FPP_DS;
            break;
        case PREFIX_FS:
            patch = FPP_FS;
            break;
        case PREFIX_GS:
            patch = FPP_GS;
            break;
        default:
            never_reach();
        }
    }

    /* put out an extern def for the patch */
    if( patch_name_array[patch] == NULL )
        return( NOT_ERROR );
    sym = SymSearch( patch_name_array[patch] );
    if( sym == NULL ) {
        sym = MakeExtern( patch_name_array[patch], MT_FAR, NULL, NULL, USE16 );
        SetMangler( sym, NULL, LANG_NONE );
    }
    return( MakeFpFixup( CodeInfo, sym ) );
}
