/*      MOUSE.H - part of the FreeDAPI
        Copyright 1999 - Enrico Bartky

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _MOUSE_H_
#define _MOUSE_H_

#ifndef NO
 #define NO 0
#endif
 #ifndef YES
  #define YES 1
 #endif

// Global variables
struct MouseStruc {
	int present;
	int x, y;
	int leftdn, rightdn;
	int leftup, rightup;
	int lefthit, righthit;
	int visible;
};

extern struct MouseStruc Mouse;

// Function declarations
int MouseIn(int x, int y, int x1, int y1);
void OpenMouse(void);
void CloseMouse(void);
void SetMouseLimits(int x1, int y1, int x2, int y2);
void ShowMouse(void);
void HideMouse(void);
void SetMousePosition(int x, int y);
void ReadMouseDown(void);
void ReadMouseUp(void);
void ClearBtn(void);
int WaitBtn(void);
void ChangeMouse(unsigned char far *shape, int hotx, int hoty);
#endif
