/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.CapabilityBase;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.OutArg;
import org.OpenNI.PowerLineFrequency;
import org.OpenNI.ProductionNode;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.WrapperUtils;

public class AntiFlickerCapability
extends CapabilityBase {
    private StateChangedObservable powerLineFrequencyChanged = new StateChangedObservable(){

        protected int registerNative(String string, OutArg outArg) {
            return NativeMethods.xnRegisterToPowerLineFrequencyChange(AntiFlickerCapability.this.toNative(), this, string, outArg);
        }

        protected void unregisterNative(long l2) {
            NativeMethods.xnUnregisterFromPowerLineFrequencyChange(AntiFlickerCapability.this.toNative(), l2);
        }
    };

    public AntiFlickerCapability(ProductionNode productionNode) {
        super(productionNode);
    }

    public PowerLineFrequency getPowerLineFrequency() {
        return PowerLineFrequency.fromNative(NativeMethods.xnGetPowerLineFrequency(this.toNative()));
    }

    public void setPowerLineFrequency(PowerLineFrequency powerLineFrequency) {
        int n = NativeMethods.xnSetPowerLineFrequency(this.toNative(), powerLineFrequency.toNative());
        WrapperUtils.throwOnError(n);
    }

    public IStateChangedObservable getPowerLineFrequencyChangedEvent() {
        return this.powerLineFrequencyChanged;
    }
}

