/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.AudioMetaData;
import org.OpenNI.Context;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.Generator;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.OutArg;
import org.OpenNI.Query;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.WaveOutputMode;
import org.OpenNI.WrapperUtils;

public class AudioGenerator
extends Generator {
    private StateChangedObservable waveOutputModeChanged = new StateChangedObservable(){

        protected int registerNative(String string, OutArg outArg) {
            return NativeMethods.xnRegisterToWaveOutputModeChanges(AudioGenerator.this.toNative(), this, string, outArg);
        }

        protected void unregisterNative(long l2) {
            NativeMethods.xnUnregisterFromWaveOutputModeChanges(AudioGenerator.this.toNative(), l2);
        }
    };

    public AudioGenerator(Context context, long l2, boolean bl) {
        super(context, l2, bl);
    }

    public static AudioGenerator create(Context context, Query query, EnumerationErrors enumerationErrors) {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnCreateAudioGenerator(context.toNative(), outArg, query == null ? 0L : query.toNative(), enumerationErrors == null ? 0L : enumerationErrors.toNative());
        WrapperUtils.throwOnError(n);
        AudioGenerator audioGenerator = (AudioGenerator)context.createProductionNodeObject((Long)outArg.value, NodeType.AUDIO);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return audioGenerator;
    }

    public static AudioGenerator create(Context context, Query query) {
        return AudioGenerator.create(context, query, null);
    }

    public static AudioGenerator create(Context context) {
        return AudioGenerator.create(context, null, null);
    }

    public WaveOutputMode[] getSupportedMapOutputModes() {
        int n = NativeMethods.xnGetSupportedWaveOutputModesCount(this.toNative());
        WaveOutputMode[] waveOutputModeArray = new WaveOutputMode[n];
        int n2 = NativeMethods.xnGetSupportedWaveOutputModes(this.toNative(), waveOutputModeArray);
        WrapperUtils.throwOnError(n2);
        return waveOutputModeArray;
    }

    public WaveOutputMode getWaveOutputMode() {
        OutArg outArg = new OutArg();
        OutArg outArg2 = new OutArg();
        OutArg outArg3 = new OutArg();
        int n = NativeMethods.xnGetWaveOutputMode(this.toNative(), outArg, outArg2, outArg3);
        WrapperUtils.throwOnError(n);
        return new WaveOutputMode((Integer)outArg.value, (Short)outArg2.value, (Byte)outArg3.value);
    }

    public void setWaveOutputMode(WaveOutputMode waveOutputMode) {
        int n = NativeMethods.xnSetWaveOutputMode(this.toNative(), waveOutputMode.getSampleRate(), waveOutputMode.getBitsPerSample(), waveOutputMode.getNumberOfChannels());
        WrapperUtils.throwOnError(n);
    }

    public IStateChangedObservable getMapOutputModeChangedEvent() {
        return this.waveOutputModeChanged;
    }

    public void getMetaData(AudioMetaData audioMetaData) {
        NativeMethods.xnGetAudioMetaData(this.toNative(), audioMetaData);
    }

    public AudioMetaData getMetaData() {
        AudioMetaData audioMetaData = new AudioMetaData();
        this.getMetaData(audioMetaData);
        return audioMetaData;
    }
}

