/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.ActiveHandEventArgs;
import org.OpenNI.Context;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.Generator;
import org.OpenNI.HandTouchingFOVEdgeCapability;
import org.OpenNI.IObservable;
import org.OpenNI.InactiveHandEventArgs;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.Observable;
import org.OpenNI.OutArg;
import org.OpenNI.Point3D;
import org.OpenNI.Query;
import org.OpenNI.WrapperUtils;

public class HandsGenerator
extends Generator {
    private Observable handCreateEvent = new Observable(){

        protected int registerNative(OutArg outArg) {
            return NativeMethods.xnRegisterHandCallbacks(HandsGenerator.this.toNative(), this, "callback", null, null, outArg);
        }

        protected void unregisterNative(long l2) {
            NativeMethods.xnUnregisterHandCallbacks(HandsGenerator.this.toNative(), l2);
        }

        public void callback(int n, Point3D point3D, float f2) {
            this.notify(new ActiveHandEventArgs(n, point3D, f2));
        }
    };
    private Observable handUpdateEvent = new Observable(){

        protected int registerNative(OutArg outArg) {
            return NativeMethods.xnRegisterHandCallbacks(HandsGenerator.this.toNative(), this, null, "callback", null, outArg);
        }

        protected void unregisterNative(long l2) {
            NativeMethods.xnUnregisterHandCallbacks(HandsGenerator.this.toNative(), l2);
        }

        public void callback(int n, Point3D point3D, float f2) {
            this.notify(new ActiveHandEventArgs(n, point3D, f2));
        }
    };
    private Observable handDestroyEvent = new Observable(){

        protected int registerNative(OutArg outArg) {
            return NativeMethods.xnRegisterHandCallbacks(HandsGenerator.this.toNative(), this, null, null, "callback", outArg);
        }

        protected void unregisterNative(long l2) {
            NativeMethods.xnUnregisterHandCallbacks(HandsGenerator.this.toNative(), l2);
        }

        public void callback(int n, float f2) {
            this.notify(new InactiveHandEventArgs(n, f2));
        }
    };

    HandsGenerator(Context context, long l2, boolean bl) {
        super(context, l2, bl);
    }

    public static HandsGenerator create(Context context, Query query, EnumerationErrors enumerationErrors) {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnCreateHandsGenerator(context.toNative(), outArg, query == null ? 0L : query.toNative(), enumerationErrors == null ? 0L : enumerationErrors.toNative());
        WrapperUtils.throwOnError(n);
        HandsGenerator handsGenerator = (HandsGenerator)context.createProductionNodeObject((Long)outArg.value, NodeType.HANDS);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return handsGenerator;
    }

    public static HandsGenerator create(Context context, Query query) {
        return HandsGenerator.create(context, query, null);
    }

    public static HandsGenerator create(Context context) {
        return HandsGenerator.create(context, null, null);
    }

    public void StopTracking(int n) {
        int n2 = NativeMethods.xnStopTracking(this.toNative(), n);
        WrapperUtils.throwOnError(n2);
    }

    public void StopTrackingAll() {
        int n = NativeMethods.xnStopTrackingAll(this.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void StartTracking(Point3D point3D) {
        int n = NativeMethods.xnStartTracking(this.toNative(), point3D.getX(), point3D.getY(), point3D.getZ());
        WrapperUtils.throwOnError(n);
    }

    public void SetSmoothing(float f2) {
        int n = NativeMethods.xnSetTrackingSmoothing(this.toNative(), f2);
        WrapperUtils.throwOnError(n);
    }

    public HandTouchingFOVEdgeCapability getHandTouchingFOVEdgeCapability() {
        return new HandTouchingFOVEdgeCapability(this);
    }

    public IObservable getHandCreateEvent() {
        return this.handCreateEvent;
    }

    public IObservable getHandUpdateEvent() {
        return this.handUpdateEvent;
    }

    public IObservable getHandDestroyEvent() {
        return this.handDestroyEvent;
    }
}

