/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.AntiFlickerCapability;
import org.OpenNI.Capability;
import org.OpenNI.Context;
import org.OpenNI.CroppingCapability;
import org.OpenNI.GeneralIntCapability;
import org.OpenNI.Generator;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.MapOutputMode;
import org.OpenNI.NativeMethods;
import org.OpenNI.OutArg;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.WrapperUtils;

public class MapGenerator
extends Generator {
    private StateChangedObservable mapOutputModeChanged = new StateChangedObservable(){

        protected int registerNative(String string, OutArg outArg) {
            return NativeMethods.xnRegisterToMapOutputModeChange(MapGenerator.this.toNative(), this, string, outArg);
        }

        protected void unregisterNative(long l2) {
            NativeMethods.xnUnregisterFromMapOutputModeChange(MapGenerator.this.toNative(), l2);
        }
    };

    MapGenerator(Context context, long l2, boolean bl) {
        super(context, l2, bl);
    }

    public MapOutputMode[] getSupportedMapOutputModes() {
        int n = NativeMethods.xnGetSupportedMapOutputModesCount(this.toNative());
        MapOutputMode[] mapOutputModeArray = new MapOutputMode[n];
        int n2 = NativeMethods.xnGetSupportedMapOutputModes(this.toNative(), mapOutputModeArray);
        WrapperUtils.throwOnError(n2);
        return mapOutputModeArray;
    }

    public MapOutputMode getMapOutputMode() {
        OutArg outArg = new OutArg();
        OutArg outArg2 = new OutArg();
        OutArg outArg3 = new OutArg();
        int n = NativeMethods.xnGetMapOutputMode(this.toNative(), outArg, outArg2, outArg3);
        WrapperUtils.throwOnError(n);
        return new MapOutputMode((Integer)outArg.value, (Integer)outArg2.value, (Integer)outArg3.value);
    }

    public void setMapOutputMode(MapOutputMode mapOutputMode) {
        int n = NativeMethods.xnSetMapOutputMode(this.toNative(), mapOutputMode.getXRes(), mapOutputMode.getYRes(), mapOutputMode.getFPS());
        WrapperUtils.throwOnError(n);
    }

    public IStateChangedObservable getMapOutputModeChangedEvent() {
        return this.mapOutputModeChanged;
    }

    public CroppingCapability getCroppingCapability() {
        return new CroppingCapability(this);
    }

    public GeneralIntCapability getBrightnessCapability() {
        return new GeneralIntCapability(this, Capability.Brightness);
    }

    public GeneralIntCapability getContrastCapability() {
        return new GeneralIntCapability(this, Capability.Contrast);
    }

    public GeneralIntCapability getSaturationCapability() {
        return new GeneralIntCapability(this, Capability.Saturation);
    }

    public GeneralIntCapability getHueCapability() {
        return new GeneralIntCapability(this, Capability.Hue);
    }

    public GeneralIntCapability getSharpnessCapability() {
        return new GeneralIntCapability(this, Capability.Sharpness);
    }

    public GeneralIntCapability getGammaCapability() {
        return new GeneralIntCapability(this, Capability.Gamma);
    }

    public GeneralIntCapability getWhiteBalanceCapability() {
        return new GeneralIntCapability(this, Capability.WhiteBalance);
    }

    public GeneralIntCapability getBacklightCompensationCapability() {
        return new GeneralIntCapability(this, Capability.BacklightCompensation);
    }

    public GeneralIntCapability getGainCapability() {
        return new GeneralIntCapability(this, Capability.Gain);
    }

    public GeneralIntCapability getPanCapability() {
        return new GeneralIntCapability(this, Capability.Pan);
    }

    public GeneralIntCapability getTiltCapability() {
        return new GeneralIntCapability(this, Capability.Tilt);
    }

    public GeneralIntCapability getRollCapability() {
        return new GeneralIntCapability(this, Capability.Roll);
    }

    public GeneralIntCapability getZoomCapability() {
        return new GeneralIntCapability(this, Capability.Zoom);
    }

    public GeneralIntCapability getExposureCapability() {
        return new GeneralIntCapability(this, Capability.Exposure);
    }

    public GeneralIntCapability getIrisCapability() {
        return new GeneralIntCapability(this, Capability.Iris);
    }

    public GeneralIntCapability getFocusCapability() {
        return new GeneralIntCapability(this, Capability.Focus);
    }

    public GeneralIntCapability getLowLightCompensationCapability() {
        return new GeneralIntCapability(this, Capability.LowLightCompensation);
    }

    public AntiFlickerCapability getAntiFlickerCapability() {
        return new AntiFlickerCapability(this);
    }
}

