/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.CapabilityBase;
import org.OpenNI.IObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.Observable;
import org.OpenNI.OutArg;
import org.OpenNI.PoseDetectionEventArgs;
import org.OpenNI.PoseDetectionInProgressEventArgs;
import org.OpenNI.PoseDetectionState;
import org.OpenNI.PoseDetectionStatus;
import org.OpenNI.ProductionNode;
import org.OpenNI.WrapperUtils;

public class PoseDetectionCapability
extends CapabilityBase {
    private Observable poseDetectedEvent = new Observable(){

        protected int registerNative(OutArg outArg) {
            return NativeMethods.xnRegisterToPoseDetected(PoseDetectionCapability.this.toNative(), this, "callback", outArg);
        }

        protected void unregisterNative(long l2) {
            NativeMethods.xnUnregisterFromPoseDetected(PoseDetectionCapability.this.toNative(), l2);
        }

        public void callback(String string, int n) {
            this.notify(new PoseDetectionEventArgs(string, n));
        }
    };
    private Observable outOfPoseEvent = new Observable(){

        protected int registerNative(OutArg outArg) {
            return NativeMethods.xnRegisterToOutOfPose(PoseDetectionCapability.this.toNative(), this, "callback", outArg);
        }

        protected void unregisterNative(long l2) {
            NativeMethods.xnUnregisterFromOutOfPose(PoseDetectionCapability.this.toNative(), l2);
        }

        public void callback(String string, int n) {
            this.notify(new PoseDetectionEventArgs(string, n));
        }
    };
    private Observable poseDetectionInProgressEvent = new Observable(){

        protected int registerNative(OutArg outArg) {
            return NativeMethods.xnRegisterToPoseDetectionInProgress(PoseDetectionCapability.this.toNative(), this, "callback", outArg);
        }

        protected void unregisterNative(long l2) {
            NativeMethods.xnUnregisterFromPoseDetectionInProgress(PoseDetectionCapability.this.toNative(), l2);
        }

        public void callback(String string, int n, int n2) {
            this.notify(new PoseDetectionInProgressEventArgs(string, n, PoseDetectionStatus.fromNative(n2)));
        }
    };

    public PoseDetectionCapability(ProductionNode productionNode) {
        super(productionNode);
    }

    public int getNumberOfPoses() {
        return NativeMethods.xnGetNumberOfPoses(this.toNative());
    }

    public boolean isPoseSupported(String string) {
        return NativeMethods.xnIsPoseSupported(this.toNative(), string);
    }

    public void getPoseStatus(int n, String string, OutArg outArg, OutArg outArg2, OutArg outArg3) {
        OutArg outArg4 = new OutArg();
        OutArg outArg5 = new OutArg();
        int n2 = NativeMethods.xnGetPoseStatus(this.toNative(), n, string, outArg, outArg4, outArg5);
        outArg2.value = PoseDetectionStatus.fromNative((Integer)outArg4.value);
        outArg3.value = PoseDetectionState.fromNative((Integer)outArg5.value);
        WrapperUtils.throwOnError(n2);
    }

    public String[] getAllAvailablePoses() {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnGetAllAvailablePoses(this.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        return (String[])outArg.value;
    }

    public void StartPoseDetection(String string, int n) {
        int n2 = NativeMethods.xnStartPoseDetection(this.toNative(), string, n);
        WrapperUtils.throwOnError(n2);
    }

    public void StopPoseDetection(int n) {
        int n2 = NativeMethods.xnStopPoseDetection(this.toNative(), n);
        WrapperUtils.throwOnError(n2);
    }

    public void startPoseDetection(String string, int n) {
        int n2 = NativeMethods.xnStartPoseDetection(this.toNative(), string, n);
        WrapperUtils.throwOnError(n2);
    }

    public void stopPoseDetection(int n) {
        int n2 = NativeMethods.xnStopPoseDetection(this.toNative(), n);
        WrapperUtils.throwOnError(n2);
    }

    public void stopSinglePoseDetection(int n, String string) {
        int n2 = NativeMethods.xnStopSinglePoseDetection(this.toNative(), n, string);
        WrapperUtils.throwOnError(n2);
    }

    public IObservable getPoseDetectedEvent() {
        return this.poseDetectedEvent;
    }

    public IObservable getOutOfPoseEvent() {
        return this.outOfPoseEvent;
    }

    public IObservable getPoseDetectionInProgressEvent() {
        return this.poseDetectionInProgressEvent;
    }
}

