/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.Capability;
import org.OpenNI.MapOutputMode;
import org.OpenNI.NativeMethods;
import org.OpenNI.ObjectWrapper;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.Version;
import org.OpenNI.WrapperUtils;

public class Query
extends ObjectWrapper {
    public Query() {
        super(Query.allocate());
    }

    public void setVendor(String string) {
        int n = NativeMethods.xnNodeQuerySetVendor(this.toNative(), string);
        WrapperUtils.throwOnError(n);
    }

    public void setName(String string) {
        int n = NativeMethods.xnNodeQuerySetName(this.toNative(), string);
        WrapperUtils.throwOnError(n);
    }

    public void setMinVersion(Version version) {
        int n = NativeMethods.xnNodeQuerySetMinVersion(this.toNative(), version.getMajor(), version.getMinor(), version.getMaintenance(), version.getBuild());
        WrapperUtils.throwOnError(n);
    }

    public void setMaxVersion(Version version) {
        int n = NativeMethods.xnNodeQuerySetMaxVersion(this.toNative(), version.getMajor(), version.getMinor(), version.getMaintenance(), version.getBuild());
        WrapperUtils.throwOnError(n);
    }

    public void addSupportedCapability(Capability capability) {
        int n = NativeMethods.xnNodeQueryAddSupportedCapability(this.toNative(), capability.getName());
        WrapperUtils.throwOnError(n);
    }

    public void addSupportedMapOutputMode(MapOutputMode mapOutputMode) {
        int n = NativeMethods.xnNodeQueryAddSupportedMapOutputMode(this.toNative(), mapOutputMode.getXRes(), mapOutputMode.getYRes(), mapOutputMode.getFPS());
        WrapperUtils.throwOnError(n);
    }

    public void addSupportedMinUserPositions(int n) {
        int n2 = NativeMethods.xnNodeQuerySetSupportedMinUserPositions(this.toNative(), n);
        WrapperUtils.throwOnError(n2);
    }

    public void setExistingNodeOnly(boolean bl) {
        int n = NativeMethods.xnNodeQuerySetExistingNodeOnly(this.toNative(), bl);
        WrapperUtils.throwOnError(n);
    }

    public void setNonExistingNodeOnly(boolean bl) {
        int n = NativeMethods.xnNodeQuerySetNonExistingNodeOnly(this.toNative(), bl);
        WrapperUtils.throwOnError(n);
    }

    public void addNeededNode(ProductionNode productionNode) {
        int n = NativeMethods.xnNodeQueryAddNeededNode(this.toNative(), productionNode.getName());
        WrapperUtils.throwOnError(n);
    }

    public void setCreationInfo(String string) {
        int n = NativeMethods.xnNodeQuerySetCreationInfo(this.toNative(), string);
        WrapperUtils.throwOnError(n);
    }

    protected void freeObject(long l2) {
        NativeMethods.xnNodeQueryFree(l2);
    }

    private static long allocate() {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnNodeQueryAllocate(outArg);
        WrapperUtils.throwOnError(n);
        return (Long)outArg.value;
    }
}

