/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import java.util.NoSuchElementException;
import org.OpenNI.NativeMethods;

public enum Resolution {
    CUSTOM(0),
    QQVGA(1),
    CGA(2),
    QVGA(3),
    VGA(4),
    SVGA(5),
    XGA(6),
    P720(7),
    SXGA(8),
    UXGA(9),
    P1080(10);

    private final int val;
    private final int xRes;
    private final int yRes;
    private final String name;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private Resolution() {
        void var3_2;
        this.val = var3_2;
        this.xRes = NativeMethods.xnResolutionGetXRes((int)var3_2);
        this.yRes = NativeMethods.xnResolutionGetYRes((int)var3_2);
        this.name = NativeMethods.xnResolutionGetName((int)var3_2);
    }

    public int getxRes() {
        return this.xRes;
    }

    public int getyRes() {
        return this.yRes;
    }

    public String getName() {
        return this.name;
    }

    public int toNative() {
        return this.val;
    }

    public static Resolution fromNative(int n) {
        Resolution[] resolutionArray = Resolution.values();
        int n2 = resolutionArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Resolution resolution = resolutionArray[n3];
            if (resolution.val == n) {
                return resolution;
            }
            ++n3;
        }
        throw new NoSuchElementException();
    }

    public static Resolution fromName(String string) {
        return Resolution.fromNative(NativeMethods.xnResolutionGetFromName(string));
    }

    public static Resolution fromXYRes(int n, int n2) {
        return Resolution.fromNative(NativeMethods.xnResolutionGetFromXYRes(n, n2));
    }
}

