/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.Context;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.MapGenerator;
import org.OpenNI.MapOutputMode;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.OutArg;
import org.OpenNI.Plane3D;
import org.OpenNI.Point3D;
import org.OpenNI.Query;
import org.OpenNI.SceneMap;
import org.OpenNI.SceneMetaData;
import org.OpenNI.WrapperUtils;

public class SceneAnalyzer
extends MapGenerator {
    private SceneMap currSceneMap;
    private int currSceneMapFrameID;

    SceneAnalyzer(Context context, long l2, boolean bl) {
        super(context, l2, bl);
    }

    public static SceneAnalyzer create(Context context, Query query, EnumerationErrors enumerationErrors) {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnCreateSceneAnalyzer(context.toNative(), outArg, query == null ? 0L : query.toNative(), enumerationErrors == null ? 0L : enumerationErrors.toNative());
        WrapperUtils.throwOnError(n);
        SceneAnalyzer sceneAnalyzer = (SceneAnalyzer)context.createProductionNodeObject((Long)outArg.value, NodeType.SCENE);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return sceneAnalyzer;
    }

    public static SceneAnalyzer create(Context context, Query query) {
        return SceneAnalyzer.create(context, query, null);
    }

    public static SceneAnalyzer create(Context context) {
        return SceneAnalyzer.create(context, null, null);
    }

    public SceneMap getSceneMap() {
        int n = this.getFrameID();
        if (this.currSceneMap == null || this.currSceneMapFrameID != n) {
            long l2 = NativeMethods.xnGetLabelMap(this.toNative());
            MapOutputMode mapOutputMode = this.getMapOutputMode();
            this.currSceneMap = new SceneMap(l2, mapOutputMode.getXRes(), mapOutputMode.getYRes());
            this.currSceneMapFrameID = n;
        }
        return this.currSceneMap;
    }

    public void getMetaData(SceneMetaData sceneMetaData) {
        NativeMethods.xnGetSceneMetaData(this.toNative(), sceneMetaData);
    }

    public SceneMetaData getMetaData() {
        SceneMetaData sceneMetaData = new SceneMetaData();
        this.getMetaData(sceneMetaData);
        return sceneMetaData;
    }

    public Plane3D getFloor() {
        OutArg outArg = new OutArg();
        OutArg outArg2 = new OutArg();
        int n = NativeMethods.xnGetFloor(this.toNative(), outArg, outArg2);
        WrapperUtils.throwOnError(n);
        return new Plane3D((Point3D)outArg.value, (Point3D)outArg2.value);
    }
}

