/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.CalibrationProgressEventArgs;
import org.OpenNI.CalibrationProgressStatus;
import org.OpenNI.CalibrationStartEventArgs;
import org.OpenNI.CapabilityBase;
import org.OpenNI.IObservable;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.Observable;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.SkeletonJoint;
import org.OpenNI.SkeletonJointOrientation;
import org.OpenNI.SkeletonJointPosition;
import org.OpenNI.SkeletonJointTransformation;
import org.OpenNI.SkeletonProfile;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.WrapperUtils;

public class SkeletonCapability
extends CapabilityBase {
    private StateChangedObservable jointConfigurationChangeEvent = new StateChangedObservable(){

        protected int registerNative(String string, OutArg outArg) {
            return NativeMethods.xnRegisterToJointConfigurationChange(SkeletonCapability.this.toNative(), this, string, outArg);
        }

        protected void unregisterNative(long l2) {
            NativeMethods.xnUnregisterFromJointConfigurationChange(SkeletonCapability.this.toNative(), l2);
        }
    };
    private Observable calibrationStartEvent = new Observable(){

        protected int registerNative(OutArg outArg) {
            return NativeMethods.xnRegisterToCalibrationStart(SkeletonCapability.this.toNative(), this, "callback", outArg);
        }

        protected void unregisterNative(long l2) {
            NativeMethods.xnUnregisterFromCalibrationStart(SkeletonCapability.this.toNative(), l2);
        }

        public void callback(int n) {
            this.notify(new CalibrationStartEventArgs(n));
        }
    };
    private Observable calibrationInProgressEvent = new Observable(){

        protected int registerNative(OutArg outArg) {
            return NativeMethods.xnRegisterToCalibrationInProgress(SkeletonCapability.this.toNative(), this, "callback", outArg);
        }

        protected void unregisterNative(long l2) {
            NativeMethods.xnUnregisterFromCalibrationInProgress(SkeletonCapability.this.toNative(), l2);
        }

        public void callback(int n, int n2) {
            this.notify(new CalibrationProgressEventArgs(n, CalibrationProgressStatus.fromNative(n2)));
        }
    };
    private Observable calibrationCompleteEvent = new Observable(){

        protected int registerNative(OutArg outArg) {
            return NativeMethods.xnRegisterToCalibrationComplete(SkeletonCapability.this.toNative(), this, "callback", outArg);
        }

        protected void unregisterNative(long l2) {
            NativeMethods.xnUnregisterFromCalibrationComplete(SkeletonCapability.this.toNative(), l2);
        }

        public void callback(int n, int n2) {
            this.notify(new CalibrationProgressEventArgs(n, CalibrationProgressStatus.fromNative(n2)));
        }
    };

    public SkeletonCapability(ProductionNode productionNode) {
        super(productionNode);
    }

    public boolean isJointAvailable(SkeletonJoint skeletonJoint) {
        return NativeMethods.xnIsJointAvailable(this.toNative(), skeletonJoint.toNative());
    }

    public boolean isProfileAvailable(SkeletonProfile skeletonProfile) {
        return NativeMethods.xnIsProfileAvailable(this.toNative(), skeletonProfile.toNative());
    }

    public void setSkeletonProfile(SkeletonProfile skeletonProfile) {
        int n = NativeMethods.xnSetSkeletonProfile(this.toNative(), skeletonProfile.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void setJointActive(SkeletonJoint skeletonJoint, boolean bl) {
        int n = NativeMethods.xnSetJointActive(this.toNative(), skeletonJoint.toNative(), bl);
        WrapperUtils.throwOnError(n);
    }

    public boolean isJointActive(SkeletonJoint skeletonJoint) {
        return NativeMethods.xnIsJointActive(this.toNative(), skeletonJoint.toNative());
    }

    public SkeletonJoint[] enumerateActiveJoints() {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnEnumerateActiveJoints(this.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        SkeletonJoint[] skeletonJointArray = new SkeletonJoint[((Integer[])outArg.value).length];
        int n2 = 0;
        while (n2 < ((Integer[])outArg.value).length) {
            skeletonJointArray[n2] = SkeletonJoint.fromNative(((Integer[])outArg.value)[n2]);
            ++n2;
        }
        return skeletonJointArray;
    }

    public SkeletonJointTransformation getSkeletonJoint(int n, SkeletonJoint skeletonJoint) {
        OutArg outArg = new OutArg();
        int n2 = NativeMethods.xnGetSkeletonJoint(this.toNative(), n, skeletonJoint.toNative(), outArg);
        WrapperUtils.throwOnError(n2);
        return (SkeletonJointTransformation)outArg.value;
    }

    public SkeletonJointPosition getSkeletonJointPosition(int n, SkeletonJoint skeletonJoint) {
        OutArg outArg = new OutArg();
        int n2 = NativeMethods.xnGetSkeletonJointPosition(this.toNative(), n, skeletonJoint.toNative(), outArg);
        WrapperUtils.throwOnError(n2);
        return (SkeletonJointPosition)outArg.value;
    }

    public SkeletonJointOrientation getSkeletonJointOrientation(int n, SkeletonJoint skeletonJoint) {
        OutArg outArg = new OutArg();
        int n2 = NativeMethods.xnGetSkeletonJointOrientation(this.toNative(), n, skeletonJoint.toNative(), outArg);
        WrapperUtils.throwOnError(n2);
        return (SkeletonJointOrientation)outArg.value;
    }

    public boolean isSkeletonTracking(int n) {
        return NativeMethods.xnIsSkeletonTracking(this.toNative(), n);
    }

    public boolean isSkeletonCalibrated(int n) {
        return NativeMethods.xnIsSkeletonCalibrated(this.toNative(), n);
    }

    public boolean isSkeletonCalibrating(int n) {
        return NativeMethods.xnIsSkeletonCalibrating(this.toNative(), n);
    }

    public void requestSkeletonCalibration(int n, boolean bl) {
        int n2 = NativeMethods.xnRequestSkeletonCalibration(this.toNative(), n, bl);
        WrapperUtils.throwOnError(n2);
    }

    public void requestSkeletonCalibration(int n) {
        this.requestSkeletonCalibration(n, false);
    }

    public void abortSkeletonCalibration(int n) {
        int n2 = NativeMethods.xnAbortSkeletonCalibration(this.toNative(), n);
        WrapperUtils.throwOnError(n2);
    }

    public void saveSkeletonCalibrationDataToFile(int n, String string) {
        int n2 = NativeMethods.xnSaveSkeletonCalibrationDataToFile(this.toNative(), n, string);
        WrapperUtils.throwOnError(n2);
    }

    public void loadSkeletonCalibrationDatadFromFile(int n, String string) {
        int n2 = NativeMethods.xnLoadSkeletonCalibrationDataFromFile(this.toNative(), n, string);
        WrapperUtils.throwOnError(n2);
    }

    public void saveSkeletonCalibrationData(int n, int n2) {
        int n3 = NativeMethods.xnSaveSkeletonCalibrationData(this.toNative(), n, n2);
        WrapperUtils.throwOnError(n3);
    }

    public void loadSkeletonCalibrationData(int n, int n2) {
        int n3 = NativeMethods.xnLoadSkeletonCalibrationData(this.toNative(), n, n2);
        WrapperUtils.throwOnError(n3);
    }

    public void clearSkeletonCalibrationData(int n) {
        int n2 = NativeMethods.xnClearSkeletonCalibrationData(this.toNative(), n);
        WrapperUtils.throwOnError(n2);
    }

    public boolean isSkeletonCalibrationData(int n) {
        return NativeMethods.xnIsSkeletonCalibrationData(this.toNative(), n);
    }

    public void startTracking(int n) {
        int n2 = NativeMethods.xnStartSkeletonTracking(this.toNative(), n);
        WrapperUtils.throwOnError(n2);
    }

    public void stopTracking(int n) {
        int n2 = NativeMethods.xnStopSkeletonTracking(this.toNative(), n);
        WrapperUtils.throwOnError(n2);
    }

    public void reset(int n) {
        int n2 = NativeMethods.xnResetSkeleton(this.toNative(), n);
        WrapperUtils.throwOnError(n2);
    }

    public boolean needPoseForCalibration() {
        return NativeMethods.xnNeedPoseForSkeletonCalibration(this.toNative());
    }

    public String getSkeletonCalibrationPose() {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnGetSkeletonCalibrationPose(this.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        return (String)outArg.value;
    }

    public void setSmoothing(float f2) {
        int n = NativeMethods.xnSetSkeletonSmoothing(this.toNative(), f2);
        WrapperUtils.throwOnError(n);
    }

    public IStateChangedObservable getJointConfigurationChangeEvent() {
        return this.jointConfigurationChangeEvent;
    }

    public IObservable getCalibrationStartEvent() {
        return this.calibrationStartEvent;
    }

    public IObservable getCalibrationInProgressEvent() {
        return this.calibrationInProgressEvent;
    }

    public IObservable getCalibrationCompleteEvent() {
        return this.calibrationCompleteEvent;
    }
}

