/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import java.util.Hashtable;
import org.OpenNI.AudioGenerator;
import org.OpenNI.Codec;
import org.OpenNI.DepthGenerator;
import org.OpenNI.Device;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.ErrorStateEventArgs;
import org.OpenNI.GeneralException;
import org.OpenNI.Generator;
import org.OpenNI.GestureGenerator;
import org.OpenNI.HandsGenerator;
import org.OpenNI.IObservable;
import org.OpenNI.IRGenerator;
import org.OpenNI.ImageGenerator;
import org.OpenNI.License;
import org.OpenNI.MapGenerator;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeInfo;
import org.OpenNI.NodeInfoList;
import org.OpenNI.NodeType;
import org.OpenNI.ObjectWrapper;
import org.OpenNI.Observable;
import org.OpenNI.OutArg;
import org.OpenNI.Player;
import org.OpenNI.ProductionNode;
import org.OpenNI.Query;
import org.OpenNI.Recorder;
import org.OpenNI.SceneAnalyzer;
import org.OpenNI.ScriptNode;
import org.OpenNI.UserGenerator;
import org.OpenNI.Version;
import org.OpenNI.WrapperUtils;

public class Context
extends ObjectWrapper {
    private Observable errorStateChangedEvent;
    private Hashtable allNodes = new Hashtable();
    private static Hashtable allContexts = new Hashtable();

    public Context() {
        this(Context.init(), false);
    }

    public static Context createFromXmlFile(String string, OutArg outArg) {
        OutArg outArg2 = new OutArg();
        long l = Context.initFromXmlEx(string, outArg2);
        Context context = new Context(l, false);
        outArg.value = new ScriptNode(context, (Long)outArg2.value, false);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Context fromNative(long l) {
        Hashtable hashtable = allContexts;
        synchronized (hashtable) {
            if (allContexts.containsKey(l)) {
                return (Context)allContexts.get(l);
            }
            return new Context(l);
        }
    }

    public static Version getVersion() {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnGetVersion(outArg);
        WrapperUtils.throwOnError(n);
        return (Version)outArg.value;
    }

    public ScriptNode runXmlScriptFromFile(String string) {
        EnumerationErrors enumerationErrors = new EnumerationErrors();
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnContextRunXmlScriptFromFileEx(this.toNative(), string, enumerationErrors.toNative(), outArg);
        WrapperUtils.checkEnumeration(n, enumerationErrors);
        return new ScriptNode(this, (Long)outArg.value, false);
    }

    public ScriptNode runXmlScript(String string) {
        EnumerationErrors enumerationErrors = new EnumerationErrors();
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnContextRunXmlScriptEx(this.toNative(), string, enumerationErrors.toNative(), outArg);
        WrapperUtils.checkEnumeration(n, enumerationErrors);
        return new ScriptNode(this, (Long)outArg.value, false);
    }

    public Player openFileRecordingEx(String string) {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnContextOpenFileRecordingEx(this.toNative(), string, outArg);
        WrapperUtils.throwOnError(n);
        return (Player)Context.createProductionNodeFromNative((Long)outArg.value);
    }

    public void release() {
        this.dispose();
    }

    public void addLicense(License license) {
        int n = NativeMethods.xnAddLicense(this.toNative(), license.getVendor(), license.getKey());
        WrapperUtils.throwOnError(n);
    }

    public License[] enumerateLicenses() {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnEnumerateLicenses(this.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        return (License[])outArg.value;
    }

    public NodeInfoList enumerateProductionTrees(NodeType nodeType, Query query) {
        EnumerationErrors enumerationErrors = new EnumerationErrors();
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnEnumerateProductionTrees(this.toNative(), nodeType.toNative(), query == null ? 0L : query.toNative(), outArg, enumerationErrors.toNative());
        WrapperUtils.checkEnumeration(n, enumerationErrors);
        return new NodeInfoList((Long)outArg.value);
    }

    public NodeInfoList enumerateProductionTrees(NodeType nodeType) {
        return this.enumerateProductionTrees(nodeType, null);
    }

    public ProductionNode createProductionTree(NodeInfo nodeInfo) {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnCreateProductionTree(this.toNative(), nodeInfo.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        return this.createProductionNodeObject((Long)outArg.value);
    }

    public ProductionNode createAnyProductionTree(NodeType nodeType, Query query) {
        EnumerationErrors enumerationErrors = new EnumerationErrors();
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnCreateAnyProductionTree(this.toNative(), nodeType.toNative(), query == null ? 0L : query.toNative(), outArg, enumerationErrors.toNative());
        WrapperUtils.checkEnumeration(n, enumerationErrors);
        return Context.createProductionNodeFromNative((Long)outArg.value);
    }

    public NodeInfoList enumerateExistingNodes() {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnEnumerateExistingNodes(this.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        return new NodeInfoList((Long)outArg.value);
    }

    public NodeInfoList enumerateExistingNodes(NodeType nodeType) {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnEnumerateExistingNodesByType(this.toNative(), nodeType.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        return new NodeInfoList((Long)outArg.value);
    }

    public ProductionNode findExistingNode(NodeType nodeType) {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnFindExistingRefNodeByType(this.toNative(), nodeType.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        ProductionNode productionNode = this.createProductionNodeObject((Long)outArg.value, nodeType);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return productionNode;
    }

    public ProductionNode getProductionNodeByName(String string) {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnGetRefNodeHandleByName(this.toNative(), string, outArg);
        WrapperUtils.throwOnError(n);
        ProductionNode productionNode = this.createProductionNodeObject((Long)outArg.value);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return productionNode;
    }

    public NodeInfo getProductionNodeInfoByName(String string) {
        return this.getProductionNodeByName(string).getInfo();
    }

    public void startGeneratingAll() {
        int n = NativeMethods.xnStartGeneratingAll(this.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void stopGeneratingAll() {
        int n = NativeMethods.xnStopGeneratingAll(this.toNative());
        WrapperUtils.throwOnError(n);
    }

    public boolean getGlobalMirror() {
        return NativeMethods.xnGetGlobalMirror(this.toNative());
    }

    public void setGlobalMirror(boolean bl) {
        int n = NativeMethods.xnSetGlobalMirror(this.toNative(), bl);
        WrapperUtils.throwOnError(n);
    }

    public void waitAndUpdateAll() {
        int n = NativeMethods.xnWaitAndUpdateAll(this.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void waitOneUpdateAll(ProductionNode productionNode) {
        int n = NativeMethods.xnWaitOneUpdateAll(this.toNative(), productionNode.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void waitAnyUpdateAll() {
        int n = NativeMethods.xnWaitAnyUpdateAll(this.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void waitNoneUpdateAll() {
        int n = NativeMethods.xnWaitNoneUpdateAll(this.toNative());
        WrapperUtils.throwOnError(n);
    }

    public IObservable getErrorStateChangedEvent() {
        return this.errorStateChangedEvent;
    }

    public static ProductionNode createProductionNodeFromNative(long l) {
        long l2 = NativeMethods.xnGetRefContextFromNodeHandle(l);
        Context context = Context.fromNative(l2);
        NativeMethods.xnContextRelease(l2);
        return context.createProductionNodeObject(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeObject(long l) {
        Hashtable hashtable = allContexts;
        synchronized (hashtable) {
            allContexts.remove(l);
        }
        NativeMethods.xnContextRelease(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context(long l, boolean bl) {
        super(l);
        this.errorStateChangedEvent = new Observable(){

            protected int registerNative(OutArg outArg) {
                return NativeMethods.xnRegisterToGlobalErrorStateChange(Context.this.toNative(), this, "callback", outArg);
            }

            protected void unregisterNative(long l) {
                NativeMethods.xnUnregisterFromGlobalErrorStateChange(Context.this.toNative(), l);
            }

            public void callback(int n) {
                this.notify(new ErrorStateEventArgs(n));
            }
        };
        Hashtable hashtable = allContexts;
        synchronized (hashtable) {
            if (allContexts.containsKey(l)) {
                throw new GeneralException("Java wrapper: creating a Context object wrapping an already wrapped object!");
            }
            allContexts.put(l, this);
        }
        if (bl) {
            WrapperUtils.throwOnError(NativeMethods.xnContextAddRef(l));
        }
    }

    private Context(long l) {
        this(l, true);
    }

    private static long init() {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnInit(outArg);
        WrapperUtils.throwOnError(n);
        return (Long)outArg.value;
    }

    private static long initFromXmlEx(String string, OutArg outArg) {
        OutArg outArg2 = new OutArg();
        int n = NativeMethods.xnInitFromXmlFileEx(string, outArg2, 0L, outArg);
        WrapperUtils.throwOnError(n);
        return (Long)outArg2.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProductionNode createProductionNodeObject(long l, NodeType nodeType) {
        Hashtable hashtable = this.allNodes;
        synchronized (hashtable) {
            if (!this.allNodes.containsKey(l)) {
                ProductionNode productionNode;
                if (nodeType.equals(NodeType.DEVICE)) {
                    productionNode = new Device(this, l, true);
                } else if (nodeType.equals(NodeType.DEPTH)) {
                    productionNode = new DepthGenerator(this, l, true);
                } else if (nodeType.equals(NodeType.IMAGE)) {
                    productionNode = new ImageGenerator(this, l, true);
                } else if (nodeType.equals(NodeType.AUDIO)) {
                    productionNode = new AudioGenerator(this, l, true);
                } else if (nodeType.equals(NodeType.IR)) {
                    productionNode = new IRGenerator(this, l, true);
                } else if (nodeType.equals(NodeType.USER)) {
                    productionNode = new UserGenerator(this, l, true);
                } else if (nodeType.equals(NodeType.RECORDER)) {
                    productionNode = new Recorder(this, l, true);
                } else if (nodeType.equals(NodeType.PLAYER)) {
                    productionNode = new Player(this, l, true);
                } else if (nodeType.equals(NodeType.GESTURE)) {
                    productionNode = new GestureGenerator(this, l, true);
                } else if (nodeType.equals(NodeType.SCENE)) {
                    productionNode = new SceneAnalyzer(this, l, true);
                } else if (nodeType.equals(NodeType.HANDS)) {
                    productionNode = new HandsGenerator(this, l, true);
                } else if (nodeType.equals(NodeType.CODEC)) {
                    productionNode = new Codec(this, l, true);
                } else if (nodeType.equals(NodeType.SCRIPT_NODE)) {
                    productionNode = new ScriptNode(this, l, true);
                } else if (nodeType.equals(NodeType.PRODUCTION_NODE)) {
                    productionNode = new ProductionNode(this, l, true);
                } else if (nodeType.equals(NodeType.GENERATOR)) {
                    productionNode = new Generator(this, l, true);
                } else if (nodeType.equals(NodeType.MAP_GENERATOR)) {
                    productionNode = new MapGenerator(this, l, true);
                } else {
                    throw new GeneralException("java wrapper: Unknown generator type!");
                }
                this.allNodes.put(l, productionNode);
            }
            return (ProductionNode)this.allNodes.get(l);
        }
    }

    ProductionNode createProductionNodeObject(long l) {
        long l2 = NativeMethods.xnGetNodeInfo(l);
        NodeType nodeType = NativeMethods.xnNodeInfoGetDescription(l2).getType();
        return this.createProductionNodeObject(l, nodeType);
    }
}

