/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.Capability;
import org.OpenNI.CapabilityBase;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.WrapperUtils;

public class GeneralIntCapability
extends CapabilityBase {
    private StateChangedObservable valueChanged;
    private final String capName;
    private int min;
    private int max;
    private int step;
    private int defaultVal;
    private boolean autoSupported;

    public GeneralIntCapability(ProductionNode productionNode, Capability capability) {
        super(productionNode);
        this.capName = capability.getName();
        OutArg outArg = new OutArg();
        OutArg outArg2 = new OutArg();
        OutArg outArg3 = new OutArg();
        OutArg outArg4 = new OutArg();
        OutArg outArg5 = new OutArg();
        int n = NativeMethods.xnGetGeneralIntRange(this.toNative(), this.getCapName(), outArg, outArg2, outArg3, outArg4, outArg5);
        WrapperUtils.throwOnError(n);
        this.min = (Integer)outArg.value;
        this.max = (Integer)outArg2.value;
        this.step = (Integer)outArg3.value;
        this.defaultVal = (Integer)outArg4.value;
        this.autoSupported = (Boolean)outArg5.value;
        this.valueChanged = new StateChangedObservable(){

            protected int registerNative(String string, OutArg outArg) {
                return NativeMethods.xnRegisterToGeneralIntValueChange(GeneralIntCapability.this.toNative(), GeneralIntCapability.this.getCapName(), this, string, outArg);
            }

            protected void unregisterNative(long l) {
                NativeMethods.xnUnregisterFromNodeErrorStateChange(GeneralIntCapability.this.toNative(), l);
            }
        };
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getStep() {
        return this.step;
    }

    public int getDefault() {
        return this.defaultVal;
    }

    public boolean isAutoSupported() {
        return this.autoSupported;
    }

    public int getValue() {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnGetGeneralIntValue(this.toNative(), this.capName, outArg);
        WrapperUtils.throwOnError(n);
        return (Integer)outArg.value;
    }

    public void setValue(int n) {
        int n2 = NativeMethods.xnSetGeneralIntValue(this.toNative(), this.capName, n);
        WrapperUtils.throwOnError(n2);
    }

    public IStateChangedObservable getValueChangedEvent() {
        return this.valueChanged;
    }

    String getCapName() {
        return this.capName;
    }
}

