/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.OpenNI.Context;
import org.OpenNI.GeneralException;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeInfo;
import org.OpenNI.ObjectWrapper;
import org.OpenNI.ProductionNodeDescription;
import org.OpenNI.Query;
import org.OpenNI.WrapperUtils;

public class NodeInfoList
extends ObjectWrapper
implements Iterable {
    NodeInfoList(long l) {
        super(l);
    }

    public void add(ProductionNodeDescription productionNodeDescription, String string, NodeInfoList nodeInfoList) {
        long l = productionNodeDescription.createNative();
        int n = NativeMethods.xnNodeInfoListAdd(this.toNative(), l, string, nodeInfoList == null ? 0L : nodeInfoList.toNative());
        ProductionNodeDescription.freeNative(l);
        WrapperUtils.throwOnError(n);
    }

    public void addNode(NodeInfo nodeInfo) {
        int n = NativeMethods.xnNodeInfoListAddNode(this.toNative(), nodeInfo.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void addNodeFromList(Iterator iterator) {
        NodeInfoListIterator nodeInfoListIterator = (NodeInfoListIterator)iterator;
        int n = NativeMethods.xnNodeInfoListAddNodeFromList(this.toNative(), nodeInfoListIterator.it);
        WrapperUtils.throwOnError(n);
    }

    public void remove(Iterator iterator) {
        NodeInfoListIterator nodeInfoListIterator = (NodeInfoListIterator)iterator;
        int n = NativeMethods.xnNodeInfoListRemove(this.toNative(), nodeInfoListIterator.it);
        WrapperUtils.throwOnError(n);
    }

    public void clear() {
        int n = NativeMethods.xnNodeInfoListClear(this.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void append(NodeInfoList nodeInfoList) {
        int n = NativeMethods.xnNodeInfoListAppend(this.toNative(), nodeInfoList.toNative());
        WrapperUtils.throwOnError(n);
    }

    public boolean isEmpty() {
        return NativeMethods.xnNodeInfoListIsEmpty(this.toNative());
    }

    public void filter(Query query, Context context) {
        int n = NativeMethods.xnNodeQueryFilterList(context.toNative(), query.toNative(), this.toNative());
        WrapperUtils.throwOnError(n);
    }

    public Iterator iterator() {
        return new NodeInfoListIterator(this.toNative());
    }

    protected void freeObject(long l) {
        NativeMethods.xnNodeInfoListFree(l);
    }

    private class NodeInfoListIterator
    implements Iterator {
        protected long it;

        NodeInfoListIterator(long l) {
            this.it = NativeMethods.xnNodeInfoListGetFirst(l);
        }

        public boolean hasNext() {
            return NativeMethods.xnNodeInfoListIteratorIsValid(this.it);
        }

        public NodeInfo next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            NodeInfo nodeInfo = null;
            try {
                nodeInfo = new NodeInfo(NativeMethods.xnNodeInfoListGetCurrent(this.it));
            }
            catch (GeneralException generalException) {}
            this.it = NativeMethods.xnNodeInfoListGetNext(this.it);
            return nodeInfo;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

