/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.Context;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.Generator;
import org.OpenNI.IObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.Observable;
import org.OpenNI.OutArg;
import org.OpenNI.Point3D;
import org.OpenNI.PoseDetectionCapability;
import org.OpenNI.Query;
import org.OpenNI.SceneMetaData;
import org.OpenNI.SkeletonCapability;
import org.OpenNI.UserEventArgs;
import org.OpenNI.WrapperUtils;

public class UserGenerator
extends Generator {
    private Observable newUserEvent = new Observable(){

        protected int registerNative(OutArg outArg) {
            return NativeMethods.xnRegisterUserCallbacks(UserGenerator.this.toNative(), this, "callback", null, outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterUserCallbacks(UserGenerator.this.toNative(), l);
        }

        public void callback(int n) {
            this.notify(new UserEventArgs(n));
        }
    };
    private Observable lostUserEvent = new Observable(){

        protected int registerNative(OutArg outArg) {
            return NativeMethods.xnRegisterUserCallbacks(UserGenerator.this.toNative(), this, null, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterUserCallbacks(UserGenerator.this.toNative(), l);
        }

        public void callback(int n) {
            this.notify(new UserEventArgs(n));
        }
    };
    private Observable userExitEvent = new Observable(){

        protected int registerNative(OutArg outArg) {
            return NativeMethods.xnRegisterToUserExit(UserGenerator.this.toNative(), this, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromUserExit(UserGenerator.this.toNative(), l);
        }

        public void callback(int n) {
            this.notify(new UserEventArgs(n));
        }
    };
    private Observable userReenterEvent = new Observable(){

        protected int registerNative(OutArg outArg) {
            return NativeMethods.xnRegisterToUserReEnter(UserGenerator.this.toNative(), this, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromUserExit(UserGenerator.this.toNative(), l);
        }

        public void callback(int n) {
            this.notify(new UserEventArgs(n));
        }
    };

    UserGenerator(Context context, long l, boolean bl) {
        super(context, l, bl);
    }

    public static UserGenerator create(Context context, Query query, EnumerationErrors enumerationErrors) {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnCreateUserGenerator(context.toNative(), outArg, query == null ? 0L : query.toNative(), enumerationErrors == null ? 0L : enumerationErrors.toNative());
        WrapperUtils.throwOnError(n);
        UserGenerator userGenerator = (UserGenerator)context.createProductionNodeObject((Long)outArg.value, NodeType.USER);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return userGenerator;
    }

    public static UserGenerator create(Context context, Query query) {
        return UserGenerator.create(context, query, null);
    }

    public static UserGenerator create(Context context) {
        return UserGenerator.create(context, null, null);
    }

    public int getNumberOfUsers() {
        return NativeMethods.xnGetNumberOfUsers(this.toNative());
    }

    public int[] getUsers() {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnGetUsers(this.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        int[] nArray = new int[((Integer[])outArg.value).length];
        int n2 = 0;
        while (n2 < ((Integer[])outArg.value).length) {
            nArray[n2] = ((Integer[])outArg.value)[n2];
            ++n2;
        }
        return nArray;
    }

    public Point3D getUserCoM(int n) {
        OutArg outArg = new OutArg();
        int n2 = NativeMethods.xnGetUserCoM(this.toNative(), n, outArg);
        WrapperUtils.throwOnError(n2);
        return (Point3D)outArg.value;
    }

    public void getUserPixels(int n, SceneMetaData sceneMetaData) {
        NativeMethods.xnGetUserPixels(this.toNative(), n, sceneMetaData);
    }

    public SceneMetaData getUserPixels(int n) {
        SceneMetaData sceneMetaData = new SceneMetaData();
        this.getUserPixels(n, sceneMetaData);
        return sceneMetaData;
    }

    public PoseDetectionCapability getPoseDetectionCapability() {
        return new PoseDetectionCapability(this);
    }

    public SkeletonCapability getSkeletonCapability() {
        return new SkeletonCapability(this);
    }

    public IObservable getNewUserEvent() {
        return this.newUserEvent;
    }

    public IObservable getLostUserEvent() {
        return this.lostUserEvent;
    }

    public IObservable getUserExitEvent() {
        return this.userExitEvent;
    }

    public IObservable getUserReenterEvent() {
        return this.userReenterEvent;
    }
}

