/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.BoundingBox3D;
import org.OpenNI.CapabilityBase;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.OutArg;
import org.OpenNI.Point3D;
import org.OpenNI.ProductionNode;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.WrapperUtils;

public class UserPositionCapability
extends CapabilityBase {
    private StateChangedObservable userPositionChanged = new StateChangedObservable(){

        protected int registerNative(String string, OutArg outArg) {
            return NativeMethods.xnRegisterToUserPositionChange(UserPositionCapability.this.toNative(), this, string, outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromUserPositionChange(UserPositionCapability.this.toNative(), l);
        }
    };

    public UserPositionCapability(ProductionNode productionNode) {
        super(productionNode);
    }

    public int getSupportedCount() {
        return NativeMethods.xnGetSupportedUserPositionsCount(this.toNative());
    }

    public void setUserPosition(int n, BoundingBox3D boundingBox3D) {
        Point3D point3D = boundingBox3D.getLeftBottomNear();
        Point3D point3D2 = boundingBox3D.getRightTopFar();
        int n2 = NativeMethods.xnSetUserPosition(this.toNative(), n, point3D.getX(), point3D.getY(), point3D.getZ(), point3D2.getX(), point3D2.getY(), point3D2.getZ());
        WrapperUtils.throwOnError(n2);
    }

    public BoundingBox3D getUserPosition(int n) {
        OutArg outArg = new OutArg();
        int n2 = NativeMethods.xnGetUserPosition(this.toNative(), n, outArg);
        WrapperUtils.throwOnError(n2);
        return (BoundingBox3D)outArg.value;
    }

    public IStateChangedObservable getUserPositionChangedEvent() {
        return this.userPositionChanged;
    }
}

