/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.os;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.AndroidVersion;
import com.jogamp.common.os.DynamicLibraryBundle;
import com.jogamp.common.os.MachineDescription;
import com.jogamp.common.util.JarUtil;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.common.util.cache.TempJarCache;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.TimeUnit;
import jogamp.common.Debug;
import jogamp.common.jvm.JVMUtil;
import jogamp.common.os.MachineDescriptionRuntime;

public class Platform {
    private static final String libBaseName = "gluegen-rt";
    public static final boolean USE_TEMP_JAR_CACHE;
    private static final String useTempJarCachePropName = "jogamp.gluegen.UseTempJarCache";
    public static final boolean AWT_AVAILABLE;
    public static final boolean JAVA_SE;
    public static final boolean LITTLE_ENDIAN;
    public static final String OS;
    public static final String OS_lower;
    public static final String OS_VERSION;
    public static final VersionNumber OS_VERSION_NUMBER;
    public static final String ARCH;
    public static final String ARCH_lower;
    public static final String JAVA_VENDOR;
    public static final String JAVA_VENDOR_URL;
    public static final String JAVA_VM_NAME;
    public static final String JAVA_RUNTIME_NAME;
    public static final String JAVA_VERSION;
    public static final VersionNumber JAVA_VERSION_NUMBER;
    public static final String NEWLINE;
    public static final OSType OS_TYPE;
    public static final CPUType CPU_ARCH;
    public static final ABIType ABI_TYPE;
    private static final boolean is32Bit;
    private static final MachineDescription machineDescription;
    private static final String os_and_arch;

    private Platform() {
    }

    private static boolean isRunningFromJarURL() {
        return JarUtil.hasJarURL(Platform.class.getName(), Platform.class.getClassLoader());
    }

    private static boolean queryIsLittleEndianImpl() {
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(4);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        intBuffer.put(0, 168496141);
        return 3085 == shortBuffer.get(0);
    }

    private static CPUType getCPUTypeImpl(String string) {
        if (string.equals("x86") || string.equals("i386") || string.equals("i486") || string.equals("i586") || string.equals("i686")) {
            return CPUType.X86_32;
        }
        if (string.equals("x86_64") || string.equals("amd64")) {
            return CPUType.X86_64;
        }
        if (string.equals("ia64")) {
            return CPUType.IA64;
        }
        if (string.equals("arm")) {
            return CPUType.ARM;
        }
        if (string.equals("armv5l")) {
            return CPUType.ARMv5;
        }
        if (string.equals("armv6l")) {
            return CPUType.ARMv6;
        }
        if (string.equals("armv7l")) {
            return CPUType.ARMv7;
        }
        if (string.equals("sparc")) {
            return CPUType.SPARC_32;
        }
        if (string.equals("sparcv9")) {
            return CPUType.SPARCV9_64;
        }
        if (string.equals("pa_risc2.0")) {
            return CPUType.PA_RISC2_0;
        }
        if (string.equals("ppc")) {
            return CPUType.PPC;
        }
        throw new RuntimeException("Please port CPU detection to your platform (" + OS_lower + "/" + string + ")");
    }

    private static boolean contains(String string, String[] stringArray) {
        if (null != string && null != stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (string.indexOf(stringArray[i]) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private static ABIType guessABITypeImpl(CPUType cPUType) {
        if (CPUFamily.ARM != cPUType.family) {
            return ABIType.GENERIC_ABI;
        }
        return AccessController.doPrivileged(new PrivilegedAction<ABIType>(){
            private final String[] gnueabihf = new String[]{"gnueabihf", "armhf"};

            @Override
            public ABIType run() {
                if (Platform.contains(System.getProperty("sun.boot.library.path"), this.gnueabihf) || Platform.contains(System.getProperty("java.library.path"), this.gnueabihf) || Platform.contains(System.getProperty("java.home"), this.gnueabihf)) {
                    return ABIType.EABI_GNU_ARMHF;
                }
                return ABIType.EABI_GNU_ARMEL;
            }
        });
    }

    private static OSType getOSTypeImpl() throws RuntimeException {
        if (AndroidVersion.isAvailable) {
            return OSType.ANDROID;
        }
        if (OS_lower.startsWith("linux")) {
            return OSType.LINUX;
        }
        if (OS_lower.startsWith("freebsd")) {
            return OSType.FREEBSD;
        }
        if (OS_lower.startsWith("android")) {
            return OSType.ANDROID;
        }
        if (OS_lower.startsWith("mac os x") || OS_lower.startsWith("darwin")) {
            return OSType.MACOS;
        }
        if (OS_lower.startsWith("sunos")) {
            return OSType.SUNOS;
        }
        if (OS_lower.startsWith("hp-ux")) {
            return OSType.HPUX;
        }
        if (OS_lower.startsWith("windows")) {
            return OSType.WINDOWS;
        }
        if (OS_lower.startsWith("kd")) {
            return OSType.OPENKODE;
        }
        throw new RuntimeException("Please port OS detection to your platform (" + OS_lower + "/" + ARCH_lower + ")");
    }

    private static String getJavaRuntimeNameImpl() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("java.runtime.name");
            }
        });
    }

    private static boolean initIsJavaSE() {
        if (JAVA_RUNTIME_NAME.indexOf("Java SE") != -1) {
            return true;
        }
        try {
            Class.forName("java.nio.LongBuffer");
            Class.forName("java.nio.DoubleBuffer");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static void loadGlueGenRTImpl() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                if (USE_TEMP_JAR_CACHE && TempJarCache.initSingleton()) {
                    String string = "gluegen-rt-natives-" + os_and_arch + ".jar";
                    ClassLoader classLoader = Platform.class.getClassLoader();
                    try {
                        URL uRL = JarUtil.getURLDirname(JarUtil.getJarSubURL(Platform.class.getName(), classLoader));
                        URL uRL2 = JarUtil.getJarFileURL(uRL, string);
                        TempJarCache.bootstrapNativeLib(Platform.class, Platform.libBaseName, uRL2, classLoader);
                    }
                    catch (Exception exception) {
                        System.err.println("Catched: " + exception.getMessage());
                    }
                }
                DynamicLibraryBundle.GlueJNILibLoader.loadLibrary(Platform.libBaseName, false);
                return null;
            }
        });
    }

    public static void initSingleton() {
    }

    public static boolean isJavaSE() {
        return JAVA_SE;
    }

    public static boolean isLittleEndian() {
        return LITTLE_ENDIAN;
    }

    public static String getOSName() {
        return OS;
    }

    public static String getOSVersion() {
        return OS_VERSION;
    }

    public static VersionNumber getOSVersionNumber() {
        return OS_VERSION_NUMBER;
    }

    public static String getArchName() {
        return ARCH;
    }

    public static OSType getOSType() {
        return OS_TYPE;
    }

    public static CPUFamily getCPUFamily() {
        return CPU_ARCH.getFamily();
    }

    public static CPUType getCPUType() {
        return CPU_ARCH;
    }

    public static String getOSAndArch() {
        return os_and_arch;
    }

    public static String getOSAndArch(OSType oSType, CPUType cPUType, ABIType aBIType) {
        String string;
        switch (cPUType) {
            case X86_32: {
                string = "i586";
                break;
            }
            case ARM: {
                string = "armv7";
                break;
            }
            case ARMv5: {
                string = "armv5";
                break;
            }
            case ARMv6: {
                string = "armv5";
                break;
            }
            case ARMv7: {
                string = "armv7";
                break;
            }
            case SPARC_32: {
                string = "sparc";
                break;
            }
            case PPC: {
                string = "ppc";
                break;
            }
            case X86_64: {
                string = "amd64";
                break;
            }
            case IA64: {
                string = "ia64";
                break;
            }
            case SPARCV9_64: {
                string = "sparcv9";
                break;
            }
            case PA_RISC2_0: {
                string = "risc2.0";
                break;
            }
            default: {
                throw new InternalError("Complete case block");
            }
        }
        if (ABIType.EABI_GNU_ARMHF == aBIType) {
            string = string + "hf";
        }
        switch (oSType) {
            case ANDROID: {
                string = "android-" + string;
                break;
            }
            case MACOS: {
                string = "macosx-universal";
                break;
            }
            case WINDOWS: {
                string = "windows-" + string;
                break;
            }
            case OPENKODE: {
                string = "openkode-" + string;
                break;
            }
            case LINUX: {
                string = "linux-" + string;
                break;
            }
            case FREEBSD: {
                string = "freebsd-" + string;
                break;
            }
            case SUNOS: {
                string = "solaris-" + string;
                break;
            }
            case HPUX: {
                string = "hpux-hppa";
                break;
            }
            default: {
                throw new InternalError("Complete case block");
            }
        }
        return string;
    }

    public static String getJavaVendor() {
        return JAVA_VENDOR;
    }

    public static String getJavaVMName() {
        return JAVA_VM_NAME;
    }

    public static String getJavaRuntimeName() {
        return JAVA_RUNTIME_NAME;
    }

    public static String getJavaVendorURL() {
        return JAVA_VENDOR_URL;
    }

    public static String getJavaVersion() {
        return JAVA_VERSION;
    }

    public static VersionNumber getJavaVersionNumber() {
        return JAVA_VERSION_NUMBER;
    }

    public static String getNewline() {
        return NEWLINE;
    }

    public static boolean is32Bit() {
        return is32Bit;
    }

    public static boolean is64Bit() {
        return !is32Bit;
    }

    public static MachineDescription getMachineDescription() {
        return machineDescription;
    }

    public static synchronized long getCurrentSleepJitter() {
        Platform.getCurrentSleepJitterImpl(TimeUnit.MILLISECONDS.toNanos(10L), 10);
        return Platform.getCurrentSleepJitterImpl(TimeUnit.MILLISECONDS.toNanos(10L), 10);
    }

    private static long getCurrentSleepJitterImpl(long l, int n) {
        long l2 = l / (long)n;
        long l3 = System.nanoTime();
        for (int i = n; i > 0; --i) {
            try {
                TimeUnit.NANOSECONDS.sleep(l2);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return (System.nanoTime() - l3 - l) / (long)n;
    }

    static {
        Object object;
        OS = System.getProperty("os.name");
        OS_lower = OS.toLowerCase();
        OS_VERSION = System.getProperty("os.version");
        OS_VERSION_NUMBER = new VersionNumber(OS_VERSION, ".");
        ARCH = System.getProperty("os.arch");
        ARCH_lower = ARCH.toLowerCase();
        JAVA_VENDOR = System.getProperty("java.vendor");
        JAVA_VENDOR_URL = System.getProperty("java.vendor.url");
        JAVA_VERSION = System.getProperty("java.version");
        JAVA_VERSION_NUMBER = new VersionNumber(JAVA_VERSION, ".");
        NEWLINE = System.getProperty("line.separator");
        JAVA_VM_NAME = System.getProperty("java.vm.name");
        JAVA_RUNTIME_NAME = Platform.getJavaRuntimeNameImpl();
        JAVA_SE = Platform.initIsJavaSE();
        LITTLE_ENDIAN = Platform.queryIsLittleEndianImpl();
        CPU_ARCH = Platform.getCPUTypeImpl(ARCH_lower);
        ABI_TYPE = Platform.guessABITypeImpl(CPU_ARCH);
        OS_TYPE = Platform.getOSTypeImpl();
        os_and_arch = Platform.getOSAndArch(OS_TYPE, CPU_ARCH, ABI_TYPE);
        USE_TEMP_JAR_CACHE = OS_TYPE != OSType.ANDROID && Platform.isRunningFromJarURL() && Debug.getBooleanProperty(useTempJarCachePropName, true, true);
        Platform.loadGlueGenRTImpl();
        JVMUtil.initSingleton();
        MachineDescription machineDescription = MachineDescriptionRuntime.getRuntime();
        if (null == machineDescription) {
            object = MachineDescriptionRuntime.getStatic();
            machineDescription = object.md;
            System.err.println("Warning: Using static MachineDescription: " + (Object)object);
        } else {
            object = MachineDescriptionRuntime.getStatic();
            if (!machineDescription.compatible(object.md)) {
                throw new RuntimeException("Incompatible MachineDescriptions:" + NEWLINE + " Static " + (Object)object + NEWLINE + " Runtime " + machineDescription);
            }
        }
        Platform.machineDescription = machineDescription;
        is32Bit = Platform.machineDescription.is32Bit();
        object = Platform.class.getClassLoader();
        AWT_AVAILABLE = AccessController.doPrivileged(new PrivilegedAction<Boolean>((ClassLoader)object){
            final /* synthetic */ ClassLoader val$cl;
            {
                this.val$cl = classLoader;
            }

            @Override
            public Boolean run() {
                boolean bl = false;
                if (!Debug.getBooleanProperty("java.awt.headless", true) && ReflectionUtil.isClassAvailable("java.awt.Component", this.val$cl) && ReflectionUtil.isClassAvailable("java.awt.GraphicsEnvironment", this.val$cl)) {
                    try {
                        bl = false == (Boolean)ReflectionUtil.callStaticMethod("java.awt.GraphicsEnvironment", "isHeadless", null, null, this.val$cl);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return new Boolean(bl);
            }
        });
    }

    public static enum ABIType {
        GENERIC_ABI(0),
        EABI_GNU_ARMEL(1),
        EABI_GNU_ARMHF(2);

        public final int id;

        private ABIType(int n2) {
            this.id = n2;
        }
    }

    public static enum CPUFamily {
        X86(0),
        ARM(65536),
        PPC(131072),
        SPARC(196608),
        PA_RISC(-65536),
        IA64(-61440);

        public final int id;

        private CPUFamily(int n2) {
            this.id = n2;
        }
    }

    public static enum CPUType {
        X86_32(CPUFamily.X86, 1),
        X86_64(CPUFamily.X86, 2),
        ARM(CPUFamily.ARM, 0),
        ARMv5(CPUFamily.ARM, 1),
        ARMv6(CPUFamily.ARM, 2),
        ARMv7(CPUFamily.ARM, 4),
        PPC(CPUFamily.PPC, 0),
        SPARC_32(CPUFamily.SPARC, 1),
        SPARCV9_64(CPUFamily.SPARC, 2),
        IA64(CPUFamily.IA64, 0),
        PA_RISC2_0(CPUFamily.PA_RISC, 1);

        public final int id;
        public final CPUFamily family;

        private CPUType(CPUFamily cPUFamily, int n2) {
            this.family = cPUFamily;
            this.id = n2;
        }

        public CPUFamily getFamily() {
            return this.family;
        }
    }

    public static enum OSType {
        LINUX(0),
        FREEBSD(1),
        ANDROID(2),
        MACOS(3),
        SUNOS(4),
        HPUX(5),
        WINDOWS(6),
        OPENKODE(7);

        public final int id;

        private OSType(int n2) {
            this.id = n2;
        }
    }
}

