/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.HashMap;
import java.util.Map;
import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.Glue;
import org.scilab.forge.jlatexmath.InvalidUnitException;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.TeXFormula;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SpaceAtom
extends Atom {
    private static Map a = new HashMap();
    private static UnitConversion[] a;
    private boolean a;
    private int d;
    private float a;
    private float b;
    private float c;
    private int e;
    private int f;
    private int g;

    public SpaceAtom() {
        this.a = true;
    }

    public SpaceAtom(int n) {
        this.a = true;
        this.d = n;
    }

    public SpaceAtom(int n, float f, float f2, float f3) {
        SpaceAtom.checkUnit(n);
        this.e = n;
        this.f = n;
        this.g = n;
        this.a = f;
        this.b = f2;
        this.c = f3;
    }

    public static void checkUnit(int n) {
        if (n < 0 || n >= a.length) {
            throw new InvalidUnitException();
        }
    }

    public SpaceAtom(int n, float f, int n2, float f2, int n3, float f3) {
        SpaceAtom.checkUnit(n);
        SpaceAtom.checkUnit(n2);
        SpaceAtom.checkUnit(n3);
        this.e = n;
        this.f = n2;
        this.g = n3;
        this.a = f;
        this.b = f2;
        this.c = f3;
    }

    public static int getUnit(String string) {
        Integer n = (Integer)a.get(string);
        return n == null ? 2 : n;
    }

    public static float[] getLength(String string) {
        int n;
        if (string == null) {
            return new float[]{2.0f, 0.0f};
        }
        for (n = 0; n < string.length() && !Character.isLetter(string.charAt(n)); ++n) {
        }
        float f = 0.0f;
        try {
            f = Float.parseFloat(string.substring(0, n));
        }
        catch (NumberFormatException numberFormatException) {
            return new float[]{Float.NaN};
        }
        int n2 = n != string.length() ? SpaceAtom.getUnit(string.substring(n).toLowerCase()) : 2;
        return new float[]{n2, f};
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        if (this.a) {
            int n;
            if (this.d == 0) {
                return new StrutBox(teXEnvironment.getSpace(), 0.0f, 0.0f, 0.0f);
            }
            int n2 = n = this.d < 0 ? -this.d : this.d;
            Box box = n == 1 ? Glue.get(7, 0, teXEnvironment) : (n == 2 ? Glue.get(2, 1, teXEnvironment) : Glue.get(3, 1, teXEnvironment));
            if (this.d < 0) {
                box.negWidth();
            }
            return box;
        }
        return new StrutBox(this.a * SpaceAtom.getFactor(this.e, teXEnvironment), this.b * SpaceAtom.getFactor(this.f, teXEnvironment), this.c * SpaceAtom.getFactor(this.g, teXEnvironment), 0.0f);
    }

    public static float getFactor(int n, TeXEnvironment teXEnvironment) {
        return a[n].getPixelConversion(teXEnvironment);
    }

    static {
        a.put("em", 0);
        a.put("ex", 1);
        a.put("px", 2);
        a.put("pix", 2);
        a.put("pixel", 2);
        a.put("pt", 10);
        a.put("bp", 3);
        a.put("pica", 4);
        a.put("pc", 4);
        a.put("mu", 5);
        a.put("cm", 6);
        a.put("mm", 7);
        a.put("in", 8);
        a.put("sp", 9);
        a.put("dd", 11);
        a.put("cc", 12);
        a = new UnitConversion[]{new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return teXEnvironment.getTeXFont().getXHeight(teXEnvironment.getStyle(), teXEnvironment.getLastFontId());
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return teXEnvironment.getTeXFont().getXHeight(teXEnvironment.getStyle(), teXEnvironment.getLastFontId());
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return 1.0f / teXEnvironment.getSize();
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return TeXFormula.a / teXEnvironment.getSize();
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return 12.0f * TeXFormula.a / teXEnvironment.getSize();
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                TeXFont teXFont = teXEnvironment.getTeXFont();
                return teXFont.getQuad(teXEnvironment.getStyle(), teXFont.getMuFontId()) / 18.0f;
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return 28.346457f * TeXFormula.a / teXEnvironment.getSize();
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return 2.8346457f * TeXFormula.a / teXEnvironment.getSize();
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return 72.0f * TeXFormula.a / teXEnvironment.getSize();
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return 65536.0f * TeXFormula.a / teXEnvironment.getSize();
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return 0.996264f * TeXFormula.a / teXEnvironment.getSize();
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return 1.0660349f * TeXFormula.a / teXEnvironment.getSize();
            }
        }, new UnitConversion(){

            public float getPixelConversion(TeXEnvironment teXEnvironment) {
                return 12.792419f * TeXFormula.a / teXEnvironment.getSize();
            }
        }};
    }

    private static interface UnitConversion {
        public float getPixelConversion(TeXEnvironment var1);
    }
}

