/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast;

import com.jogamp.common.util.IOUtil;
import com.jogamp.graph.font.Font;
import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.opengl.GLException;
import jogamp.graph.font.FontConstructor;
import jogamp.graph.font.typecast.TypecastFont;
import jogamp.graph.font.typecast.ot.OTFontCollection;

public class TypecastFontConstructor
implements FontConstructor {
    @Override
    public Font create(final File file) throws IOException {
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    OTFontCollection oTFontCollection = OTFontCollection.create(file);
                    return new TypecastFont(oTFontCollection);
                }
                catch (IOException iOException) {
                    return iOException;
                }
            }
        });
        if (object instanceof Font) {
            return (Font)object;
        }
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        throw new InternalError("Unexpected Object: " + object);
    }

    @Override
    public Font create(final URLConnection uRLConnection) throws IOException {
        return AccessController.doPrivileged(new PrivilegedAction<Font>(){

            @Override
            public Font run() {
                File file = null;
                int n = 0;
                Font font = null;
                try {
                    file = IOUtil.createTempFile((String)"joglfont", (String)".ttf", null);
                    n = IOUtil.copyURLConn2File((URLConnection)uRLConnection, (File)file);
                    if (n == 0) {
                        file.delete();
                        throw new GLException("Font of stream " + uRLConnection.getURL() + " was zero bytes");
                    }
                    font = TypecastFontConstructor.this.create(file);
                    file.delete();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return font;
            }
        });
    }
}

