/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.macosx.cgl;

import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.gluegen.runtime.opengl.GLProcAddressResolver;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.OffscreenLayerSurface;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.macosx.cgl.CGL;
import jogamp.opengl.macosx.cgl.CGLExt;
import jogamp.opengl.macosx.cgl.CGLExtImpl;
import jogamp.opengl.macosx.cgl.CGLExtProcAddressTable;
import jogamp.opengl.macosx.cgl.MacOSXCGLDrawable;
import jogamp.opengl.macosx.cgl.MacOSXCGLGraphicsConfiguration;
import jogamp.opengl.macosx.cgl.MacOSXPbufferCGLDrawable;

public abstract class MacOSXCGLContext
extends GLContextImpl {
    static final boolean isTigerOrLater;
    static final boolean isLionOrLater;
    private boolean haveSetOpenGLMode = false;
    private MacOSXCGLDrawable.GLBackendType openGLMode = MacOSXCGLDrawable.GLBackendType.NSOPENGL;
    protected GLBackendImpl impl;
    private CGLExt _cglExt;
    private CGLExtProcAddressTable cglExtProcAddressTable;

    static boolean isGLProfileSupported(int n, int n2, int n3) {
        boolean bl;
        boolean bl2 = 0 != (2 & n);
        boolean bl3 = bl = 0 != (4 & n);
        if (3 == n2 && 1 <= n3 && n3 <= 2) {
            if (!isLionOrLater) {
                return false;
            }
            if (bl2) {
                return false;
            }
            return bl;
        }
        return n2 < 3;
    }

    static int GLProfile2CGLOGLProfileValue(int n, int n2, int n3) {
        boolean bl;
        if (!MacOSXCGLContext.isGLProfileSupported(n, n2, n3)) {
            throw new GLException("OpenGL profile not supported: " + MacOSXCGLContext.getGLVersion(n2, n3, n, "@GLProfile2CGLOGLProfileVersion"));
        }
        boolean bl2 = bl = 0 != (4 & n);
        if (n2 == 3 && n3 >= 1 && bl) {
            return 12800;
        }
        return 4096;
    }

    protected MacOSXCGLContext(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        super(gLDrawableImpl, gLContext);
        this.initOpenGLImpl(this.getOpenGLMode());
    }

    @Override
    protected void resetStates() {
        this.cglExtProcAddressTable = null;
        super.resetStates();
    }

    @Override
    public Object getPlatformGLExtensions() {
        return this.getCGLExt();
    }

    protected boolean isNSContext() {
        return null != this.impl ? this.impl.isNSContext() : this.openGLMode == MacOSXCGLDrawable.GLBackendType.NSOPENGL;
    }

    public CGLExt getCGLExt() {
        if (this._cglExt == null) {
            this._cglExt = new CGLExtImpl(this);
        }
        return this._cglExt;
    }

    @Override
    public final ProcAddressTable getPlatformExtProcAddressTable() {
        return this.getCGLExtProcAddressTable();
    }

    public final CGLExtProcAddressTable getCGLExtProcAddressTable() {
        return this.cglExtProcAddressTable;
    }

    @Override
    protected Map<String, String> getFunctionNameMap() {
        return null;
    }

    @Override
    protected Map<String, String> getExtensionNameMap() {
        return null;
    }

    @Override
    protected long createContextARBImpl(long l, boolean bl, int n, int n2, int n3) {
        if (!MacOSXCGLContext.isGLProfileSupported(n, n2, n3)) {
            if (DEBUG) {
                System.err.println(MacOSXCGLContext.getThreadName() + ": createContextARBImpl: Not supported " + MacOSXCGLContext.getGLVersion(n2, n3, n, "@creation on OSX " + Platform.getOSVersionNumber()));
            }
            return 0L;
        }
        long l2 = this.impl.create(l, n, n2, n3);
        if (0L != l2) {
            if (!this.impl.makeCurrent(l2)) {
                if (DEBUG) {
                    System.err.println(MacOSXCGLContext.getThreadName() + ": createContextARB couldn't make current " + MacOSXCGLContext.getGLVersion(n2, n3, n, "@creation"));
                }
                this.impl.release(l2);
                this.impl.destroy(l2);
                l2 = 0L;
            } else if (DEBUG) {
                System.err.println(MacOSXCGLContext.getThreadName() + ": createContextARBImpl: OK " + MacOSXCGLContext.getGLVersion(n2, n3, n, "@creation") + ", share " + l + ", direct " + bl + " on OSX " + Platform.getOSVersionNumber());
            }
        } else if (DEBUG) {
            System.err.println(MacOSXCGLContext.getThreadName() + ": createContextARBImpl: NO " + MacOSXCGLContext.getGLVersion(n2, n3, n, "@creation on OSX " + Platform.getOSVersionNumber()));
        }
        return l2;
    }

    @Override
    protected void destroyContextARBImpl(long l) {
        this.impl.release(l);
        this.impl.destroy(l);
    }

    @Override
    public final boolean isGLReadDrawableAvailable() {
        return false;
    }

    protected long createImplPreset(GLContextImpl gLContextImpl) throws GLException {
        MacOSXCGLGraphicsConfiguration macOSXCGLGraphicsConfiguration;
        GLCapabilitiesImmutable gLCapabilitiesImmutable;
        long l = 0L;
        if (gLContextImpl != null) {
            this.setOpenGLMode(((MacOSXCGLContext)gLContextImpl).getOpenGLMode());
            l = gLContextImpl.getHandle();
            if (l == 0L) {
                throw new GLException("GLContextShareSet returned a NULL OpenGL context");
            }
        }
        if ((gLCapabilitiesImmutable = (GLCapabilitiesImmutable)(macOSXCGLGraphicsConfiguration = (MacOSXCGLGraphicsConfiguration)this.drawable.getNativeSurface().getGraphicsConfiguration()).getChosenCapabilities()).getPbufferFloatingPointBuffers() && !isTigerOrLater) {
            throw new GLException("Floating-point pbuffers supported only on OS X 10.4 or later");
        }
        GLProfile gLProfile = gLCapabilitiesImmutable.getGLProfile();
        if (gLProfile.isGLES1() || gLProfile.isGLES2() || gLProfile.isGL4() || gLProfile.isGL3() && !isLionOrLater) {
            throw new GLException("OpenGL profile not supported on MacOSX " + Platform.getOSVersionNumber() + ": " + gLProfile);
        }
        if (DEBUG) {
            System.err.println("Share context is " + MacOSXCGLContext.toHexString(l) + " for " + this);
        }
        return l;
    }

    @Override
    protected boolean createImpl(GLContextImpl gLContextImpl) throws GLException {
        long l = this.createImplPreset(gLContextImpl);
        this.contextHandle = this.createContextARB(l, true);
        return 0L != this.contextHandle;
    }

    @Override
    protected void makeCurrentImpl() throws GLException {
        if (this.getOpenGLMode() != ((MacOSXCGLDrawable)this.drawable).getOpenGLMode()) {
            this.setOpenGLMode(((MacOSXCGLDrawable)this.drawable).getOpenGLMode());
        }
        if (!this.impl.makeCurrent(this.contextHandle)) {
            throw new GLException("Error making Context current: " + this);
        }
    }

    @Override
    protected void releaseImpl() throws GLException {
        if (!this.impl.release(this.contextHandle)) {
            throw new GLException("Error releasing OpenGL Context: " + this);
        }
    }

    @Override
    protected void destroyImpl() throws GLException {
        if (!this.impl.destroy(this.contextHandle)) {
            throw new GLException("Error destroying OpenGL Context: " + this);
        }
    }

    @Override
    protected void copyImpl(GLContext gLContext, int n) throws GLException {
        if (this.isNSContext() != ((MacOSXCGLContext)gLContext).isNSContext()) {
            throw new GLException("Source/Destination OpenGL Context tyoe mismatch: source " + gLContext + ", dest: " + this);
        }
        if (!this.impl.copyImpl(gLContext.getHandle(), n)) {
            throw new GLException("Error copying OpenGL Context: source " + gLContext + ", dest: " + this);
        }
    }

    protected void swapBuffers() {
        if (!this.impl.swapBuffers()) {
            throw new GLException("Error swapping buffers: " + this);
        }
    }

    @Override
    protected boolean setSwapIntervalImpl(int n) {
        return this.impl.setSwapInterval(n);
    }

    @Override
    public ByteBuffer glAllocateMemoryNV(int n, float f, float f2, float f3) {
        throw new GLException("Not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void updateGLXProcAddressTable() {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.drawable.getNativeSurface().getGraphicsConfiguration();
        AbstractGraphicsDevice abstractGraphicsDevice = abstractGraphicsConfiguration.getScreen().getDevice();
        String string = "MacOSX-" + abstractGraphicsDevice.getUniqueID();
        if (DEBUG) {
            System.err.println(MacOSXCGLContext.getThreadName() + ": Initializing CGL extension address table: " + string);
        }
        ProcAddressTable procAddressTable = null;
        Object object = mappedContextTypeObjectLock;
        synchronized (object) {
            procAddressTable = (ProcAddressTable)mappedGLXProcAddress.get(string);
        }
        if (null != procAddressTable) {
            this.cglExtProcAddressTable = (CGLExtProcAddressTable)procAddressTable;
            if (DEBUG) {
                System.err.println(MacOSXCGLContext.getThreadName() + ": GLContext CGL ProcAddressTable reusing key(" + string + ") -> " + MacOSXCGLContext.toHexString(procAddressTable.hashCode()));
            }
        } else {
            this.cglExtProcAddressTable = new CGLExtProcAddressTable(new GLProcAddressResolver());
            this.resetProcAddressTable(this.getCGLExtProcAddressTable());
            object = mappedContextTypeObjectLock;
            synchronized (object) {
                mappedGLXProcAddress.put(string, this.getCGLExtProcAddressTable());
                if (DEBUG) {
                    System.err.println(MacOSXCGLContext.getThreadName() + ": GLContext CGL ProcAddressTable mapping key(" + string + ") -> " + MacOSXCGLContext.toHexString(((Object)((Object)this.getCGLExtProcAddressTable())).hashCode()));
                }
            }
        }
    }

    @Override
    protected final StringBuilder getPlatformExtensionsStringImpl() {
        return new StringBuilder();
    }

    @Override
    public boolean isExtensionAvailable(String string) {
        if (string.equals("GL_ARB_pbuffer") || string.equals("GL_ARB_pixel_format")) {
            return true;
        }
        return super.isExtensionAvailable(string);
    }

    @Override
    public int getOffscreenContextPixelDataType() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextReadBuffer() {
        throw new GLException("Should not call this");
    }

    @Override
    public boolean offscreenImageNeedsVerticalFlip() {
        throw new GLException("Should not call this");
    }

    @Override
    public void bindPbufferToTexture() {
        throw new GLException("Should not call this");
    }

    @Override
    public void releasePbufferFromTexture() {
        throw new GLException("Should not call this");
    }

    public void setOpenGLMode(MacOSXCGLDrawable.GLBackendType gLBackendType) {
        if (gLBackendType == this.openGLMode) {
            return;
        }
        if (this.haveSetOpenGLMode) {
            throw new GLException("Can't switch between using NSOpenGLPixelBuffer and CGLPBufferObj more than once");
        }
        this.destroyImpl();
        ((MacOSXCGLDrawable)this.drawable).setOpenGLMode(gLBackendType);
        if (DEBUG) {
            System.err.println("MacOSXCGLContext: Switching context mode " + (Object)((Object)this.openGLMode) + " -> " + (Object)((Object)gLBackendType));
        }
        this.initOpenGLImpl(gLBackendType);
        this.openGLMode = gLBackendType;
        this.haveSetOpenGLMode = true;
    }

    public final MacOSXCGLDrawable.GLBackendType getOpenGLMode() {
        return this.openGLMode;
    }

    protected void initOpenGLImpl(MacOSXCGLDrawable.GLBackendType gLBackendType) {
        switch (gLBackendType) {
            case NSOPENGL: {
                this.impl = new NSOpenGLImpl();
                break;
            }
            case CGL: {
                this.impl = new CGLImpl();
                break;
            }
            default: {
                throw new InternalError("Illegal implementation mode " + (Object)((Object)gLBackendType));
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" [");
        super.append(stringBuilder);
        stringBuilder.append(", mode ");
        stringBuilder.append((Object)this.openGLMode);
        stringBuilder.append("] ");
        return stringBuilder.toString();
    }

    static {
        VersionNumber versionNumber = Platform.getOSVersionNumber();
        isTigerOrLater = versionNumber.getMajor() > 10 || versionNumber.getMajor() == 10 && versionNumber.getMinor() >= 4;
        isLionOrLater = versionNumber.getMajor() > 10 || versionNumber.getMajor() == 10 && versionNumber.getMinor() >= 7;
    }

    class CGLImpl
    implements GLBackendImpl {
        CGLImpl() {
        }

        @Override
        public boolean isNSContext() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long create(long l, int n, int n2, int n3) {
            long l2 = 0L;
            MacOSXCGLGraphicsConfiguration macOSXCGLGraphicsConfiguration = (MacOSXCGLGraphicsConfiguration)MacOSXCGLContext.this.drawable.getNativeSurface().getGraphicsConfiguration();
            GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)macOSXCGLGraphicsConfiguration.getChosenCapabilities();
            long l3 = MacOSXCGLGraphicsConfiguration.GLCapabilities2CGLPixelFormat(gLCapabilitiesImmutable, n, n2, n3);
            if (l3 == 0L) {
                throw new GLException("Unable to allocate pixel format with requested GLCapabilities");
            }
            macOSXCGLGraphicsConfiguration.setChosenPixelFormat(l3);
            try {
                int n4;
                PointerBuffer pointerBuffer = PointerBuffer.allocateDirect((int)1);
                if (GLContext.DEBUG) {
                    System.err.println("Share context for CGL-based pbuffer context is " + MacOSXCGLContext.toHexString(l));
                }
                if ((n4 = CGL.CGLCreateContext(l3, l, pointerBuffer)) != 0) {
                    throw new GLException("Error code " + n4 + " while creating context");
                }
                if (gLCapabilitiesImmutable.isPBuffer() && (n4 = CGL.CGLSetPBuffer(pointerBuffer.get(0), MacOSXCGLContext.this.drawable.getHandle(), 0, 0, 0)) != 0) {
                    throw new GLException("Error code " + n4 + " while attaching context to pbuffer");
                }
                l2 = pointerBuffer.get(0);
                if (0L != l2 && GLContext.DEBUG) {
                    GLCapabilitiesImmutable gLCapabilitiesImmutable2 = MacOSXCGLGraphicsConfiguration.CGLPixelFormat2GLCapabilities(l3);
                    System.err.println("NS created: " + gLCapabilitiesImmutable2);
                }
            }
            finally {
                CGL.CGLDestroyPixelFormat(l3);
            }
            return l2;
        }

        @Override
        public boolean destroy(long l) {
            return CGL.CGLDestroyContext(l) == 0;
        }

        @Override
        public boolean copyImpl(long l, int n) {
            CGL.CGLCopyContext(l, MacOSXCGLContext.this.contextHandle, n);
            return true;
        }

        @Override
        public boolean makeCurrent(long l) {
            int n = CGL.CGLLockContext(l);
            if (0 == n) {
                n = CGL.CGLSetCurrentContext(l);
                if (0 == n) {
                    return true;
                }
                if (GLContext.DEBUG) {
                    System.err.println("CGL: Could not make context current: err 0x" + Integer.toHexString(n) + ": " + this);
                }
            } else if (GLContext.DEBUG) {
                System.err.println("CGL: Could not lock context: err 0x" + Integer.toHexString(n) + ": " + this);
            }
            return false;
        }

        @Override
        public boolean release(long l) {
            block4: {
                try {
                    MacOSXCGLContext.this.gl.glFlush();
                }
                catch (GLException gLException) {
                    if (!GLContext.DEBUG) break block4;
                    System.err.println("MacOSXCGLContext.CGLImpl.release: INFO: glFlush() catched exception:");
                    gLException.printStackTrace();
                }
            }
            int n = CGL.CGLSetCurrentContext(0L);
            if (GLContext.DEBUG && 0 != n) {
                System.err.println("CGL: Could not release current context: err 0x" + Integer.toHexString(n) + ": " + this);
            }
            int n2 = CGL.CGLUnlockContext(l);
            if (GLContext.DEBUG && 0 != n2) {
                System.err.println("CGL: Could not unlock context: err 0x" + Integer.toHexString(n2) + ": " + this);
            }
            return 0 == n && 0 == n2;
        }

        @Override
        public boolean setSwapInterval(int n) {
            int[] nArray = new int[]{n};
            CGL.CGLSetParameter(MacOSXCGLContext.this.contextHandle, 222, nArray, 0);
            return true;
        }

        @Override
        public boolean swapBuffers() {
            return 0 == CGL.CGLFlushDrawable(MacOSXCGLContext.this.contextHandle);
        }
    }

    protected static interface GLBackendImpl {
        public boolean isNSContext();

        public long create(long var1, int var3, int var4, int var5);

        public boolean destroy(long var1);

        public boolean copyImpl(long var1, int var3);

        public boolean makeCurrent(long var1);

        public boolean release(long var1);

        public boolean setSwapInterval(int var1);

        public boolean swapBuffers();
    }

    class NSOpenGLImpl
    implements GLBackendImpl {
        long nsOpenGLLayer = 0L;
        long nsOpenGLLayerPFmt = 0L;
        float screenVSyncTimeout;
        int vsyncTimeout;

        NSOpenGLImpl() {
        }

        @Override
        public boolean isNSContext() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long create(long l, int n, int n2, int n3) {
            long l2 = 0L;
            MacOSXCGLDrawable macOSXCGLDrawable = (MacOSXCGLDrawable)MacOSXCGLContext.this.drawable;
            NativeSurface nativeSurface = macOSXCGLDrawable.getNativeSurface();
            MacOSXCGLGraphicsConfiguration macOSXCGLGraphicsConfiguration = (MacOSXCGLGraphicsConfiguration)nativeSurface.getGraphicsConfiguration();
            OffscreenLayerSurface offscreenLayerSurface = NativeWindowFactory.getOffscreenLayerSurface(nativeSurface, true);
            GLCapabilitiesImmutable gLCapabilitiesImmutable = (GLCapabilitiesImmutable)macOSXCGLGraphicsConfiguration.getChosenCapabilities();
            long l3 = MacOSXCGLGraphicsConfiguration.GLCapabilities2NSPixelFormat(gLCapabilitiesImmutable, n, n2, n3);
            if (l3 == 0L) {
                if (GLContext.DEBUG) {
                    System.err.println("Unable to allocate pixel format with requested GLCapabilities: " + gLCapabilitiesImmutable);
                }
                return 0L;
            }
            macOSXCGLGraphicsConfiguration.setChosenPixelFormat(l3);
            int n4 = CGL.getScreenRefreshRate(macOSXCGLDrawable.getNativeSurface().getGraphicsConfiguration().getScreen().getIndex());
            this.screenVSyncTimeout = 1000000.0f / (float)n4;
            if (GLContext.DEBUG) {
                System.err.println("NS create OSX>=lion " + isLionOrLater);
                System.err.println("NS create backendType: " + (Object)((Object)macOSXCGLDrawable.getOpenGLMode()));
                System.err.println("NS create backingLayerHost: " + offscreenLayerSurface);
                System.err.println("NS create share: " + l);
                System.err.println("NS create chosenCaps: " + gLCapabilitiesImmutable);
                System.err.println("NS create pixelFormat: " + MacOSXCGLContext.toHexString(l3));
                System.err.println("NS create drawable native-handle: " + MacOSXCGLContext.toHexString(macOSXCGLDrawable.getHandle()));
                System.err.println("NS create drawable NSView-handle: " + MacOSXCGLContext.toHexString(macOSXCGLDrawable.getNSViewHandle()));
                System.err.println("NS create screen refresh-rate: " + n4 + " hz, " + this.screenVSyncTimeout + " micros");
            }
            try {
                GLCapabilitiesImmutable gLCapabilitiesImmutable2;
                int[] nArray = new int[1];
                l2 = CGL.createContext(l, macOSXCGLDrawable.getNSViewHandle(), null != offscreenLayerSurface, l3, gLCapabilitiesImmutable.isBackgroundOpaque(), nArray, 0);
                if (0L == l2) {
                    if (GLContext.DEBUG) {
                        System.err.println("NS create failed: viewNotReady: " + (1 == nArray[0]));
                    }
                    long l4 = 0L;
                    return l4;
                }
                if (!gLCapabilitiesImmutable.isPBuffer() && !gLCapabilitiesImmutable.isBackgroundOpaque()) {
                    CGL.setContextOpacity(l2, 0);
                }
                if (GLContext.DEBUG) {
                    gLCapabilitiesImmutable2 = MacOSXCGLGraphicsConfiguration.NSPixelFormat2GLCapabilities(null, l3);
                    System.err.println("NS create pixelformat2GLCaps: " + gLCapabilitiesImmutable2);
                }
                gLCapabilitiesImmutable2 = MacOSXCGLGraphicsConfiguration.NSPixelFormat2GLCapabilities(gLCapabilitiesImmutable.getGLProfile(), l3);
                gLCapabilitiesImmutable2 = GLGraphicsConfigurationUtil.fixOpaqueGLCapabilities(gLCapabilitiesImmutable2, gLCapabilitiesImmutable.isBackgroundOpaque());
                macOSXCGLGraphicsConfiguration.setChosenCapabilities(gLCapabilitiesImmutable2);
                if (GLContext.DEBUG) {
                    System.err.println("NS create fixedCaps: " + gLCapabilitiesImmutable2);
                }
                if (gLCapabilitiesImmutable2.isPBuffer()) {
                    CGL.setContextPBuffer(l2, macOSXCGLDrawable.getHandle());
                }
                if (null != offscreenLayerSurface) {
                    int n5;
                    int n6;
                    this.nsOpenGLLayerPFmt = l3;
                    l3 = 0L;
                    if (macOSXCGLDrawable instanceof MacOSXPbufferCGLDrawable) {
                        MacOSXPbufferCGLDrawable macOSXPbufferCGLDrawable = (MacOSXPbufferCGLDrawable)macOSXCGLDrawable;
                        n6 = macOSXPbufferCGLDrawable.getTextureWidth();
                        n5 = macOSXPbufferCGLDrawable.getTextureHeight();
                    } else {
                        n6 = macOSXCGLDrawable.getWidth();
                        n5 = macOSXCGLDrawable.getHeight();
                    }
                    this.nsOpenGLLayer = CGL.createNSOpenGLLayer(l2, this.nsOpenGLLayerPFmt, macOSXCGLDrawable.getHandle(), gLCapabilitiesImmutable2.isBackgroundOpaque(), n6, n5);
                    if (0 >= n6 || 0 >= n5 || !macOSXCGLDrawable.isRealized()) {
                        throw new GLException("Drawable not realized yet or invalid texture size, texSize " + n6 + "x" + n5 + ", " + macOSXCGLDrawable);
                    }
                    if (GLContext.DEBUG) {
                        System.err.println("NS create nsOpenGLLayer " + MacOSXCGLContext.toHexString(this.nsOpenGLLayer) + ", texSize " + n6 + "x" + n5 + ", " + macOSXCGLDrawable);
                    }
                    offscreenLayerSurface.attachSurfaceLayer(this.nsOpenGLLayer);
                    this.setSwapInterval(1);
                }
            }
            finally {
                if (0L != l3) {
                    CGL.deletePixelFormat(l3);
                }
            }
            return l2;
        }

        @Override
        public boolean destroy(long l) {
            if (0L != this.nsOpenGLLayer) {
                OffscreenLayerSurface offscreenLayerSurface;
                NativeSurface nativeSurface = MacOSXCGLContext.this.drawable.getNativeSurface();
                if (GLContext.DEBUG) {
                    System.err.println("NS destroy nsOpenGLLayer " + MacOSXCGLContext.toHexString(this.nsOpenGLLayer));
                }
                if (null == (offscreenLayerSurface = NativeWindowFactory.getOffscreenLayerSurface(nativeSurface, true))) {
                    throw new InternalError("XXX: " + offscreenLayerSurface);
                }
                CGL.releaseNSOpenGLLayer(this.nsOpenGLLayer);
                offscreenLayerSurface.detachSurfaceLayer(this.nsOpenGLLayer);
                CGL.deletePixelFormat(this.nsOpenGLLayerPFmt);
                this.nsOpenGLLayerPFmt = 0L;
                this.nsOpenGLLayer = 0L;
            }
            return CGL.deleteContext(l, true);
        }

        @Override
        public boolean copyImpl(long l, int n) {
            CGL.copyContext(MacOSXCGLContext.this.contextHandle, l, n);
            return true;
        }

        @Override
        public boolean makeCurrent(long l) {
            long l2 = CGL.getCGLContext(l);
            if (0L == l2) {
                throw new InternalError("Null CGLContext for: " + this);
            }
            int n = CGL.CGLLockContext(l2);
            if (0 == n) {
                return CGL.makeCurrentContext(l);
            }
            if (GLContext.DEBUG) {
                System.err.println("NSGL: Could not lock context: err 0x" + Integer.toHexString(n) + ": " + this);
            }
            return false;
        }

        @Override
        public boolean release(long l) {
            block4: {
                try {
                    MacOSXCGLContext.this.gl.glFlush();
                }
                catch (GLException gLException) {
                    if (!GLContext.DEBUG) break block4;
                    System.err.println("MacOSXCGLContext.NSOpenGLImpl.release: INFO: glFlush() catched exception:");
                    gLException.printStackTrace();
                }
            }
            boolean bl = CGL.clearCurrentContext(l);
            long l2 = CGL.getCGLContext(l);
            if (0L == l2) {
                throw new InternalError("Null CGLContext for: " + this);
            }
            int n = CGL.CGLUnlockContext(l2);
            if (GLContext.DEBUG && 0 != n) {
                System.err.println("CGL: Could not unlock context: err 0x" + Integer.toHexString(n) + ": " + this);
            }
            return bl && 0 == n;
        }

        @Override
        public boolean setSwapInterval(int n) {
            if (0L != this.nsOpenGLLayer) {
                CGL.setNSOpenGLLayerSwapInterval(this.nsOpenGLLayer, n);
                this.vsyncTimeout = n * (int)this.screenVSyncTimeout;
                if (GLContext.DEBUG) {
                    System.err.println("NS setSwapInterval: " + this.vsyncTimeout + " micros");
                }
            }
            CGL.setSwapInterval(MacOSXCGLContext.this.contextHandle, n);
            return true;
        }

        @Override
        public boolean swapBuffers() {
            if (0L != this.nsOpenGLLayer) {
                CGL.waitUntilNSOpenGLLayerIsReady(this.nsOpenGLLayer, this.vsyncTimeout);
            }
            if (CGL.flushBuffer(MacOSXCGLContext.this.contextHandle)) {
                if (0L != this.nsOpenGLLayer) {
                    CGL.setNSOpenGLLayerNeedsDisplay(this.nsOpenGLLayer);
                }
                return true;
            }
            return false;
        }
    }
}

