/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl;

import com.kenai.jaffl.FFIProvider;
import com.kenai.jaffl.LibraryOption;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Library {
    private static final Map<String, List<String>> customSearchPaths = new ConcurrentHashMap<String, List<String>>();
    private final String name;

    private Library(String string) {
        this.name = string;
    }

    public static <T> T loadLibrary(String string, Class<T> clazz) {
        Map map = Collections.emptyMap();
        return Library.loadLibrary(string, clazz, map);
    }

    public static <T> T loadLibrary(Class<T> clazz, String ... stringArray) {
        Map map = Collections.emptyMap();
        return Library.loadLibrary(clazz, map, stringArray);
    }

    public static <T> T loadLibrary(String string, Class<T> clazz, Map<LibraryOption, ?> map) {
        return FFIProvider.getProvider().loadLibrary(string, clazz, map);
    }

    public static <T> T loadLibrary(Class<T> clazz, Map<LibraryOption, ?> map, String ... stringArray) {
        return FFIProvider.getProvider().loadLibrary(clazz, map, stringArray);
    }

    public static final synchronized void addLibraryPath(String string, File file) {
        List<String> list = customSearchPaths.get(string);
        if (list == null) {
            list = new CopyOnWriteArrayList<String>();
            customSearchPaths.put(string, list);
        }
        list.add(file.getAbsolutePath());
    }

    public static List<String> getLibraryPath(String string) {
        List<String> list = customSearchPaths.get(string);
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public static final Library getInstance(String string) {
        return new Library(string);
    }

    public boolean hasFunction(String string) {
        return false;
    }

    public String getName() {
        return this.name;
    }
}

