/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl;

import com.kenai.jaffl.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeLong
extends Number
implements Comparable<NativeLong> {
    public static final int SIZE = Platform.getPlatform().longSize();
    public static final int SHIFT = SIZE == 32 ? 2 : 3;
    public static final long MASK = SIZE == 32 ? 0xFFFFFFFFL : -1L;
    private static final NativeLong ZERO = new NativeLong(0L);
    private static final NativeLong ONE = new NativeLong(1L);
    private static final NativeLong MINUS_ONE = new NativeLong(-1L);
    private final long value;

    public NativeLong(long l) {
        this.value = l;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final float floatValue() {
        return this.value;
    }

    @Override
    public final double doubleValue() {
        return this.value;
    }

    public final int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public final boolean equals(Object object) {
        return object instanceof NativeLong && this.value == ((NativeLong)object).value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public final int compareTo(NativeLong nativeLong) {
        return this.value < nativeLong.value ? -1 : (this.value > nativeLong.value ? 1 : 0);
    }

    private static final NativeLong _valueOf(long l) {
        return l >= -128L && l <= 127L ? Cache.cache[128 + (int)l] : new NativeLong(l);
    }

    public static final NativeLong valueOf(long l) {
        return l == 0L ? ZERO : (l == 1L ? ONE : (l == -1L ? MINUS_ONE : NativeLong._valueOf(l)));
    }

    public static final NativeLong valueOf(int n) {
        return NativeLong.valueOf((long)n);
    }

    private static final class Cache {
        static final NativeLong[] cache = new NativeLong[256];

        private Cache() {
        }

        static {
            for (int i = 0; i < cache.length; ++i) {
                Cache.cache[i] = new NativeLong(i - 128);
            }
            Cache.cache[128] = ZERO;
            Cache.cache[129] = ONE;
            Cache.cache[127] = MINUS_ONE;
        }
    }
}

