/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Platform {
    private final OS os;
    private final CPU cpu;
    private final int longSize;
    private final int addressSize;
    private final long addressMask;
    private final int javaVersionMajor;
    protected final Pattern libPattern;

    private static final OS determineOS() {
        String string = System.getProperty("os.name").split(" ")[0].toLowerCase();
        if (string.startsWith("mac") || string.startsWith("darwin")) {
            return OS.DARWIN;
        }
        if (string.startsWith("linux")) {
            return OS.LINUX;
        }
        if (string.startsWith("sunos") || string.startsWith("solaris")) {
            return OS.SOLARIS;
        }
        if (string.startsWith("aix")) {
            return OS.AIX;
        }
        if (string.startsWith("openbsd")) {
            return OS.OPENBSD;
        }
        if (string.startsWith("freebsd")) {
            return OS.FREEBSD;
        }
        if (string.startsWith("windows")) {
            return OS.WINDOWS;
        }
        return OS.UNKNOWN;
    }

    private static final Platform determinePlatform(OS oS) {
        switch (oS) {
            case DARWIN: {
                return new Darwin();
            }
            case LINUX: {
                return new Linux();
            }
            case WINDOWS: {
                return new Windows();
            }
            case UNKNOWN: {
                return new Unsupported(oS);
            }
        }
        return new Default(oS);
    }

    private static final CPU determineCPU() {
        String string = System.getProperty("os.arch").toLowerCase();
        if ("x86".equals(string) || "i386".equals(string) || "i86pc".equals(string)) {
            return CPU.I386;
        }
        if ("x86_64".equals(string) || "amd64".equals(string)) {
            return CPU.X86_64;
        }
        if ("ppc".equals(string) || "powerpc".equals(string)) {
            return CPU.PPC;
        }
        try {
            return CPU.valueOf(string.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return CPU.UNKNOWN;
        }
    }

    private Platform(OS oS) {
        String string;
        this.os = oS;
        this.cpu = Platform.determineCPU();
        int n = Integer.getInteger("sun.arch.data.model");
        if (n != 32 && n != 64) {
            switch (this.cpu) {
                case I386: 
                case PPC: 
                case SPARC: {
                    n = 32;
                    break;
                }
                case X86_64: 
                case PPC64: 
                case SPARCV9: 
                case S390X: {
                    n = 64;
                    break;
                }
                default: {
                    throw new ExceptionInInitializerError("Cannot determine cpu address size");
                }
            }
        }
        this.addressSize = n;
        this.addressMask = this.addressSize == 32 ? 0xFFFFFFFFL : -1L;
        this.longSize = oS == OS.WINDOWS ? 32 : this.addressSize;
        int n2 = 5;
        try {
            string = System.getProperty("java.version");
            if (string != null) {
                String[] stringArray = string.split("\\.");
                n2 = Integer.valueOf(stringArray[1]);
            }
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError("Could not determine java version");
        }
        this.javaVersionMajor = n2;
        string = null;
        switch (oS) {
            case WINDOWS: {
                string = ".*\\.dll$";
                break;
            }
            case DARWIN: {
                string = "lib.*\\.(dylib|jnilib)$";
                break;
            }
            default: {
                string = "lib.*\\.so.*$";
            }
        }
        this.libPattern = Pattern.compile(string);
    }

    public static final Platform getPlatform() {
        return SingletonHolder.PLATFORM;
    }

    public final OS getOS() {
        return this.os;
    }

    public final CPU getCPU() {
        return this.cpu;
    }

    public final int getJavaMajorVersion() {
        return this.javaVersionMajor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isBSD() {
        if (this.os == OS.FREEBSD) return true;
        if (this.os == OS.OPENBSD) return true;
        if (this.os == OS.NETBSD) return true;
        if (this.os != OS.DARWIN) return false;
        return true;
    }

    public final boolean isUnix() {
        return this.os != OS.WINDOWS;
    }

    public final int longSize() {
        return this.longSize;
    }

    public final int addressSize() {
        return this.addressSize;
    }

    public final long addressMask() {
        return this.addressMask;
    }

    public String getName() {
        return (Object)((Object)this.cpu) + "-" + (Object)((Object)this.os);
    }

    public String mapLibraryName(String string) {
        if (this.libPattern.matcher(string).find()) {
            return string;
        }
        return System.mapLibraryName(string);
    }

    public String locateLibrary(String string, List<String> list) {
        String string2 = this.mapLibraryName(string);
        for (String string3 : list) {
            File file = new File(string3, string2);
            if (!file.exists()) continue;
            return file.getAbsolutePath();
        }
        return string2;
    }

    static /* synthetic */ OS access$000() {
        return Platform.determineOS();
    }

    static /* synthetic */ Platform access$100(OS oS) {
        return Platform.determinePlatform(oS);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CPU {
        I386,
        X86_64,
        PPC,
        PPC64,
        SPARC,
        SPARCV9,
        S390X,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    private static final class Darwin
    extends Supported {
        public Darwin() {
            super(OS.DARWIN);
        }

        public String mapLibraryName(String string) {
            if (this.libPattern.matcher(string).find()) {
                return string;
            }
            return "lib" + string + ".dylib";
        }

        public String getName() {
            return "Darwin";
        }
    }

    private static final class Default
    extends Supported {
        public Default(OS oS) {
            super(oS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Linux
    extends Supported {
        public Linux() {
            super(OS.LINUX);
        }

        @Override
        public String locateLibrary(final String string, List<String> list) {
            String string22;
            FilenameFilter filenameFilter = new FilenameFilter(){
                Pattern p;
                String exact;
                {
                    this.p = Pattern.compile("lib" + string + "\\.so\\.[0-9]+$");
                    this.exact = "lib" + string + ".so";
                }

                public boolean accept(File file, String string2) {
                    return this.p.matcher(string2).matches() || this.exact.equals(string2);
                }
            };
            LinkedList<File> linkedList = new LinkedList<File>();
            for (String string22 : list) {
                File[] fileArray = new File(string22).listFiles(filenameFilter);
                if (fileArray == null || fileArray.length <= 0) continue;
                linkedList.addAll(Arrays.asList(fileArray));
            }
            int n = 0;
            string22 = null;
            for (File file : linkedList) {
                String string3 = file.getAbsolutePath();
                if (string22 == null && string3.endsWith(".so")) {
                    string22 = string3;
                    n = 0;
                    continue;
                }
                String string4 = string3.substring(string3.lastIndexOf(".so.") + 4);
                try {
                    if (Integer.parseInt(string4) < n) continue;
                    string22 = string3;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return string22 != null ? string22 : this.mapLibraryName(string);
        }

        @Override
        public String mapLibraryName(String string) {
            return "c".equals(string) || "libc.so".equals(string) ? "libc.so.6" : super.mapLibraryName(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OS {
        DARWIN,
        FREEBSD,
        NETBSD,
        OPENBSD,
        LINUX,
        SOLARIS,
        WINDOWS,
        AIX,
        ZLINUX,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    private static final class SingletonHolder {
        static final Platform PLATFORM = Platform.access$100(Platform.access$000());

        private SingletonHolder() {
        }
    }

    private static class Supported
    extends Platform {
        public Supported(OS oS) {
            super(oS);
        }
    }

    private static class Unsupported
    extends Platform {
        public Unsupported(OS oS) {
            super(oS);
        }
    }

    private static class Windows
    extends Supported {
        public Windows() {
            super(OS.WINDOWS);
        }
    }
}

