/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider;

import com.kenai.jaffl.CallingConvention;
import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.annotations.StdCall;
import com.kenai.jaffl.annotations.Synchronized;
import com.kenai.jaffl.provider.Invoker;
import com.kenai.jaffl.provider.Library;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeInvocationHandler
implements InvocationHandler {
    private final InvokerMap invokers;
    private final Library library;
    private final Map<LibraryOption, Object> optionsMap;
    private final Class<?> interfaceClass;

    public NativeInvocationHandler(Library library, Class<?> clazz, Map<LibraryOption, ?> map) {
        this.library = library;
        this.interfaceClass = clazz;
        this.optionsMap = new HashMap(map);
        if (clazz.getAnnotation(StdCall.class) != null) {
            this.optionsMap.put(LibraryOption.CallingConvention, (Object)CallingConvention.STDCALL);
        }
        this.invokers = new InvokerMap(clazz.getDeclaredMethods().length);
    }

    public static <T> T wrapInterface(Library library, Class<T> clazz, Map<LibraryOption, ?> map) {
        return clazz.cast(Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new NativeInvocationHandler(library, clazz, map)));
    }

    private Invoker getInvoker(Method method) {
        Invoker invoker = this.invokers.get(method);
        if (invoker != null) {
            return invoker;
        }
        return this.createInvoker(method);
    }

    private synchronized Invoker createInvoker(Method method) {
        Invoker invoker = this.invokers.get(method);
        if (invoker != null) {
            return invoker;
        }
        invoker = this.library.getInvoker(method, this.optionsMap);
        if (method.getAnnotation(Synchronized.class) != null || this.interfaceClass.getAnnotation(Synchronized.class) != null) {
            invoker = new SynchronizedInvoker(invoker, this.library.libraryLock());
        }
        this.invokers.put(method, invoker);
        return invoker;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        return this.getInvoker(method).invoke(objectArray);
    }

    private static final class InvokerMap {
        private volatile Object[] entries;
        private static final float loadFactor = 0.5f;
        private static final Hasher hasher = Platform.getPlatform().getJavaMajorVersion() >= 6 ? IdentityHasherSingleton.getInstance() : NameHasherSingleton.getInstance();

        public InvokerMap(int n) {
            int n2;
            int n3 = (int)((float)n / 0.5f) + 1;
            for (n2 = 1; n2 < n3; n2 <<= 1) {
            }
            this.entries = new Object[n2 * 2];
        }

        public final synchronized void put(Method method, Invoker invoker) {
            Object[] objectArray = new Object[this.entries.length];
            System.arraycopy(this.entries, 0, objectArray, 0, objectArray.length);
            int n = InvokerMap.indexFor(method, objectArray.length);
            block0: for (int i = 0; i < 2; ++i) {
                for (int j = n; j < objectArray.length - 1; j += 2) {
                    if (objectArray[j] != null) continue;
                    objectArray[j] = method;
                    objectArray[j + 1] = invoker;
                    break block0;
                }
                n = 0;
            }
            this.entries = objectArray;
        }

        public final Invoker get(Method method) {
            Object[] objectArray = this.entries;
            int n = InvokerMap.indexFor(method, objectArray.length);
            block0: for (int i = 0; i < 2; ++i) {
                for (int j = n; j < objectArray.length - 1; j += 2) {
                    if (objectArray[j] == method) {
                        return (Invoker)objectArray[j + 1];
                    }
                    if (objectArray[j] == null) break block0;
                }
                n = 0;
            }
            return null;
        }

        private static final int indexFor(Method method, int n) {
            return hasher.hash(method) & n - 1;
        }

        private static interface Hasher {
            public int hash(Method var1);
        }

        private static final class IdentityHasherSingleton {
            private IdentityHasherSingleton() {
            }

            public static final Hasher getInstance() {
                return new IdentityHasher();
            }

            private static final class IdentityHasher
            implements Hasher {
                private IdentityHasher() {
                }

                public final int hash(Method method) {
                    int n = System.identityHashCode(method);
                    return (n << 1) - (n << 8);
                }
            }
        }

        private static final class NameHasherSingleton {
            private NameHasherSingleton() {
            }

            public static final Hasher getInstance() {
                return new NameHasher();
            }

            private static final class NameHasher
            implements Hasher {
                private NameHasher() {
                }

                public final int hash(Method method) {
                    int n = method.hashCode();
                    n += n << 15 ^ 0xFFFFCD7D;
                    n ^= n >>> 10;
                    n += n << 3;
                    n ^= n >>> 6;
                    n += (n << 2) + (n << 14);
                    return n ^ n >>> 16;
                }
            }
        }
    }

    private static final class SynchronizedInvoker
    implements Invoker {
        private final Object lock;
        private final Invoker invoker;

        public SynchronizedInvoker(Invoker invoker, Object object) {
            this.invoker = invoker;
            this.lock = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object[] objectArray) {
            Object object = this.lock;
            synchronized (object) {
                return this.invoker.invoke(objectArray);
            }
        }
    }
}

