/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider;

import com.kenai.jaffl.util.BufferUtil;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public class StringIO {
    private static final ThreadLocal<SoftReference<StringIO>> localData = new ThreadLocal<SoftReference<StringIO>>(){

        @Override
        protected synchronized SoftReference<StringIO> initialValue() {
            return new SoftReference<StringIO>(new StringIO());
        }
    };
    private static final Charset defaultCharset = Charset.defaultCharset();
    public final CharsetEncoder encoder = defaultCharset.newEncoder();
    public final CharsetDecoder decoder = defaultCharset.newDecoder();
    public final int nulByteCount = Math.round(this.encoder.maxBytesPerChar());

    public static final StringIO getStringIO() {
        StringIO stringIO = localData.get().get();
        if (stringIO == null) {
            stringIO = new StringIO();
            localData.set(new SoftReference<StringIO>(stringIO));
        }
        return stringIO;
    }

    public StringIO() {
        this.encoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.decoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public final ByteBuffer toNative(CharSequence charSequence, int n, boolean bl) {
        int n2 = (int)(((float)Math.max(n, charSequence.length()) + 1.0f) * this.encoder.maxBytesPerChar());
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        if (bl) {
            this.toNative(charSequence, byteBuffer);
        }
        return byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ByteBuffer toNative(CharSequence charSequence, ByteBuffer byteBuffer) {
        byteBuffer.mark();
        try {
            this.encoder.reset();
            this.encoder.encode(CharBuffer.wrap(charSequence), byteBuffer, true);
            this.encoder.flush(byteBuffer);
            this.nulTerminate(byteBuffer);
        }
        finally {
            byteBuffer.reset();
        }
        return byteBuffer;
    }

    public final CharSequence fromNative(ByteBuffer byteBuffer, int n) {
        int n2 = BufferUtil.positionOf(byteBuffer, (byte)0);
        if (n2 < 0 || n2 > n) {
            n2 = n;
        }
        int n3 = byteBuffer.limit();
        byteBuffer.limit(n2);
        try {
            CharBuffer charBuffer = this.decoder.reset().decode(byteBuffer);
            return charBuffer;
        }
        catch (CharacterCodingException characterCodingException) {
            throw new Error("Illegal character data in native string", characterCodingException);
        }
        finally {
            byteBuffer.limit(n3);
        }
    }

    public final CharSequence fromNative(ByteBuffer byteBuffer) {
        try {
            return this.decoder.reset().decode(byteBuffer);
        }
        catch (CharacterCodingException characterCodingException) {
            throw new Error("Illegal character data in native string", characterCodingException);
        }
    }

    public final void nulTerminate(ByteBuffer byteBuffer) {
        int n;
        for (n = this.nulByteCount; n >= 4; n -= 4) {
            byteBuffer.putInt(0);
        }
        if (n >= 2) {
            byteBuffer.putShort((short)0);
            n -= 2;
        }
        if (n >= 1) {
            byteBuffer.put((byte)0);
        }
    }
}

