/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.provider.jffi.StubCompiler;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.NativeMethod;
import com.kenai.jffi.NativeMethods;
import com.kenai.jffi.PageManager;
import com.kenai.jnr.x86asm.Assembler;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

abstract class AbstractX86StubCompiler
extends StubCompiler {
    static final Map<Class, PageHolder> pages = Collections.synchronizedMap(new WeakHashMap());
    final List<Stub> stubs = new LinkedList<Stub>();

    AbstractX86StubCompiler() {
    }

    void attach(Class clazz) {
        long l;
        if (this.stubs.isEmpty()) {
            return;
        }
        long l2 = 0L;
        for (Stub stub : this.stubs) {
            l2 += (long)(stub.assembler.codeSize() + 8);
        }
        PageManager pageManager = PageManager.getInstance();
        long l3 = pageManager.allocatePages((int)(l = (l2 + pageManager.pageSize() - 1L) / pageManager.pageSize()), 3);
        if (l3 == 0L) {
            throw new OutOfMemoryError("allocatePages failed for codeSize=" + l2);
        }
        PageHolder pageHolder = new PageHolder(l3, l);
        ArrayList<NativeMethod> arrayList = new ArrayList<NativeMethod>(this.stubs.size());
        long l4 = l3;
        for (Stub stub : this.stubs) {
            Assembler assembler = stub.assembler;
            l4 = AbstractX86StubCompiler.align(l4, 8L);
            ByteBuffer byteBuffer = MemoryIO.getInstance().newDirectByteBuffer(l4, assembler.codeSize()).order(ByteOrder.LITTLE_ENDIAN);
            stub.assembler.relocCode(byteBuffer, l4);
            arrayList.add(new NativeMethod(l4, stub.name, stub.signature));
            l4 += (long)assembler.codeSize();
        }
        pageManager.protectPages(l3, (int)l, 5);
        NativeMethods.register(clazz, arrayList);
        pages.put(clazz, pageHolder);
    }

    static final int align(int n, int n2) {
        return n2 + (n - 1 & ~(n2 - 1));
    }

    static final long align(long l, long l2) {
        return l2 + (l - 1L & (l2 - 1L ^ 0xFFFFFFFFFFFFFFFFL));
    }

    final class PageHolder {
        final long memory;
        final long pageCount;

        public PageHolder(long l, long l2) {
            this.memory = l;
            this.pageCount = l2;
        }

        protected void finalize() throws Throwable {
            PageManager.getInstance().freePages(this.memory, (int)this.pageCount);
        }
    }

    final class Stub {
        final String name;
        final String signature;
        final Assembler assembler;

        public Stub(String string, String string2, Assembler assembler) {
            this.name = string;
            this.signature = string2;
            this.assembler = assembler;
        }
    }
}

