/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.Address;
import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.NativeLong;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.annotations.StdCall;
import com.kenai.jaffl.byref.ByReference;
import com.kenai.jaffl.mapper.FromNativeContext;
import com.kenai.jaffl.mapper.FromNativeConverter;
import com.kenai.jaffl.mapper.FunctionMapper;
import com.kenai.jaffl.mapper.MethodParameterContext;
import com.kenai.jaffl.mapper.MethodResultContext;
import com.kenai.jaffl.mapper.ToNativeContext;
import com.kenai.jaffl.mapper.ToNativeConverter;
import com.kenai.jaffl.mapper.TypeMapper;
import com.kenai.jaffl.provider.InvocationSession;
import com.kenai.jaffl.provider.jffi.AsmClassLoader;
import com.kenai.jaffl.provider.jffi.AsmRuntime;
import com.kenai.jaffl.provider.jffi.AsmUtil;
import com.kenai.jaffl.provider.jffi.CodegenUtils;
import com.kenai.jaffl.provider.jffi.DefaultInvokerFactory;
import com.kenai.jaffl.provider.jffi.EnumResultConverter;
import com.kenai.jaffl.provider.jffi.IdentityFunctionMapper;
import com.kenai.jaffl.provider.jffi.InvokerUtil;
import com.kenai.jaffl.provider.jffi.Library;
import com.kenai.jaffl.provider.jffi.LibraryLoader;
import com.kenai.jaffl.provider.jffi.NullTypeMapper;
import com.kenai.jaffl.provider.jffi.NumberUtil;
import com.kenai.jaffl.provider.jffi.SkinnyMethodAdapter;
import com.kenai.jaffl.provider.jffi.StubCompiler;
import com.kenai.jaffl.provider.jffi.SymbolNotFoundError;
import com.kenai.jaffl.struct.Struct;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.InvocationBuffer;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.Platform;
import com.kenai.jffi.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.python.objectweb.asm.ClassVisitor;
import org.python.objectweb.asm.ClassWriter;
import org.python.objectweb.asm.Label;
import org.python.objectweb.asm.Opcodes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmLibraryLoader
extends LibraryLoader
implements Opcodes {
    public static final boolean DEBUG = Boolean.getBoolean("jaffl.compile.dump");
    private static final LibraryLoader INSTANCE = new AsmLibraryLoader();
    private static final boolean FAST_NUMERIC_AVAILABLE = AsmLibraryLoader.isFastNumericAvailable();
    private static final boolean FAST_LONG_AVAILABLE = AsmLibraryLoader.isFastLongAvailable();
    private final AtomicLong nextClassID = new AtomicLong(0L);
    private final AtomicLong nextIvarID = new AtomicLong(0L);
    private final AtomicLong nextMethodID = new AtomicLong(0L);

    static final LibraryLoader getInstance() {
        return INSTANCE;
    }

    @Override
    boolean isInterfaceSupported(Class clazz, Map<LibraryOption, ?> map) {
        TypeMapper typeMapper = map.containsKey((Object)LibraryOption.TypeMapper) ? (TypeMapper)map.get((Object)LibraryOption.TypeMapper) : NullTypeMapper.INSTANCE;
        for (Method method : clazz.getDeclaredMethods()) {
            if (!this.isReturnTypeSupported(method.getReturnType()) && this.getResultConverter(method, typeMapper) == null) {
                System.err.println("Unsupported return type: " + method.getReturnType());
                return false;
            }
            for (Class<?> clazz2 : method.getParameterTypes()) {
                if (this.isParameterTypeSupported(clazz2) || typeMapper.getToNativeConverter(clazz2) != null) continue;
                System.err.println("Unsupported parameter type: " + clazz2);
                return false;
            }
        }
        return true;
    }

    private boolean isReturnTypeSupported(Class clazz) {
        return clazz.isPrimitive() || Byte.class == clazz || Short.class == clazz || Integer.class == clazz || Long.class == clazz || Float.class == clazz || Double.class == clazz || NativeLong.class == clazz || Pointer.class == clazz || Address.class == clazz || String.class == clazz || Struct.class.isAssignableFrom(clazz);
    }

    private boolean isParameterTypeSupported(Class clazz) {
        return clazz.isPrimitive() || Byte.class == clazz || Short.class == clazz || Integer.class == clazz || Long.class == clazz || Float.class == clazz || Double.class == clazz || NativeLong.class == clazz || Pointer.class.isAssignableFrom(clazz) || Address.class.isAssignableFrom(clazz) || Enum.class.isAssignableFrom(clazz) || Buffer.class.isAssignableFrom(clazz) || clazz.isArray() && clazz.getComponentType().isPrimitive() || Struct.class.isAssignableFrom(clazz) || clazz.isArray() && Struct.class.isAssignableFrom(clazz.getComponentType()) || clazz.isArray() && Pointer.class.isAssignableFrom(clazz.getComponentType()) || CharSequence.class.isAssignableFrom(clazz) || ByReference.class.isAssignableFrom(clazz) || StringBuilder.class.isAssignableFrom(clazz) || StringBuffer.class.isAssignableFrom(clazz);
    }

    @Override
    <T> T loadLibrary(Library library, Class<T> clazz, Map<LibraryOption, ?> map) {
        return this.generateInterfaceImpl(library, clazz, map);
    }

    private final <T> T generateInterfaceImpl(Library library, Class<T> clazz, Map<LibraryOption, ?> map) {
        Class<Object> clazz2;
        Executable executable;
        ClassWriter classWriter = new ClassWriter(2);
        ClassWriter classWriter2 = DEBUG ? AsmUtil.newCheckClassAdapter(AsmUtil.newTraceClassVisitor((ClassVisitor)classWriter, System.err)) : classWriter;
        String string = CodegenUtils.p(clazz) + "$jaffl$" + this.nextClassID.getAndIncrement();
        classWriter2.visit(49, 17, string, null, CodegenUtils.p(AbstractNativeInterface.class), new String[]{CodegenUtils.p(clazz)});
        SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(classWriter2.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE, Library.class, Function[].class, FromNativeConverter[].class, ToNativeConverter[][].class), null, null));
        skinnyMethodAdapter.start();
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.aload(1);
        skinnyMethodAdapter.invokespecial(CodegenUtils.p(AbstractNativeInterface.class), "<init>", CodegenUtils.sig(Void.TYPE, Library.class));
        Method[] methodArray = clazz.getMethods();
        Function[] functionArray = new Function[methodArray.length];
        FromNativeConverter[] fromNativeConverterArray = new FromNativeConverter[methodArray.length];
        ToNativeConverter[][] toNativeConverterArray = new ToNativeConverter[methodArray.length][0];
        FunctionMapper functionMapper = map.containsKey((Object)LibraryOption.FunctionMapper) ? (FunctionMapper)map.get((Object)LibraryOption.FunctionMapper) : IdentityFunctionMapper.INSTANCE;
        TypeMapper typeMapper = map.containsKey((Object)LibraryOption.TypeMapper) ? (TypeMapper)map.get((Object)LibraryOption.TypeMapper) : NullTypeMapper.INSTANCE;
        CallingConvention callingConvention = AsmLibraryLoader.getCallingConvention(clazz, map);
        StubCompiler stubCompiler = StubCompiler.newCompiler();
        for (int i = 0; i < methodArray.length; ++i) {
            boolean bl;
            Object object;
            executable = methodArray[i];
            clazz2 = ((Method)executable).getReturnType();
            Class[] classArray = ((Method)executable).getParameterTypes();
            Class<Object> clazz3 = clazz2;
            Class[] classArray2 = new Class[classArray.length];
            boolean bl2 = false;
            fromNativeConverterArray[i] = this.getResultConverter((Method)executable, typeMapper);
            if (fromNativeConverterArray[i] != null) {
                classWriter2.visitField(18, this.getResultConverterFieldName(i), CodegenUtils.ci(FromNativeConverter.class), null, null);
                clazz3 = fromNativeConverterArray[i].nativeType();
                bl2 = true;
            }
            toNativeConverterArray[i] = new ToNativeConverter[classArray.length];
            for (int j = 0; j < classArray.length; ++j) {
                object = typeMapper.getToNativeConverter(classArray[j]);
                if (object != null) {
                    classWriter2.visitField(18, this.getParameterConverterFieldName(i, j), CodegenUtils.ci(ToNativeConverter.class), null, null);
                    classArray2[j] = object.nativeType();
                    toNativeConverterArray[i][j] = new ToNativeProxy((ToNativeConverter)object, new MethodParameterContext((Method)executable, j));
                    bl2 = true;
                    continue;
                }
                classArray2[j] = classArray[j];
            }
            String string2 = functionMapper.mapFunctionName(((Method)executable).getName(), null);
            classWriter2.visitField(26, "name_" + i, CodegenUtils.ci(String.class), null, string2);
            object = ((Method)executable).getAnnotation(StdCall.class) != null ? CallingConvention.STDCALL : callingConvention;
            try {
                functionArray[i] = AsmLibraryLoader.getFunction(library.findSymbolAddress(string2), clazz3, classArray2, InvokerUtil.requiresErrno((Method)executable), (CallingConvention)((Object)object));
            }
            catch (SymbolNotFoundError symbolNotFoundError) {
                classWriter2.visitField(26, "error_" + i, CodegenUtils.ci(String.class), null, symbolNotFoundError.getMessage());
                this.generateFunctionNotFound(classWriter2, string, i, string2, clazz2, classArray);
                continue;
            }
            String string3 = "function_" + i;
            classWriter2.visitField(18, string3, CodegenUtils.ci(Function.class), null, null);
            boolean bl3 = bl = !InvokerUtil.requiresErrno((Method)executable);
            if (this.canCompile(stubCompiler, clazz3, classArray2, (CallingConvention)((Object)object))) {
                this.compile(stubCompiler, functionArray[i], classWriter2, string, ((Method)executable).getName() + (bl2 ? "$raw" : ""), string3, clazz3, classArray2, ((Method)executable).getParameterAnnotations(), (CallingConvention)((Object)object), bl);
            } else {
                this.generateMethod(classWriter2, string, ((Method)executable).getName() + (bl2 ? "$raw" : ""), string3, clazz3, classArray2, ((Method)executable).getParameterAnnotations(), (CallingConvention)((Object)object), bl);
            }
            if (bl2) {
                this.generateConversionMethod(classWriter2, string, ((Method)executable).getName(), i, clazz2, classArray, clazz3, classArray2);
            }
            skinnyMethodAdapter.aload(0);
            skinnyMethodAdapter.aload(2);
            skinnyMethodAdapter.pushInt(i);
            skinnyMethodAdapter.aaload();
            skinnyMethodAdapter.putfield(string, string3, CodegenUtils.ci(Function.class));
            if (fromNativeConverterArray[i] != null) {
                skinnyMethodAdapter.aload(0);
                skinnyMethodAdapter.aload(3);
                skinnyMethodAdapter.pushInt(i);
                skinnyMethodAdapter.aaload();
                skinnyMethodAdapter.putfield(string, this.getResultConverterFieldName(i), CodegenUtils.ci(FromNativeConverter.class));
            }
            for (int j = 0; j < classArray.length; ++j) {
                if (toNativeConverterArray[i][j] == null) continue;
                skinnyMethodAdapter.aload(0);
                skinnyMethodAdapter.aload(4);
                skinnyMethodAdapter.pushInt(i);
                skinnyMethodAdapter.aaload();
                skinnyMethodAdapter.pushInt(j);
                skinnyMethodAdapter.aaload();
                skinnyMethodAdapter.putfield(string, this.getParameterConverterFieldName(i, j), CodegenUtils.ci(ToNativeConverter.class));
            }
        }
        skinnyMethodAdapter.voidreturn();
        skinnyMethodAdapter.visitMaxs(10, 10);
        skinnyMethodAdapter.visitEnd();
        classWriter2.visitEnd();
        try {
            Class clazz4 = new AsmClassLoader(clazz.getClassLoader()).defineClass(string.replace("/", "."), classWriter.toByteArray());
            executable = clazz4.getDeclaredConstructor(Library.class, Function[].class, FromNativeConverter[].class, ToNativeConverter[][].class);
            clazz2 = ((Constructor)executable).newInstance(new Object[]{library, functionArray, fromNativeConverterArray, toNativeConverterArray});
            stubCompiler.attach(clazz4);
            return (T)clazz2;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private final FromNativeConverter getResultConverter(Method method, TypeMapper typeMapper) {
        Class<?> clazz = method.getReturnType();
        FromNativeConverter fromNativeConverter = typeMapper.getFromNativeConverter(clazz);
        if (fromNativeConverter != null) {
            return new FromNativeProxy(fromNativeConverter, new MethodResultContext(method));
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return new EnumResultConverter(clazz);
        }
        return null;
    }

    private static final CallingConvention getCallingConvention(Class clazz, Map<LibraryOption, ?> map) {
        if (clazz.getAnnotation(StdCall.class) != null) {
            return CallingConvention.STDCALL;
        }
        return InvokerUtil.getCallingConvention(map);
    }

    private final String getFunctionFieldName(int n) {
        return "function_" + n;
    }

    private final String getResultConverterFieldName(int n) {
        return "resultConverter_" + n;
    }

    private final String getParameterConverterFieldName(int n, int n2) {
        return "parameterConverter_" + n + "_" + n2;
    }

    private final void generateFunctionNotFound(ClassVisitor classVisitor, String string, int n, String string2, Class clazz, Class[] classArray) {
        SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(classVisitor.visitMethod(17, string2, CodegenUtils.sig(clazz, classArray), null, null));
        skinnyMethodAdapter.start();
        skinnyMethodAdapter.getstatic(string, "error_" + n, CodegenUtils.ci(String.class));
        skinnyMethodAdapter.invokestatic(AsmRuntime.class, "newUnsatisifiedLinkError", UnsatisfiedLinkError.class, String.class);
        skinnyMethodAdapter.athrow();
        skinnyMethodAdapter.visitMaxs(10, 10);
        skinnyMethodAdapter.visitEnd();
    }

    private final void generateConversionMethod(ClassVisitor classVisitor, String string, String string2, int n, Class clazz, Class[] classArray, Class clazz2, Class[] classArray2) {
        SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(classVisitor.visitMethod(17, string2, CodegenUtils.sig(clazz, classArray), null, null));
        skinnyMethodAdapter.start();
        if (!clazz.equals(clazz2)) {
            skinnyMethodAdapter.aload(0);
            skinnyMethodAdapter.getfield(string, this.getResultConverterFieldName(n), CodegenUtils.ci(FromNativeConverter.class));
        }
        skinnyMethodAdapter.aload(0);
        int n2 = 1;
        for (int i = 0; i < classArray.length; ++i) {
            boolean bl;
            boolean bl2 = bl = !classArray[i].equals(classArray2[i]);
            if (bl) {
                skinnyMethodAdapter.aload(0);
                skinnyMethodAdapter.getfield(string, this.getParameterConverterFieldName(n, i), CodegenUtils.ci(ToNativeConverter.class));
            }
            n2 = this.loadParameter(skinnyMethodAdapter, classArray[i], n2);
            if (!bl) continue;
            if (classArray[i].isPrimitive()) {
                this.boxPrimitive(skinnyMethodAdapter, classArray[i]);
            }
            skinnyMethodAdapter.aconst_null();
            skinnyMethodAdapter.invokeinterface(ToNativeConverter.class, "toNative", Object.class, Object.class, ToNativeContext.class);
            skinnyMethodAdapter.checkcast(CodegenUtils.p(classArray2[i]));
        }
        skinnyMethodAdapter.invokevirtual(string, string2 + "$raw", CodegenUtils.sig(clazz2, classArray2));
        if (!clazz.equals(clazz2)) {
            if (clazz2.isPrimitive()) {
                this.boxPrimitive(skinnyMethodAdapter, clazz2);
            }
            skinnyMethodAdapter.aconst_null();
            skinnyMethodAdapter.invokeinterface(FromNativeConverter.class, "fromNative", Object.class, Object.class, FromNativeContext.class);
            skinnyMethodAdapter.checkcast(CodegenUtils.p(clazz));
        }
        AsmUtil.emitReturnOp(skinnyMethodAdapter, clazz);
        skinnyMethodAdapter.visitMaxs(10, 10);
        skinnyMethodAdapter.visitEnd();
    }

    private final boolean canCompile(StubCompiler stubCompiler, Class clazz, Class[] classArray, CallingConvention callingConvention) {
        Class[] classArray2 = new Class[classArray.length];
        for (int i = 0; i < classArray2.length; ++i) {
            classArray2[i] = AsmUtil.unboxedType(classArray[i]);
        }
        return stubCompiler.canCompile(AsmUtil.unboxedReturnType(clazz), classArray2, callingConvention);
    }

    private final void compile(StubCompiler stubCompiler, Function function, ClassVisitor classVisitor, String string, String string2, String string3, Class clazz, Class[] classArray, Annotation[][] annotationArray, CallingConvention callingConvention, boolean bl) {
        Class clazz2;
        Class[] classArray2 = new Class[classArray.length];
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i = 0; i < classArray2.length; ++i) {
            classArray2[i] = AsmUtil.unboxedType(classArray[i]);
            bl2 |= classArray2[i] != classArray[i];
            bl3 |= Pointer.class.isAssignableFrom(classArray[i]) || Struct.class.isAssignableFrom(classArray[i]);
        }
        String string4 = string2 + ((bl2 |= (clazz2 = AsmUtil.unboxedReturnType(clazz)) != clazz) || bl3 ? "$jni$" + this.nextMethodID.getAndIncrement() : "");
        if (bl2 || bl3) {
            SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(classVisitor.visitMethod(17, string2, CodegenUtils.sig(clazz, classArray), null, null));
            skinnyMethodAdapter.start();
            skinnyMethodAdapter.aload(0);
            Label label = AsmLibraryLoader.emitDirectCheck(skinnyMethodAdapter, classArray);
            int n = 1;
            for (int i = 0; i < classArray.length; ++i) {
                n = this.loadParameter(skinnyMethodAdapter, classArray[i], n);
                if (classArray[i] == classArray2[i]) continue;
                if (Number.class.isAssignableFrom(classArray[i])) {
                    AsmUtil.unboxNumber(skinnyMethodAdapter, classArray[i], classArray2[i]);
                    continue;
                }
                if (Pointer.class.isAssignableFrom(classArray[i])) {
                    AsmUtil.unboxPointer(skinnyMethodAdapter, classArray2[i]);
                    continue;
                }
                if (!Struct.class.isAssignableFrom(classArray[i])) continue;
                AsmUtil.unboxStruct(skinnyMethodAdapter, classArray2[i]);
            }
            skinnyMethodAdapter.invokevirtual(string, string4, CodegenUtils.sig(clazz2, classArray2));
            this.emitReturn(skinnyMethodAdapter, clazz, clazz2);
            String string5 = null;
            if (label != null) {
                skinnyMethodAdapter.label(label);
                string5 = string2 + "$buf$" + this.nextMethodID.getAndIncrement();
                int n2 = 1;
                for (n = 0; n < classArray.length; ++n) {
                    n2 = this.loadParameter(skinnyMethodAdapter, classArray[n], n2);
                }
                skinnyMethodAdapter.invokevirtual(string, string5, CodegenUtils.sig(clazz, classArray));
                AsmUtil.emitReturnOp(skinnyMethodAdapter, clazz);
            }
            skinnyMethodAdapter.visitMaxs(100, AsmUtil.calculateLocalVariableSpace(classArray) + 10);
            skinnyMethodAdapter.visitEnd();
            if (string5 != null) {
                SkinnyMethodAdapter skinnyMethodAdapter2 = new SkinnyMethodAdapter(classVisitor.visitMethod(17, string5, CodegenUtils.sig(clazz, classArray), null, null));
                skinnyMethodAdapter2.start();
                skinnyMethodAdapter2.getstatic(CodegenUtils.p(AbstractNativeInterface.class), "ffi", CodegenUtils.ci(Invoker.class));
                skinnyMethodAdapter2.aload(0);
                skinnyMethodAdapter2.getfield(string, string3, CodegenUtils.ci(Function.class));
                this.generateBufferInvocation(skinnyMethodAdapter2, clazz, classArray, annotationArray);
                skinnyMethodAdapter2.visitMaxs(100, AsmUtil.calculateLocalVariableSpace(classArray) + 10);
                skinnyMethodAdapter2.visitEnd();
            }
        }
        classVisitor.visitMethod(273, string4, CodegenUtils.sig(clazz2, classArray2), null, null);
        stubCompiler.compile(function, string4, clazz2, classArray2, callingConvention, !bl);
    }

    private final void generateMethod(ClassVisitor classVisitor, String string, String string2, String string3, Class clazz, Class[] classArray, Annotation[][] annotationArray, CallingConvention callingConvention, boolean bl) {
        SkinnyMethodAdapter skinnyMethodAdapter = new SkinnyMethodAdapter(classVisitor.visitMethod(17, string2, CodegenUtils.sig(clazz, classArray), null, null));
        skinnyMethodAdapter.start();
        skinnyMethodAdapter.getstatic(CodegenUtils.p(AbstractNativeInterface.class), "ffi", CodegenUtils.ci(Invoker.class));
        skinnyMethodAdapter.aload(0);
        skinnyMethodAdapter.getfield(string, string3, CodegenUtils.ci(Function.class));
        if (callingConvention == CallingConvention.DEFAULT && AsmLibraryLoader.isFastIntegerMethod(clazz, classArray)) {
            this.generateFastIntegerInvocation(skinnyMethodAdapter, clazz, classArray, annotationArray, bl);
        } else if (callingConvention == CallingConvention.DEFAULT && FAST_NUMERIC_AVAILABLE && AsmLibraryLoader.isFastNumericMethod(clazz, classArray)) {
            this.generateFastNumericInvocation(skinnyMethodAdapter, clazz, classArray, annotationArray);
        } else {
            this.generateBufferInvocation(skinnyMethodAdapter, clazz, classArray, annotationArray);
        }
        skinnyMethodAdapter.visitMaxs(100, AsmUtil.calculateLocalVariableSpace(classArray) + 10);
        skinnyMethodAdapter.visitEnd();
    }

    private final void generateBufferInvocation(SkinnyMethodAdapter skinnyMethodAdapter, Class clazz, Class[] classArray, Annotation[][] annotationArray) {
        int n;
        boolean bl = AsmLibraryLoader.isSessionRequired(classArray);
        int n2 = n = bl ? AsmUtil.calculateLocalVariableSpace(classArray) + 1 : -1;
        if (bl) {
            skinnyMethodAdapter.newobj(CodegenUtils.p(InvocationSession.class));
            skinnyMethodAdapter.dup();
            skinnyMethodAdapter.invokespecial(InvocationSession.class, "<init>", Void.TYPE, new Class[0]);
            skinnyMethodAdapter.astore(n);
        }
        skinnyMethodAdapter.newobj(CodegenUtils.p(HeapInvocationBuffer.class));
        skinnyMethodAdapter.dup2();
        skinnyMethodAdapter.swap();
        skinnyMethodAdapter.invokespecial(HeapInvocationBuffer.class, "<init>", Void.TYPE, Function.class);
        int n3 = 1;
        for (int i = 0; i < classArray.length; ++i) {
            skinnyMethodAdapter.dup();
            if (AsmLibraryLoader.isSessionRequired(classArray[i])) {
                skinnyMethodAdapter.aload(n);
                skinnyMethodAdapter.swap();
            }
            n3 = this.loadParameter(skinnyMethodAdapter, classArray[i], n3);
            int n4 = DefaultInvokerFactory.getParameterFlags(annotationArray[i]);
            int n5 = DefaultInvokerFactory.getNativeArrayFlags(n4) | ((n4 & 2) != 0 ? 4 : 0);
            if (classArray[i].isArray() && classArray[i].getComponentType().isPrimitive()) {
                skinnyMethodAdapter.pushInt(n5);
                this.marshal(skinnyMethodAdapter, classArray[i], Integer.TYPE);
                continue;
            }
            if (Pointer.class.isAssignableFrom(classArray[i])) {
                skinnyMethodAdapter.pushInt(n5);
                this.marshal(skinnyMethodAdapter, Pointer.class, Integer.TYPE);
                continue;
            }
            if (Address.class.isAssignableFrom(classArray[i])) {
                this.marshal(skinnyMethodAdapter, Pointer.class);
                continue;
            }
            if (Enum.class.isAssignableFrom(classArray[i])) {
                this.marshal(skinnyMethodAdapter, Enum.class);
                continue;
            }
            if (Buffer.class.isAssignableFrom(classArray[i])) {
                skinnyMethodAdapter.pushInt(n5);
                this.marshal(skinnyMethodAdapter, classArray[i], Integer.TYPE);
                continue;
            }
            if (ByReference.class.isAssignableFrom(classArray[i])) {
                skinnyMethodAdapter.pushInt(n5);
                this.sessionmarshal(skinnyMethodAdapter, ByReference.class, Integer.TYPE);
                continue;
            }
            if (StringBuilder.class.isAssignableFrom(classArray[i]) || StringBuffer.class.isAssignableFrom(classArray[i])) {
                skinnyMethodAdapter.pushInt(n4);
                skinnyMethodAdapter.pushInt(n5);
                this.sessionmarshal(skinnyMethodAdapter, classArray[i], Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (CharSequence.class.isAssignableFrom(classArray[i])) {
                this.marshal(skinnyMethodAdapter, CharSequence.class);
                continue;
            }
            if (Struct.class.isAssignableFrom(classArray[i])) {
                skinnyMethodAdapter.pushInt(n4);
                skinnyMethodAdapter.pushInt(n5);
                this.marshal(skinnyMethodAdapter, Struct.class, Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (classArray[i].isArray() && Struct.class.isAssignableFrom(classArray[i].getComponentType())) {
                skinnyMethodAdapter.pushInt(n4);
                skinnyMethodAdapter.pushInt(n5);
                this.marshal(skinnyMethodAdapter, Struct[].class, Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (classArray[i].isArray() && Pointer.class.isAssignableFrom(classArray[i].getComponentType())) {
                skinnyMethodAdapter.pushInt(n4);
                skinnyMethodAdapter.pushInt(n5);
                this.sessionmarshal(skinnyMethodAdapter, Pointer[].class, Integer.TYPE, Integer.TYPE);
                continue;
            }
            if (classArray[i].isPrimitive() || Number.class.isAssignableFrom(classArray[i])) {
                this.emitInvocationBufferIntParameter(skinnyMethodAdapter, classArray[i]);
                continue;
            }
            throw new IllegalArgumentException("unsupported parameter type " + classArray[i]);
        }
        String string = null;
        Class<Number> clazz2 = null;
        if (NumberUtil.isPrimitiveInt(clazz) || Void.TYPE == clazz || Byte.class == clazz || Short.class == clazz || Integer.class == clazz) {
            string = "invokeInt";
            clazz2 = Integer.TYPE;
        } else if (Long.class == clazz || Long.TYPE == clazz) {
            string = "invokeLong";
            clazz2 = Long.TYPE;
        } else if (NativeLong.class == clazz) {
            string = NativeLong.SIZE == 32 ? "invokeInt" : "invokeLong";
            clazz2 = NativeLong.SIZE == 32 ? Integer.TYPE : Long.TYPE;
        } else if (Pointer.class == clazz || Address.class == clazz || Struct.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz)) {
            string = "invokeAddress";
            clazz2 = Long.TYPE;
        } else if (Float.class == clazz || Float.TYPE == clazz) {
            string = "invokeFloat";
            clazz2 = Float.TYPE;
        } else if (Double.class == clazz || Double.TYPE == clazz) {
            string = "invokeDouble";
            clazz2 = Double.TYPE;
        } else {
            throw new IllegalArgumentException("unsupported return type " + clazz);
        }
        skinnyMethodAdapter.invokevirtual(Invoker.class, string, clazz2, Function.class, HeapInvocationBuffer.class);
        if (bl) {
            skinnyMethodAdapter.aload(n);
            skinnyMethodAdapter.invokevirtual(CodegenUtils.p(InvocationSession.class), "finish", "()V");
        }
        this.emitReturn(skinnyMethodAdapter, clazz, clazz2);
    }

    private final void generateFastIntegerInvocation(SkinnyMethodAdapter skinnyMethodAdapter, Class clazz, Class[] classArray, Annotation[][] annotationArray, boolean bl) {
        Label label = AsmLibraryLoader.emitDirectCheck(skinnyMethodAdapter, classArray);
        Class<? extends Number> clazz2 = AsmLibraryLoader.getNativeIntType(clazz, classArray);
        int n = 1;
        for (int i = 0; i < classArray.length; ++i) {
            n = this.loadParameter(skinnyMethodAdapter, classArray[i], n);
            if (classArray[i].isPrimitive()) {
                NumberUtil.widen(skinnyMethodAdapter, classArray[i], clazz2);
                continue;
            }
            if (Number.class.isAssignableFrom(classArray[i])) {
                AsmUtil.unboxNumber(skinnyMethodAdapter, classArray[i], clazz2);
                continue;
            }
            if (Pointer.class.isAssignableFrom(classArray[i])) {
                AsmUtil.unboxPointer(skinnyMethodAdapter, clazz2);
                continue;
            }
            if (!Struct.class.isAssignableFrom(classArray[i])) continue;
            AsmUtil.unboxStruct(skinnyMethodAdapter, clazz2);
        }
        skinnyMethodAdapter.invokevirtual(CodegenUtils.p(Invoker.class), AsmLibraryLoader.getFastIntInvokerMethodName(classArray.length, bl, clazz2), AsmLibraryLoader.getFastIntInvokerSignature(classArray.length, clazz2));
        this.emitReturn(skinnyMethodAdapter, clazz, clazz2);
        if (label != null) {
            skinnyMethodAdapter.label(label);
            this.generateBufferInvocation(skinnyMethodAdapter, clazz, classArray, annotationArray);
        }
    }

    private final void generateFastNumericInvocation(SkinnyMethodAdapter skinnyMethodAdapter, Class clazz, Class[] classArray, Annotation[][] annotationArray) {
        Label label = AsmLibraryLoader.emitDirectCheck(skinnyMethodAdapter, classArray);
        int n = 1;
        for (int i = 0; i < classArray.length; ++i) {
            n = this.loadParameter(skinnyMethodAdapter, classArray[i], n);
            if (Pointer.class.isAssignableFrom(classArray[i])) {
                AsmUtil.unboxPointer(skinnyMethodAdapter, Long.TYPE);
                continue;
            }
            if (Struct.class.isAssignableFrom(classArray[i])) {
                AsmUtil.unboxStruct(skinnyMethodAdapter, Long.TYPE);
                continue;
            }
            if (!classArray[i].isPrimitive() && Number.class.isAssignableFrom(classArray[i])) {
                AsmUtil.unboxNumber(skinnyMethodAdapter, classArray[i], Long.TYPE);
            }
            if (Float.class == classArray[i] || Float.TYPE == classArray[i]) {
                skinnyMethodAdapter.invokestatic(Float.class, "floatToRawIntBits", Integer.TYPE, Float.TYPE);
                skinnyMethodAdapter.i2l();
                continue;
            }
            if (Double.class == classArray[i] || Double.TYPE == classArray[i]) {
                skinnyMethodAdapter.invokestatic(Double.class, "doubleToRawLongBits", Long.TYPE, Double.TYPE);
                continue;
            }
            NumberUtil.widen(skinnyMethodAdapter, classArray[i], Long.TYPE);
        }
        skinnyMethodAdapter.invokevirtual(CodegenUtils.p(Invoker.class), AsmLibraryLoader.getFastNumericInvokerMethodName(classArray.length, clazz), AsmLibraryLoader.getFastNumericInvokerSignature(classArray.length));
        if (Float.class == clazz || Float.TYPE == clazz) {
            skinnyMethodAdapter.l2i();
            skinnyMethodAdapter.invokestatic(Float.class, "intBitsToFloat", Float.TYPE, Integer.TYPE);
        } else if (Double.class == clazz || Double.TYPE == clazz) {
            skinnyMethodAdapter.invokestatic(Double.class, "longBitsToDouble", Double.TYPE, Long.TYPE);
        }
        this.emitReturn(skinnyMethodAdapter, clazz, Long.TYPE);
        if (label != null) {
            skinnyMethodAdapter.label(label);
            this.generateBufferInvocation(skinnyMethodAdapter, clazz, classArray, annotationArray);
        }
    }

    private static final Label emitDirectCheck(SkinnyMethodAdapter skinnyMethodAdapter, Class[] classArray) {
        Label label = new Label();
        boolean bl = false;
        int n = 1;
        for (int i = 0; i < classArray.length; ++i) {
            if (Pointer.class.isAssignableFrom(classArray[i])) {
                skinnyMethodAdapter.aload(n++);
                skinnyMethodAdapter.invokestatic(AsmRuntime.class, "isDirect", Boolean.TYPE, Pointer.class);
                skinnyMethodAdapter.iffalse(label);
                bl = true;
                continue;
            }
            if (Struct.class.isAssignableFrom(classArray[i])) {
                skinnyMethodAdapter.aload(n++);
                skinnyMethodAdapter.invokestatic(AsmRuntime.class, "isDirect", Boolean.TYPE, Struct.class);
                skinnyMethodAdapter.iffalse(label);
                bl = true;
                continue;
            }
            n += AsmUtil.calculateLocalVariableSpace(classArray[i]);
        }
        return bl ? label : null;
    }

    private final void emitReturn(SkinnyMethodAdapter skinnyMethodAdapter, Class clazz, Class clazz2) {
        if (clazz.isPrimitive()) {
            if (Long.TYPE == clazz) {
                NumberUtil.widen(skinnyMethodAdapter, clazz2, clazz);
                skinnyMethodAdapter.lreturn();
            } else if (Float.TYPE == clazz) {
                skinnyMethodAdapter.freturn();
            } else if (Double.TYPE == clazz) {
                skinnyMethodAdapter.dreturn();
            } else if (Void.TYPE == clazz) {
                skinnyMethodAdapter.voidreturn();
            } else {
                NumberUtil.narrow(skinnyMethodAdapter, clazz2, clazz);
                skinnyMethodAdapter.ireturn();
            }
        } else {
            this.boxValue(skinnyMethodAdapter, clazz, clazz2);
            skinnyMethodAdapter.areturn();
        }
    }

    private final int loadParameter(SkinnyMethodAdapter skinnyMethodAdapter, Class clazz, int n) {
        if (!clazz.isPrimitive()) {
            skinnyMethodAdapter.aload(n++);
        } else if (Long.TYPE == clazz) {
            skinnyMethodAdapter.lload(n);
            n += 2;
        } else if (Float.TYPE == clazz) {
            skinnyMethodAdapter.fload(n++);
        } else if (Double.TYPE == clazz) {
            skinnyMethodAdapter.dload(n);
            n += 2;
        } else {
            skinnyMethodAdapter.iload(n++);
        }
        return n;
    }

    private static final Class<? extends Number> getNativeIntType(Class clazz, Class[] classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            if (!AsmLibraryLoader.requiresLong(classArray[i])) continue;
            return Long.TYPE;
        }
        return AsmLibraryLoader.requiresLong(clazz) ? Long.TYPE : Integer.TYPE;
    }

    static final String getFastIntInvokerMethodName(int n, boolean bl, Class clazz) {
        String string;
        StringBuilder stringBuilder = new StringBuilder("invoke");
        if (bl && Integer.TYPE == clazz) {
            stringBuilder.append("NoErrno");
        }
        String string2 = string = Integer.TYPE == clazz ? "I" : "L";
        if (n < 1) {
            stringBuilder.append("V");
        } else {
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(string);
            }
        }
        return stringBuilder.append("r").append(string).toString();
    }

    static final String getFastIntInvokerSignature(int n, Class clazz) {
        String string = Integer.TYPE == clazz ? "I" : "J";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(CodegenUtils.ci(Function.class));
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        stringBuilder.append(")").append(string);
        return stringBuilder.toString();
    }

    static final String getFastNumericInvokerMethodName(int n, Class clazz) {
        StringBuilder stringBuilder = new StringBuilder("invoke");
        if (n < 1) {
            stringBuilder.append("V");
        } else {
            for (int i = 0; i < n; ++i) {
                stringBuilder.append("N");
            }
        }
        return stringBuilder.append("r").append("N").toString();
    }

    static final String getFastNumericInvokerSignature(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(CodegenUtils.ci(Function.class));
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("J");
        }
        stringBuilder.append(")").append("J");
        return stringBuilder.toString();
    }

    private final void boxStruct(SkinnyMethodAdapter skinnyMethodAdapter, Class clazz) {
        skinnyMethodAdapter.dup2();
        Label label = new Label();
        Label label2 = new Label();
        skinnyMethodAdapter.lconst_0();
        skinnyMethodAdapter.lcmp();
        skinnyMethodAdapter.ifne(label);
        skinnyMethodAdapter.pop2();
        skinnyMethodAdapter.aconst_null();
        skinnyMethodAdapter.go_to(label2);
        skinnyMethodAdapter.label(label);
        skinnyMethodAdapter.newobj(CodegenUtils.p(clazz));
        skinnyMethodAdapter.dup();
        skinnyMethodAdapter.invokespecial(clazz, "<init>", Void.TYPE, new Class[0]);
        skinnyMethodAdapter.dup_x2();
        skinnyMethodAdapter.invokestatic(AsmRuntime.class, "useMemory", Void.TYPE, Long.TYPE, Struct.class);
        skinnyMethodAdapter.label(label2);
    }

    private final void boxPrimitive(SkinnyMethodAdapter skinnyMethodAdapter, Class clazz) {
        Class clazz2 = NumberUtil.getBoxedClass(clazz);
        skinnyMethodAdapter.invokestatic(clazz2, "valueOf", clazz2, clazz);
    }

    private final void boxNumber(SkinnyMethodAdapter skinnyMethodAdapter, Class clazz, Class clazz2) {
        Class<Long> clazz3 = NumberUtil.getPrimitiveClass(clazz);
        if (Byte.class.isAssignableFrom(clazz)) {
            NumberUtil.narrow(skinnyMethodAdapter, clazz2, Byte.TYPE);
        } else if (Character.class.isAssignableFrom(clazz)) {
            NumberUtil.narrow(skinnyMethodAdapter, clazz2, Character.TYPE);
        } else if (Short.class.isAssignableFrom(clazz)) {
            NumberUtil.narrow(skinnyMethodAdapter, clazz2, Short.TYPE);
        } else if (Integer.class.isAssignableFrom(clazz)) {
            NumberUtil.narrow(skinnyMethodAdapter, clazz2, Integer.TYPE);
        } else if (Long.class.isAssignableFrom(clazz)) {
            NumberUtil.widen(skinnyMethodAdapter, clazz2, Long.TYPE);
        } else if (NativeLong.class.isAssignableFrom(clazz)) {
            NumberUtil.widen(skinnyMethodAdapter, clazz2, Long.TYPE);
            clazz3 = Long.TYPE;
        } else if (Boolean.class.isAssignableFrom(clazz)) {
            NumberUtil.narrow(skinnyMethodAdapter, clazz2, Integer.TYPE);
        } else if (Float.class != clazz && Double.class != clazz) {
            throw new IllegalArgumentException("invalid Number subclass");
        }
        skinnyMethodAdapter.invokestatic(clazz, "valueOf", clazz, clazz3);
    }

    private final void boxValue(SkinnyMethodAdapter skinnyMethodAdapter, Class clazz, Class clazz2) {
        if (clazz == clazz2) {
            return;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            NumberUtil.narrow(skinnyMethodAdapter, clazz2, Integer.TYPE);
            skinnyMethodAdapter.invokestatic(Boolean.class, "valueOf", Boolean.class, Boolean.TYPE);
        } else if (Pointer.class.isAssignableFrom(clazz)) {
            skinnyMethodAdapter.invokestatic(AsmRuntime.class, "pointerValue", Pointer.class, clazz2);
        } else if (Address.class == clazz) {
            NumberUtil.widen(skinnyMethodAdapter, clazz2, Long.TYPE);
            skinnyMethodAdapter.invokestatic(clazz, "valueOf", clazz, Long.TYPE);
        } else if (Struct.class.isAssignableFrom(clazz)) {
            NumberUtil.widen(skinnyMethodAdapter, clazz2, Long.TYPE);
            this.boxStruct(skinnyMethodAdapter, clazz);
        } else if (Number.class.isAssignableFrom(clazz)) {
            this.boxNumber(skinnyMethodAdapter, clazz, clazz2);
        } else if (String.class == clazz) {
            NumberUtil.widen(skinnyMethodAdapter, clazz2, Long.TYPE);
            skinnyMethodAdapter.invokestatic(AsmRuntime.class, "returnString", String.class, Long.TYPE);
        } else {
            throw new IllegalArgumentException("cannot box value of type " + clazz2 + " to " + clazz);
        }
    }

    private final void emitInvocationBufferIntParameter(SkinnyMethodAdapter skinnyMethodAdapter, Class clazz) {
        String string = null;
        Class<Number> clazz2 = Integer.TYPE;
        if (!clazz.isPrimitive()) {
            AsmUtil.unboxNumber(skinnyMethodAdapter, clazz, null);
        }
        if (Byte.TYPE == clazz || Byte.class == clazz) {
            string = "putByte";
        } else if (Short.TYPE == clazz || Short.class == clazz) {
            string = "putShort";
        } else if (Integer.TYPE == clazz || Integer.class == clazz || Boolean.TYPE == clazz) {
            string = "putInt";
        } else if (Long.TYPE == clazz || Long.class == clazz) {
            string = "putLong";
            clazz2 = Long.TYPE;
        } else if (Float.TYPE == clazz || Float.class == clazz) {
            string = "putFloat";
            clazz2 = Float.TYPE;
        } else if (Double.TYPE == clazz || Double.class == clazz) {
            string = "putDouble";
            clazz2 = Double.TYPE;
        } else if (NativeLong.class.isAssignableFrom(clazz) && Platform.getPlatform().longSize() == 32) {
            string = "putInt";
            clazz2 = Integer.TYPE;
        } else if (NativeLong.class.isAssignableFrom(clazz) && Platform.getPlatform().longSize() == 64) {
            string = "putLong";
            clazz2 = Long.TYPE;
        } else {
            throw new IllegalArgumentException("unsupported parameter type " + clazz);
        }
        skinnyMethodAdapter.invokevirtual(HeapInvocationBuffer.class, string, Void.TYPE, clazz2);
    }

    private final void marshal(SkinnyMethodAdapter skinnyMethodAdapter, Class ... classArray) {
        skinnyMethodAdapter.invokestatic(CodegenUtils.p(AsmRuntime.class), "marshal", CodegenUtils.sig(Void.TYPE, CodegenUtils.ci(InvocationBuffer.class), classArray));
    }

    private final void sessionmarshal(SkinnyMethodAdapter skinnyMethodAdapter, Class ... classArray) {
        skinnyMethodAdapter.invokestatic(CodegenUtils.p(AsmRuntime.class), "marshal", CodegenUtils.sig(Void.TYPE, CodegenUtils.ci(InvocationSession.class) + CodegenUtils.ci(InvocationBuffer.class), classArray));
    }

    private static final Function getFunction(long l, Class clazz, Class[] classArray, boolean bl, CallingConvention callingConvention) {
        Type[] typeArray = new Type[classArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            typeArray[i] = InvokerUtil.getNativeParameterType(classArray[i]);
        }
        return new Function(l, InvokerUtil.getNativeReturnType(clazz), typeArray, callingConvention, bl);
    }

    private static boolean isSessionRequired(Class clazz) {
        return StringBuilder.class.isAssignableFrom(clazz) || StringBuffer.class.isAssignableFrom(clazz) || ByReference.class.isAssignableFrom(clazz) || clazz.isArray() && Pointer.class.isAssignableFrom(clazz.getComponentType());
    }

    private static boolean isSessionRequired(Class[] classArray) {
        for (int i = 0; i < classArray.length; ++i) {
            if (!AsmLibraryLoader.isSessionRequired(classArray[i])) continue;
            return true;
        }
        return false;
    }

    static final boolean isFastNumericMethod(Class clazz, Class[] classArray) {
        if (!FAST_NUMERIC_AVAILABLE || classArray.length > 6) {
            return false;
        }
        if (!AsmLibraryLoader.isFastNumericResult(clazz)) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (AsmLibraryLoader.isFastNumericParam(classArray[i])) continue;
            return false;
        }
        return Platform.getPlatform().getCPU() == Platform.CPU.I386 || Platform.getPlatform().getCPU() == Platform.CPU.X86_64;
    }

    static final boolean isFastIntegerMethod(Class clazz, Class[] classArray) {
        if (classArray.length > 3) {
            return false;
        }
        if (!AsmLibraryLoader.isFastIntegerResult(clazz)) {
            return false;
        }
        for (int i = 0; i < classArray.length; ++i) {
            if (AsmLibraryLoader.isFastIntegerParam(classArray[i])) continue;
            return false;
        }
        return Platform.getPlatform().getCPU() == Platform.CPU.I386 || Platform.getPlatform().getCPU() == Platform.CPU.X86_64;
    }

    static final boolean isInt32(Class clazz) {
        return Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE == clazz || Byte.class.isAssignableFrom(clazz) || Byte.TYPE == clazz || Short.class.isAssignableFrom(clazz) || Short.TYPE == clazz || Integer.class.isAssignableFrom(clazz) || Integer.TYPE == clazz;
    }

    static final boolean isInt32Result(Class clazz) {
        return AsmLibraryLoader.isInt32(clazz) || Void.class.isAssignableFrom(clazz) || Void.TYPE == clazz;
    }

    static final boolean isPointerResult(Class clazz) {
        return Pointer.class.isAssignableFrom(clazz) || Struct.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz);
    }

    static final boolean isPointerParam(Class clazz) {
        return Pointer.class.isAssignableFrom(clazz) || Struct.class.isAssignableFrom(clazz);
    }

    private static final boolean isFastIntegerResult(Class clazz) {
        if (AsmLibraryLoader.isInt32Result(clazz)) {
            return true;
        }
        boolean bl = AsmLibraryLoader.isPointerResult(clazz);
        if (bl && Platform.getPlatform().addressSize() == 32) {
            return true;
        }
        if (NativeLong.class.isAssignableFrom(clazz) && Platform.getPlatform().longSize() == 32) {
            return true;
        }
        boolean bl2 = Long.class == clazz || Long.TYPE == clazz;
        return Platform.getPlatform().addressSize() == 64 && FAST_LONG_AVAILABLE && (bl || NativeLong.class.isAssignableFrom(clazz) || bl2);
    }

    private static final boolean isFastIntegerParam(Class clazz) {
        if (AsmLibraryLoader.isInt32(clazz)) {
            return true;
        }
        boolean bl = AsmLibraryLoader.isPointerParam(clazz);
        if (bl && Platform.getPlatform().addressSize() == 32) {
            return true;
        }
        if (NativeLong.class.isAssignableFrom(clazz) && Platform.getPlatform().longSize() == 32) {
            return true;
        }
        boolean bl2 = Long.class == clazz || Long.TYPE == clazz;
        return Platform.getPlatform().addressSize() == 64 && FAST_LONG_AVAILABLE && (bl || NativeLong.class.isAssignableFrom(clazz) || bl2);
    }

    static final boolean isFastNumericResult(Class clazz) {
        return AsmLibraryLoader.isFastIntegerResult(clazz) || Long.class.isAssignableFrom(clazz) || Long.TYPE == clazz || NativeLong.class.isAssignableFrom(clazz) || Pointer.class.isAssignableFrom(clazz) || Struct.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz) || Float.TYPE == clazz || Float.class == clazz || Double.TYPE == clazz || Double.class == clazz;
    }

    static final boolean isFastNumericParam(Class clazz) {
        return AsmLibraryLoader.isFastIntegerParam(clazz) || Long.class.isAssignableFrom(clazz) || Long.TYPE == clazz || NativeLong.class.isAssignableFrom(clazz) || Pointer.class.isAssignableFrom(clazz) || Struct.class.isAssignableFrom(clazz) || Float.TYPE == clazz || Float.class == clazz || Double.TYPE == clazz || Double.class == clazz;
    }

    static final boolean isFastNumericAvailable() {
        try {
            Invoker.class.getDeclaredMethod("invokeNNNNNNrN", Function.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static final boolean isFastLongAvailable() {
        try {
            Invoker.class.getDeclaredMethod("invokeLLLLLLrL", Function.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static final boolean requiresLong(Class clazz) {
        return Long.class.isAssignableFrom(clazz) || Long.TYPE == clazz || NativeLong.class.isAssignableFrom(clazz) && Platform.getPlatform().longSize() == 64 || Pointer.class.isAssignableFrom(clazz) && Platform.getPlatform().addressSize() == 64 || Struct.class.isAssignableFrom(clazz) && Platform.getPlatform().addressSize() == 64 || String.class.isAssignableFrom(clazz) && Platform.getPlatform().addressSize() == 64;
    }

    public static void main(String[] stringArray) {
        System.setProperty("jaffl.compile.dump", "true");
        System.out.println("cpu=" + (Object)((Object)Platform.getPlatform().getCPU()));
        HashMap hashMap = new HashMap();
        TestLib testLib = AsmLibraryLoader.getInstance().loadLibrary(new Library("test"), TestLib.class, hashMap);
        Integer n = testLib.add_int32_t(1, 2);
        System.err.println("result=" + n);
        System.err.println("adding floats=" + testLib.add_float(1.0f, 2.0f));
        System.err.println("adding doubles=" + testLib.add_double(1.0, 2.0));
        MemoryIO memoryIO = MemoryIO.allocateDirect(1024);
        testLib.ptr_ret_int8_t(memoryIO, 0);
        testLib.ptr_ret_int8_t(MemoryIO.allocate(1024), 0);
    }

    public static abstract class AbstractNativeInterface {
        public static final Invoker ffi = Invoker.getInstance();
        protected final Library library;

        public AbstractNativeInterface(Library library) {
            this.library = library;
        }

        protected static final HeapInvocationBuffer newInvocationBuffer(Function function) {
            return new HeapInvocationBuffer(function);
        }
    }

    public static final class FromNativeProxy
    implements FromNativeConverter {
        private final FromNativeConverter converter;
        private final FromNativeContext ctx;

        public FromNativeProxy(FromNativeConverter fromNativeConverter, FromNativeContext fromNativeContext) {
            this.converter = fromNativeConverter;
            this.ctx = fromNativeContext;
        }

        public Object fromNative(Object object, FromNativeContext fromNativeContext) {
            return this.converter.fromNative(object, this.ctx);
        }

        public Class nativeType() {
            return this.converter.nativeType();
        }
    }

    public static final class IntToLong
    implements FromNativeConverter,
    ToNativeConverter {
        public Object fromNative(Object object, FromNativeContext fromNativeContext) {
            return ((Number)object).longValue();
        }

        public Object toNative(Object object, ToNativeContext toNativeContext) {
            return ((Number)object).intValue();
        }

        public Class nativeType() {
            return Integer.class;
        }
    }

    public static interface TestLib {
        public Integer add_int32_t(Integer var1, int var2);

        public Float add_float(float var1, float var2);

        public Double add_double(Double var1, double var2);

        public byte ptr_ret_int8_t(s8[] var1, int var2);

        public Byte ptr_ret_int8_t(Pointer var1, int var2);

        public byte ptr_ret_int8_t(s8 var1, int var2);

        public void not_found_function();

        public static final class s8
        extends Struct {
            public final Struct.Signed8 s8 = new Struct.Signed8(this);
        }
    }

    public static final class ToNativeProxy
    implements ToNativeConverter {
        private final ToNativeConverter converter;
        private final ToNativeContext ctx;

        public ToNativeProxy(ToNativeConverter toNativeConverter, ToNativeContext toNativeContext) {
            this.converter = toNativeConverter;
            this.ctx = toNativeContext;
        }

        public Object toNative(Object object, ToNativeContext toNativeContext) {
            return this.converter.toNative(object, this.ctx);
        }

        public Class nativeType() {
            return this.converter.nativeType();
        }
    }
}

