/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.Address;
import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.ParameterFlags;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.byref.ByReference;
import com.kenai.jaffl.provider.AbstractArrayMemoryIO;
import com.kenai.jaffl.provider.DelegatingMemoryIO;
import com.kenai.jaffl.provider.InvocationSession;
import com.kenai.jaffl.provider.StringIO;
import com.kenai.jaffl.provider.jffi.DirectMemoryIO;
import com.kenai.jaffl.provider.jffi.MemoryUtil;
import com.kenai.jaffl.struct.Struct;
import com.kenai.jaffl.struct.StructUtil;
import com.kenai.jaffl.util.EnumMapper;
import com.kenai.jffi.ArrayFlags;
import com.kenai.jffi.InvocationBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public final class AsmRuntime {
    public static final com.kenai.jffi.MemoryIO IO = com.kenai.jffi.MemoryIO.getInstance();

    private AsmRuntime() {
    }

    public static final void marshal(InvocationBuffer invocationBuffer, byte[] byArray, int n) {
        if (byArray == null) {
            invocationBuffer.putAddress(0L);
        } else {
            invocationBuffer.putArray(byArray, 0, byArray.length, n);
        }
    }

    public static final void marshal(InvocationBuffer invocationBuffer, short[] sArray, int n) {
        if (sArray == null) {
            invocationBuffer.putAddress(0L);
        } else {
            invocationBuffer.putArray(sArray, 0, sArray.length, n);
        }
    }

    public static final void marshal(InvocationBuffer invocationBuffer, int[] nArray, int n) {
        if (nArray == null) {
            invocationBuffer.putAddress(0L);
        } else {
            invocationBuffer.putArray(nArray, 0, nArray.length, n);
        }
    }

    public static final void marshal(InvocationBuffer invocationBuffer, long[] lArray, int n) {
        if (lArray == null) {
            invocationBuffer.putAddress(0L);
        } else {
            invocationBuffer.putArray(lArray, 0, lArray.length, n);
        }
    }

    public static final void marshal(InvocationBuffer invocationBuffer, float[] fArray, int n) {
        if (fArray == null) {
            invocationBuffer.putAddress(0L);
        } else {
            invocationBuffer.putArray(fArray, 0, fArray.length, n);
        }
    }

    public static final void marshal(InvocationBuffer invocationBuffer, double[] dArray, int n) {
        if (dArray == null) {
            invocationBuffer.putAddress(0L);
        } else {
            invocationBuffer.putArray(dArray, 0, dArray.length, n);
        }
    }

    public static final void marshal(InvocationBuffer invocationBuffer, Pointer pointer, int n) {
        if (pointer == null) {
            invocationBuffer.putAddress(0L);
        } else if (pointer.isDirect()) {
            invocationBuffer.putAddress(pointer.address());
        } else if (pointer instanceof AbstractArrayMemoryIO) {
            AbstractArrayMemoryIO abstractArrayMemoryIO = (AbstractArrayMemoryIO)pointer;
            invocationBuffer.putArray(abstractArrayMemoryIO.array(), abstractArrayMemoryIO.offset(), abstractArrayMemoryIO.length(), n);
        } else {
            throw new IllegalArgumentException("unsupported argument type" + pointer.getClass());
        }
    }

    public static final void marshal(InvocationBuffer invocationBuffer, Address address) {
        if (address == null) {
            invocationBuffer.putAddress(0L);
        } else {
            invocationBuffer.putAddress(address.nativeAddress());
        }
    }

    public static final void marshal(InvocationBuffer invocationBuffer, ByteBuffer byteBuffer, int n) {
        if (byteBuffer == null) {
            invocationBuffer.putAddress(0L);
        } else if (byteBuffer.hasArray()) {
            invocationBuffer.putArray(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining(), n);
        } else {
            invocationBuffer.putDirectBuffer(byteBuffer, byteBuffer.position(), byteBuffer.remaining());
        }
    }

    public static final void marshal(InvocationBuffer invocationBuffer, ShortBuffer shortBuffer, int n) {
        if (shortBuffer == null) {
            invocationBuffer.putAddress(0L);
        } else if (shortBuffer.hasArray()) {
            invocationBuffer.putArray(shortBuffer.array(), shortBuffer.arrayOffset() + shortBuffer.position(), shortBuffer.remaining(), n);
        } else {
            invocationBuffer.putDirectBuffer(shortBuffer, shortBuffer.position() << 1, shortBuffer.remaining() << 1);
        }
    }

    public static final void marshal(InvocationBuffer invocationBuffer, IntBuffer intBuffer, int n) {
        if (intBuffer == null) {
            invocationBuffer.putAddress(0L);
        } else if (intBuffer.hasArray()) {
            invocationBuffer.putArray(intBuffer.array(), intBuffer.arrayOffset() + intBuffer.position(), intBuffer.remaining(), n);
        } else {
            invocationBuffer.putDirectBuffer(intBuffer, intBuffer.position() << 2, intBuffer.remaining() << 2);
        }
    }

    public static final void marshal(InvocationBuffer invocationBuffer, LongBuffer longBuffer, int n) {
        if (longBuffer == null) {
            invocationBuffer.putAddress(0L);
        } else if (longBuffer.hasArray()) {
            invocationBuffer.putArray(longBuffer.array(), longBuffer.arrayOffset() + longBuffer.position(), longBuffer.remaining(), n);
        } else {
            invocationBuffer.putDirectBuffer(longBuffer, longBuffer.position() << 3, longBuffer.remaining() << 3);
        }
    }

    public static final void marshal(InvocationBuffer invocationBuffer, FloatBuffer floatBuffer, int n) {
        if (floatBuffer == null) {
            invocationBuffer.putAddress(0L);
        } else if (floatBuffer.hasArray()) {
            invocationBuffer.putArray(floatBuffer.array(), floatBuffer.arrayOffset() + floatBuffer.position(), floatBuffer.remaining(), n);
        } else {
            invocationBuffer.putDirectBuffer(floatBuffer, floatBuffer.position() << 2, floatBuffer.remaining() << 2);
        }
    }

    public static final void marshal(InvocationBuffer invocationBuffer, DoubleBuffer doubleBuffer, int n) {
        if (doubleBuffer == null) {
            invocationBuffer.putAddress(0L);
        } else if (doubleBuffer.hasArray()) {
            invocationBuffer.putArray(doubleBuffer.array(), doubleBuffer.arrayOffset() + doubleBuffer.position(), doubleBuffer.remaining(), n);
        } else {
            invocationBuffer.putDirectBuffer(doubleBuffer, doubleBuffer.position() << 3, doubleBuffer.remaining() << 3);
        }
    }

    public static final void marshal(InvocationBuffer invocationBuffer, CharSequence charSequence) {
        if (charSequence == null) {
            invocationBuffer.putAddress(0L);
        } else {
            ByteBuffer byteBuffer = StringIO.getStringIO().toNative(charSequence, charSequence.length(), true);
            invocationBuffer.putArray(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.remaining(), 5);
        }
    }

    public static final void marshal(InvocationBuffer invocationBuffer, Struct struct2, int n, int n2) {
        if (struct2 == null) {
            invocationBuffer.putAddress(0L);
        } else {
            Struct struct3 = struct2;
            MemoryIO memoryIO = StructUtil.getMemoryIO(struct3, n);
            if (memoryIO instanceof AbstractArrayMemoryIO) {
                AbstractArrayMemoryIO abstractArrayMemoryIO = (AbstractArrayMemoryIO)memoryIO;
                invocationBuffer.putArray(abstractArrayMemoryIO.array(), abstractArrayMemoryIO.offset(), abstractArrayMemoryIO.length(), n2);
            } else if (memoryIO.isDirect()) {
                invocationBuffer.putAddress(memoryIO.address());
            }
        }
    }

    public static final void marshal(InvocationBuffer invocationBuffer, Struct[] structArray, int n, int n2) {
        if (structArray == null) {
            invocationBuffer.putAddress(0L);
        } else {
            Struct[] structArray2 = structArray;
            MemoryIO memoryIO = StructUtil.getMemoryIO(structArray2[0], n);
            if (!(memoryIO instanceof DelegatingMemoryIO)) {
                throw new RuntimeException("Struct array must be backed by contiguous array");
            }
            if ((memoryIO = ((DelegatingMemoryIO)((Object)memoryIO)).getDelegatedMemoryIO()) instanceof AbstractArrayMemoryIO) {
                AbstractArrayMemoryIO abstractArrayMemoryIO = (AbstractArrayMemoryIO)memoryIO;
                invocationBuffer.putArray(abstractArrayMemoryIO.array(), abstractArrayMemoryIO.offset(), abstractArrayMemoryIO.length(), n2);
            } else if (memoryIO.isDirect()) {
                invocationBuffer.putAddress(memoryIO.address());
            }
        }
    }

    public static final void marshal(InvocationSession invocationSession, InvocationBuffer invocationBuffer, ByReference byReference, int n) {
        if (byReference == null) {
            invocationBuffer.putAddress(0L);
        } else {
            final ByReference byReference2 = byReference;
            final ByteBuffer byteBuffer = ByteBuffer.allocate(byReference2.nativeSize()).order(ByteOrder.nativeOrder());
            byteBuffer.clear();
            if (ArrayFlags.isIn(n)) {
                byReference2.marshal(byteBuffer);
            }
            invocationBuffer.putArray(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining(), n);
            if (ArrayFlags.isOut(n)) {
                invocationSession.addPostInvoke(new InvocationSession.PostInvoke(){

                    public void postInvoke() {
                        byReference2.unmarshal(byteBuffer);
                    }
                });
            }
        }
    }

    public static final void marshal(InvocationSession invocationSession, InvocationBuffer invocationBuffer, StringBuilder stringBuilder, int n, int n2) {
        if (stringBuilder == null) {
            invocationBuffer.putAddress(0L);
        } else {
            final StringBuilder stringBuilder2 = stringBuilder;
            final StringIO stringIO = StringIO.getStringIO();
            final ByteBuffer byteBuffer = stringIO.toNative(stringBuilder2, stringBuilder2.capacity(), ParameterFlags.isIn(n));
            invocationBuffer.putArray(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.remaining(), n2);
            if (ParameterFlags.isOut(n)) {
                invocationSession.addPostInvoke(new InvocationSession.PostInvoke(){

                    public void postInvoke() {
                        stringBuilder2.delete(0, stringBuilder2.length()).append(stringIO.fromNative(byteBuffer, stringBuilder2.capacity()));
                    }
                });
            }
        }
    }

    public static final void marshal(InvocationSession invocationSession, InvocationBuffer invocationBuffer, StringBuffer stringBuffer, int n, int n2) {
        if (stringBuffer == null) {
            invocationBuffer.putAddress(0L);
        } else {
            final StringBuffer stringBuffer2 = stringBuffer;
            final StringIO stringIO = StringIO.getStringIO();
            final ByteBuffer byteBuffer = stringIO.toNative(stringBuffer2, stringBuffer2.capacity(), ParameterFlags.isIn(n));
            invocationBuffer.putArray(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.remaining(), n2);
            if (ParameterFlags.isOut(n)) {
                invocationSession.addPostInvoke(new InvocationSession.PostInvoke(){

                    public void postInvoke() {
                        stringBuffer2.delete(0, stringBuffer2.length()).append(stringIO.fromNative(byteBuffer, stringBuffer2.capacity()));
                    }
                });
            }
        }
    }

    public static final void marshal(InvocationBuffer invocationBuffer, Enum enum_) {
        invocationBuffer.putInt(EnumMapper.getInstance().intValue(enum_));
    }

    public static final void marshal(InvocationSession invocationSession, InvocationBuffer invocationBuffer, Pointer[] pointerArray, int n, int n2) {
        if (pointerArray == null) {
            invocationBuffer.putAddress(0L);
        } else {
            final Pointer[] pointerArray2 = pointerArray;
            if (Pointer.SIZE == 32) {
                final int[] nArray = new int[pointerArray2.length];
                for (int i = 0; i < nArray.length; ++i) {
                    if (!pointerArray2[i].isDirect()) {
                        throw new IllegalArgumentException("invalid pointer in array at index " + i);
                    }
                    nArray[i] = (int)pointerArray2[i].address();
                }
                invocationBuffer.putArray(nArray, 0, nArray.length, n2);
                if (ParameterFlags.isOut(n)) {
                    invocationSession.addPostInvoke(new InvocationSession.PostInvoke(){

                        public void postInvoke() {
                            for (int i = 0; i < nArray.length; ++i) {
                                pointerArray2[i] = MemoryUtil.newPointer(nArray[i]);
                            }
                        }
                    });
                }
            } else {
                final long[] lArray = new long[pointerArray2.length];
                for (int i = 0; i < lArray.length; ++i) {
                    if (!pointerArray2[i].isDirect()) {
                        throw new IllegalArgumentException("invalid pointer in array at index " + i);
                    }
                    lArray[i] = pointerArray2[i].address();
                }
                invocationBuffer.putArray(lArray, 0, lArray.length, n2);
                if (ParameterFlags.isOut(n)) {
                    invocationSession.addPostInvoke(new InvocationSession.PostInvoke(){

                        public void postInvoke() {
                            for (int i = 0; i < lArray.length; ++i) {
                                pointerArray2[i] = MemoryUtil.newPointer(lArray[i]);
                            }
                        }
                    });
                }
            }
        }
    }

    public static final UnsatisfiedLinkError newUnsatisifiedLinkError(String string) {
        return new UnsatisfiedLinkError(string);
    }

    public static final String returnString(long l) {
        if (l == 0L) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(IO.getZeroTerminatedByteArray(l));
        return ((Object)StringIO.getStringIO().fromNative(byteBuffer)).toString();
    }

    public static final Pointer pointerValue(long l) {
        return l != 0L ? new DirectMemoryIO(l) : null;
    }

    public static final Pointer pointerValue(int n) {
        return n != 0 ? new DirectMemoryIO((long)n & 0xFFFFFFFFL) : null;
    }

    public static final MemoryIO newMemoryIO(long l) {
        return l == 0L ? null : new DirectMemoryIO(l);
    }

    public static final void useMemory(long l, Struct struct2) {
        struct2.useMemory(new DirectMemoryIO(l));
    }

    public static final boolean isDirect(Pointer pointer) {
        return pointer == null || pointer.isDirect();
    }

    public static final int intValue(Pointer pointer) {
        return pointer != null ? (int)pointer.address() : 0;
    }

    public static final long longValue(Pointer pointer) {
        return pointer != null ? pointer.address() : 0L;
    }

    public static final boolean isDirect(Struct struct2) {
        return struct2 == null || StructUtil.isDirect(struct2);
    }

    public static final boolean isDirect(Struct struct2, int n) {
        return struct2 == null || StructUtil.getMemoryIO(struct2, n).isDirect();
    }

    public static final int intValue(Struct struct2) {
        return struct2 != null ? (int)StructUtil.getMemoryIO(struct2).address() : 0;
    }

    public static final long longValue(Struct struct2) {
        return struct2 != null ? StructUtil.getMemoryIO(struct2).address() : 0L;
    }
}

