/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import java.util.Arrays;
import java.util.Map;
import org.python.objectweb.asm.AnnotationVisitor;
import org.python.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodegenUtils {
    public static String c(String string) {
        return string.replace('/', '.');
    }

    public static String p(Class clazz) {
        return clazz.getName().replace('.', '/');
    }

    public static String ci(Class clazz) {
        if (clazz.isArray()) {
            if ((clazz = clazz.getComponentType()).isPrimitive()) {
                if (clazz == Byte.TYPE) {
                    return "[B";
                }
                if (clazz == Boolean.TYPE) {
                    return "[Z";
                }
                if (clazz == Short.TYPE) {
                    return "[S";
                }
                if (clazz == Character.TYPE) {
                    return "[C";
                }
                if (clazz == Integer.TYPE) {
                    return "[I";
                }
                if (clazz == Float.TYPE) {
                    return "[F";
                }
                if (clazz == Double.TYPE) {
                    return "[D";
                }
                if (clazz == Long.TYPE) {
                    return "[J";
                }
                throw new RuntimeException("Unrecognized type in compiler: " + clazz.getName());
            }
            return "[" + CodegenUtils.ci(clazz);
        }
        if (clazz.isPrimitive()) {
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unrecognized type in compiler: " + clazz.getName());
        }
        return "L" + CodegenUtils.p(clazz) + ";";
    }

    public static String human(Class clazz) {
        return clazz.getCanonicalName();
    }

    public static String sig(Class clazz, Class ... classArray) {
        return CodegenUtils.sigParams(classArray) + CodegenUtils.ci(clazz);
    }

    public static String sig(Class clazz, String string, Class ... classArray) {
        return CodegenUtils.sigParams(string, classArray) + CodegenUtils.ci(clazz);
    }

    public static String sigParams(Class ... classArray) {
        StringBuilder stringBuilder = new StringBuilder("(");
        for (int i = 0; i < classArray.length; ++i) {
            stringBuilder.append(CodegenUtils.ci(classArray[i]));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String sigParams(String string, Class ... classArray) {
        StringBuilder stringBuilder = new StringBuilder("(");
        stringBuilder.append(string);
        for (int i = 0; i < classArray.length; ++i) {
            stringBuilder.append(CodegenUtils.ci(classArray[i]));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String pretty(Class clazz, Class ... classArray) {
        return CodegenUtils.prettyParams(classArray) + CodegenUtils.human(clazz);
    }

    public static String prettyParams(Class ... classArray) {
        StringBuilder stringBuilder = new StringBuilder("(");
        for (int i = 0; i < classArray.length; ++i) {
            stringBuilder.append(CodegenUtils.human(classArray[i]));
            if (i >= classArray.length - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static Class[] params(Class ... classArray) {
        return classArray;
    }

    public static Class[] params(Class clazz, int n) {
        Object[] objectArray = new Class[n];
        Arrays.fill(objectArray, clazz);
        return objectArray;
    }

    public static Class[] params(Class clazz, Class clazz2, int n) {
        Object[] objectArray = new Class[n + 1];
        Arrays.fill(objectArray, clazz2);
        objectArray[0] = clazz;
        return objectArray;
    }

    public static String getAnnotatedBindingClassName(String string, String string2, boolean bl, int n, int n2, boolean bl2, boolean bl3) {
        String string3;
        String string4 = string3 = bl3 ? "$RUBYFRAMEDINVOKER$" : "$RUBYINVOKER$";
        String string5 = bl2 ? (bl ? "$s" : "$i") + "_method_multi" + string3 + string : (bl ? "$s" : "$i") + "_method_" + n + "_" + n2 + string3 + string;
        return string2 + string5;
    }

    public static void visitAnnotationFields(AnnotationVisitor annotationVisitor, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object = entry.getValue();
            if (object.getClass().isArray()) {
                Object[] objectArray = (Object[])object;
                AnnotationVisitor annotationVisitor2 = annotationVisitor.visitArray(entry.getKey());
                for (int i = 0; i < objectArray.length; ++i) {
                    annotationVisitor2.visit(null, objectArray[i]);
                }
                annotationVisitor2.visitEnd();
                continue;
            }
            if (object.getClass().isEnum()) {
                annotationVisitor.visitEnum(entry.getKey(), CodegenUtils.ci(object.getClass()), object.toString());
                continue;
            }
            if (object instanceof Class) {
                annotationVisitor.visit(entry.getKey(), Type.getType((Class)object));
                continue;
            }
            annotationVisitor.visit(entry.getKey(), object);
        }
    }
}

