/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.Address;
import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.provider.AbstractMemoryIO;
import com.kenai.jaffl.provider.NullMemoryIO;
import com.kenai.jaffl.provider.StringIO;
import com.kenai.jaffl.provider.jffi.BoundedDirectMemoryIO;
import com.kenai.jaffl.provider.jffi.MemoryUtil;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

class DirectMemoryIO
extends AbstractMemoryIO {
    static final com.kenai.jffi.MemoryIO IO = com.kenai.jffi.MemoryIO.getInstance();
    protected final long address;

    DirectMemoryIO(long l) {
        this.address = l & Address.MASK;
    }

    public final long address() {
        return this.address;
    }

    public final byte getByte(long l) {
        return IO.getByte(this.address + l);
    }

    public final short getShort(long l) {
        return IO.getShort(this.address + l);
    }

    public final int getInt(long l) {
        return IO.getInt(this.address + l);
    }

    public final long getLong(long l) {
        return IO.getLong(this.address + l);
    }

    public final float getFloat(long l) {
        return IO.getFloat(this.address + l);
    }

    public final double getDouble(long l) {
        return IO.getDouble(this.address + l);
    }

    public final void putByte(long l, byte by) {
        IO.putByte(this.address + l, by);
    }

    public final void putShort(long l, short s) {
        IO.putShort(this.address + l, s);
    }

    public final void putInt(long l, int n) {
        IO.putInt(this.address + l, n);
    }

    public final void putLong(long l, long l2) {
        IO.putLong(this.address + l, l2);
    }

    public final void putFloat(long l, float f) {
        IO.putFloat(this.address + l, f);
    }

    public final void putDouble(long l, double d) {
        IO.putDouble(this.address + l, d);
    }

    public final void get(long l, byte[] byArray, int n, int n2) {
        IO.getByteArray(this.address + l, byArray, n, n2);
    }

    public final void put(long l, byte[] byArray, int n, int n2) {
        IO.putByteArray(this.address + l, byArray, n, n2);
    }

    public final void get(long l, short[] sArray, int n, int n2) {
        IO.getShortArray(this.address + l, sArray, n, n2);
    }

    public final void put(long l, short[] sArray, int n, int n2) {
        IO.putShortArray(this.address + l, sArray, n, n2);
    }

    public final void get(long l, int[] nArray, int n, int n2) {
        IO.getIntArray(this.address + l, nArray, n, n2);
    }

    public final void put(long l, int[] nArray, int n, int n2) {
        IO.putIntArray(this.address + l, nArray, n, n2);
    }

    public final void get(long l, long[] lArray, int n, int n2) {
        IO.getLongArray(this.address + l, lArray, n, n2);
    }

    public final void put(long l, long[] lArray, int n, int n2) {
        IO.putLongArray(this.address + l, lArray, n, n2);
    }

    public final void get(long l, float[] fArray, int n, int n2) {
        IO.getFloatArray(this.address + l, fArray, n, n2);
    }

    public final void put(long l, float[] fArray, int n, int n2) {
        IO.putFloatArray(this.address + l, fArray, n, n2);
    }

    public final void get(long l, double[] dArray, int n, int n2) {
        IO.getDoubleArray(this.address + l, dArray, n, n2);
    }

    public final void put(long l, double[] dArray, int n, int n2) {
        IO.putDoubleArray(this.address + l, dArray, n, n2);
    }

    public MemoryIO getMemoryIO(long l) {
        return MemoryUtil.newMemoryIO(IO.getAddress(this.address + l));
    }

    public MemoryIO getMemoryIO(long l, long l2) {
        long l3 = IO.getAddress(this.address + l);
        return l3 != 0L ? new BoundedDirectMemoryIO(new DirectMemoryIO(l3), 0L, l2) : new NullMemoryIO();
    }

    public Pointer getPointer(long l) {
        return MemoryUtil.newPointer(IO.getAddress(this.address + l));
    }

    public void putPointer(long l, Pointer pointer) {
        IO.putAddress(this.address + l, pointer.address());
    }

    public String getString(long l) {
        byte[] byArray = IO.getZeroTerminatedByteArray(this.address + l);
        return ((Object)StringIO.getStringIO().fromNative(ByteBuffer.wrap(byArray))).toString();
    }

    public String getString(long l, int n, Charset charset) {
        byte[] byArray = IO.getZeroTerminatedByteArray(this.address + l, n);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        return ((Object)StringIO.getStringIO().fromNative(byteBuffer)).toString();
    }

    public void putString(long l, String string, int n, Charset charset) {
        ByteBuffer byteBuffer = StringIO.getStringIO().toNative(string, 0, true);
        IO.putByteArray(this.address + l, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
    }

    public int indexOf(long l, byte by, int n) {
        return (int)IO.indexOf(this.address + l, by, n);
    }

    public final boolean isDirect() {
        return true;
    }

    public final void setMemory(long l, long l2, byte by) {
        IO.setMemory(this.address + l, l2, by);
    }
}

