/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.provider.jffi.AllocatedDirectMemoryIO;
import com.kenai.jaffl.provider.jffi.ArrayMemoryIO;
import com.kenai.jaffl.provider.jffi.BoundedDirectMemoryIO;
import com.kenai.jaffl.provider.jffi.ByteBufferMemoryIO;
import com.kenai.jaffl.provider.jffi.MemoryUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class MemoryManager
implements com.kenai.jaffl.provider.MemoryManager {
    public MemoryIO allocate(int n) {
        return new ArrayMemoryIO(n);
    }

    public MemoryIO allocateDirect(int n) {
        return new BoundedDirectMemoryIO(new AllocatedDirectMemoryIO(n, false), 0L, (long)n);
    }

    public MemoryIO allocateDirect(int n, boolean bl) {
        return new BoundedDirectMemoryIO(new AllocatedDirectMemoryIO(n, bl), 0L, (long)n);
    }

    public MemoryIO wrap(Pointer pointer) {
        if (pointer instanceof MemoryIO) {
            return (MemoryIO)pointer;
        }
        if (pointer.isDirect()) {
            return MemoryUtil.newMemoryIO(pointer.address());
        }
        throw new UnsupportedOperationException("Unsupported Pointer type: " + pointer.getClass());
    }

    public MemoryIO wrap(Pointer pointer, int n) {
        if (pointer.isDirect()) {
            return MemoryUtil.newMemoryIO(pointer.address(), n);
        }
        throw new UnsupportedOperationException("Unsupported Pointer type: " + pointer.getClass());
    }

    public MemoryIO wrap(ByteBuffer byteBuffer) {
        return new ByteBufferMemoryIO(byteBuffer);
    }

    public Pointer getBufferPointer(Buffer buffer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

