/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.provider.NullMemoryIO;
import com.kenai.jaffl.provider.jffi.BoundedDirectMemoryIO;
import com.kenai.jaffl.provider.jffi.DirectMemoryIO;
import com.kenai.jaffl.provider.jffi.JFFIPointer;

public final class MemoryUtil {
    private MemoryUtil() {
    }

    static final Pointer newPointer(long l) {
        return l != 0L ? new DirectMemoryIO(l) : null;
    }

    static final MemoryIO newMemoryIO(long l) {
        return l != 0L ? new DirectMemoryIO(l) : NullMemoryIO.INSTANCE;
    }

    static final MemoryIO newMemoryIO(long l, long l2) {
        return l != 0L ? new BoundedDirectMemoryIO(new DirectMemoryIO(l), 0L, l2) : NullMemoryIO.INSTANCE;
    }

    static final long getAddress(MemoryIO memoryIO) {
        if (memoryIO == null) {
            return 0L;
        }
        if (memoryIO instanceof JFFIPointer) {
            return ((JFFIPointer)memoryIO).address;
        }
        if (memoryIO instanceof DirectMemoryIO) {
            return ((DirectMemoryIO)memoryIO).address;
        }
        throw new IllegalArgumentException("attempted to get address of non-direct memory. " + memoryIO.getClass());
    }
}

