/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.FFIProvider;
import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.Type;
import com.kenai.jaffl.provider.MemoryManager;
import com.kenai.jaffl.provider.NativeType;
import com.kenai.jaffl.provider.jffi.AsmLibraryLoader;
import com.kenai.jaffl.provider.jffi.Library;
import com.kenai.jaffl.provider.jffi.ProxyLibraryLoader;
import com.kenai.jffi.LastError;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Provider
extends FFIProvider {
    private final MemoryManager memoryManager = new com.kenai.jaffl.provider.jffi.MemoryManager();

    @Override
    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    @Override
    public <T> T loadLibrary(String string, Class<T> clazz, Map<LibraryOption, ?> map) {
        return this.loadLibrary(new Library(string), clazz, map);
    }

    @Override
    public <T> T loadLibrary(Class<T> clazz, Map<LibraryOption, ?> map, String ... stringArray) {
        return this.loadLibrary(new Library(stringArray), clazz, map);
    }

    private <T> T loadLibrary(Library library, Class<T> clazz, Map<LibraryOption, ?> map) {
        try {
            if (AsmLibraryLoader.getInstance().isInterfaceSupported(clazz, map)) {
                return AsmLibraryLoader.getInstance().loadLibrary(library, clazz, map);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return ProxyLibraryLoader.getInstance().loadLibrary(library, clazz, map);
    }

    @Override
    public int getLastError() {
        return LastError.getInstance().get();
    }

    @Override
    public void setLastError(int n) {
        LastError.getInstance().set(n);
    }

    @Override
    public Type getType(NativeType nativeType) {
        switch (nativeType) {
            case VOID: {
                return new TypeDelegate(com.kenai.jffi.Type.VOID);
            }
            case SCHAR: {
                return new TypeDelegate(com.kenai.jffi.Type.SCHAR);
            }
            case UCHAR: {
                return new TypeDelegate(com.kenai.jffi.Type.UCHAR);
            }
            case SSHORT: {
                return new TypeDelegate(com.kenai.jffi.Type.SSHORT);
            }
            case USHORT: {
                return new TypeDelegate(com.kenai.jffi.Type.USHORT);
            }
            case SINT: {
                return new TypeDelegate(com.kenai.jffi.Type.SINT);
            }
            case UINT: {
                return new TypeDelegate(com.kenai.jffi.Type.UINT);
            }
            case SLONG: {
                return new TypeDelegate(com.kenai.jffi.Type.SLONG);
            }
            case ULONG: {
                return new TypeDelegate(com.kenai.jffi.Type.ULONG);
            }
            case SLONGLONG: {
                return new TypeDelegate(com.kenai.jffi.Type.SINT64);
            }
            case ULONGLONG: {
                return new TypeDelegate(com.kenai.jffi.Type.UINT64);
            }
            case FLOAT: {
                return new TypeDelegate(com.kenai.jffi.Type.FLOAT);
            }
            case DOUBLE: {
                return new TypeDelegate(com.kenai.jffi.Type.DOUBLE);
            }
            case ADDRESS: {
                return new TypeDelegate(com.kenai.jffi.Type.POINTER);
            }
        }
        return new BadType(nativeType);
    }

    private static final class BadType
    implements Type {
        private final NativeType type;

        public BadType(NativeType nativeType) {
            this.type = nativeType;
        }

        public int alignment() {
            throw new RuntimeException("invalid type: " + (Object)((Object)this.type));
        }

        public int size() {
            throw new RuntimeException("invalid type: " + (Object)((Object)this.type));
        }
    }

    private static final class TypeDelegate
    implements Type {
        private final com.kenai.jffi.Type type;

        public TypeDelegate(com.kenai.jffi.Type type) {
            this.type = type;
        }

        public int alignment() {
            return this.type.alignment();
        }

        public int size() {
            return this.type.size();
        }
    }
}

