/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.provider.jffi.AbstractX86StubCompiler;
import com.kenai.jaffl.provider.jffi.CodegenUtils;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jnr.x86asm.Asm;
import com.kenai.jnr.x86asm.Assembler;
import com.kenai.jnr.x86asm.Register;

final class X86_64StubCompiler
extends AbstractX86StubCompiler {
    X86_64StubCompiler() {
    }

    final boolean canCompile(Class clazz, Class[] classArray, CallingConvention callingConvention) {
        if (clazz != Byte.TYPE && clazz != Short.TYPE && clazz != Integer.TYPE && clazz != Long.TYPE && clazz != Float.TYPE && clazz != Double.TYPE && clazz != Void.TYPE) {
            return false;
        }
        if (callingConvention != CallingConvention.DEFAULT) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        for (Class clazz2 : classArray) {
            if (clazz2 == Byte.TYPE || clazz2 == Short.TYPE || clazz2 == Integer.TYPE || clazz2 == Long.TYPE) {
                ++n2;
                continue;
            }
            if (clazz2 == Float.TYPE || clazz2 == Double.TYPE) {
                ++n;
                continue;
            }
            return false;
        }
        return n2 <= 6 && n <= 8;
    }

    final void compile(Function function, String string, Class clazz, Class[] assembler, CallingConvention callingConvention, boolean bl) {
        int n = 0;
        int n2 = 0;
        for (Class clazz2 : assembler) {
            if (clazz2 == Byte.TYPE || clazz2 == Short.TYPE || clazz2 == Integer.TYPE || clazz2 == Long.TYPE) {
                ++n2;
                continue;
            }
            if (clazz2 == Float.TYPE || clazz2 == Double.TYPE) {
                ++n;
                continue;
            }
            throw new IllegalArgumentException("invalid parameter type");
        }
        Assembler assembler2 = new Assembler(Asm.X86_64);
        if (n2 > 0) {
            assembler2.mov(Asm.rdi, Asm.rdx);
        }
        if (n2 > 1) {
            assembler2.mov(Asm.rsi, Asm.rcx);
        }
        if (n2 > 2) {
            assembler2.mov(Asm.rdx, Asm.r8);
        }
        if (n2 > 3) {
            assembler2.mov(Asm.rcx, Asm.r9);
        }
        if (n2 > 4) {
            assembler2.mov(Asm.r8, Asm.qword_ptr((Register)Asm.rsp, (long)8L));
        }
        if (n2 > 5) {
            assembler2.mov(Asm.r9, Asm.qword_ptr((Register)Asm.rsp, (long)16L));
        }
        if (n2 > 6) {
            throw new IllegalArgumentException("integer argument count > 6");
        }
        if (n > 8) {
            throw new IllegalArgumentException("float argument count > 8");
        }
        if (bl) {
            int n3 = clazz == Float.TYPE || clazz == Double.TYPE ? 24 : 8;
            assembler2.sub(Asm.rsp, Asm.imm((long)n3));
            assembler2.mov(Asm.rax, Asm.imm((long)function.getFunctionAddress()));
            assembler2.call(Asm.rax);
            if (clazz == Float.TYPE) {
                assembler2.movss(Asm.dword_ptr((Register)Asm.rsp, (long)0L), Asm.xmm0);
            } else if (clazz == Double.TYPE) {
                assembler2.movsd(Asm.qword_ptr((Register)Asm.rsp, (long)0L), Asm.xmm0);
            } else {
                assembler2.mov(Asm.qword_ptr((Register)Asm.rsp, (long)0L), Asm.rax);
            }
            assembler2.mov(Asm.rax, Asm.imm((long)errnoFunctionAddress));
            assembler2.call(Asm.rax);
            if (clazz == Float.TYPE) {
                assembler2.movss(Asm.xmm0, Asm.dword_ptr((Register)Asm.rsp, (long)0L));
            } else if (clazz == Double.TYPE) {
                assembler2.movsd(Asm.xmm0, Asm.qword_ptr((Register)Asm.rsp, (long)0L));
            } else {
                assembler2.mov(Asm.rax, Asm.dword_ptr((Register)Asm.rsp, (long)0L));
            }
            assembler2.add(Asm.rsp, Asm.imm((long)n3));
            assembler2.ret();
        } else {
            assembler2.mov(Asm.rax, Asm.imm((long)function.getFunctionAddress()));
            assembler2.jmp(Asm.rax);
        }
        this.stubs.add(new AbstractX86StubCompiler.Stub(string, CodegenUtils.sig(clazz, (Class[])assembler), assembler2));
    }
}

