/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.struct;

import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.ParameterFlags;
import com.kenai.jaffl.Type;
import com.kenai.jaffl.util.EnumMapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Struct {
    final Info __info = new Info();

    protected Struct() {
    }

    Struct(boolean bl) {
        this.__info.resetIndex = bl;
    }

    public void useMemory(MemoryIO memoryIO) {
        this.__info.useMemory(memoryIO);
    }

    public void useMemory(com.kenai.jaffl.Pointer pointer) {
        this.__info.useMemory(MemoryIO.wrap(pointer));
    }

    public java.lang.String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Field[] fieldArray = this.getClass().getDeclaredFields();
        stringBuilder.append(this.getClass().getSimpleName() + " { \n");
        java.lang.String string = "    ";
        for (Field field : fieldArray) {
            try {
                stringBuilder.append("    ");
                stringBuilder.append(field.getName()).append(" = ");
                stringBuilder.append(field.get(this).toString());
                stringBuilder.append("\n");
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    protected final void arrayBegin() {
        this.__info.resetIndex = false;
    }

    protected final void arrayEnd() {
        this.__info.resetIndex = this.__info.isUnion;
    }

    protected <T extends Member> T[] array(T[] TArray) {
        this.arrayBegin();
        try {
            Class<?> clazz = TArray.getClass().getComponentType();
            Constructor<?> constructor = clazz.getDeclaredConstructor(clazz.getEnclosingClass());
            Object[] objectArray = new Object[]{this};
            for (int i = 0; i < TArray.length; ++i) {
                TArray[i] = (Member)constructor.newInstance(objectArray);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.arrayEnd();
        return TArray;
    }

    protected final Signed8[] array(Signed8[] signed8Array) {
        this.arrayBegin();
        for (int i = 0; i < signed8Array.length; ++i) {
            signed8Array[i] = new Signed8();
        }
        this.arrayEnd();
        return signed8Array;
    }

    protected final Unsigned8[] array(Unsigned8[] unsigned8Array) {
        this.arrayBegin();
        for (int i = 0; i < unsigned8Array.length; ++i) {
            unsigned8Array[i] = new Unsigned8();
        }
        this.arrayEnd();
        return unsigned8Array;
    }

    protected final Signed16[] array(Signed16[] signed16Array) {
        this.arrayBegin();
        for (int i = 0; i < signed16Array.length; ++i) {
            signed16Array[i] = new Signed16();
        }
        this.arrayEnd();
        return signed16Array;
    }

    protected final Unsigned16[] array(Unsigned16[] unsigned16Array) {
        this.arrayBegin();
        for (int i = 0; i < unsigned16Array.length; ++i) {
            unsigned16Array[i] = new Unsigned16();
        }
        this.arrayEnd();
        return unsigned16Array;
    }

    protected final Signed32[] array(Signed32[] signed32Array) {
        this.arrayBegin();
        for (int i = 0; i < signed32Array.length; ++i) {
            signed32Array[i] = new Signed32();
        }
        this.arrayEnd();
        return signed32Array;
    }

    protected final Unsigned32[] array(Unsigned32[] unsigned32Array) {
        this.arrayBegin();
        for (int i = 0; i < unsigned32Array.length; ++i) {
            unsigned32Array[i] = new Unsigned32();
        }
        this.arrayEnd();
        return unsigned32Array;
    }

    protected final Signed64[] array(Signed64[] signed64Array) {
        this.arrayBegin();
        for (int i = 0; i < signed64Array.length; ++i) {
            signed64Array[i] = new Signed64();
        }
        this.arrayEnd();
        return signed64Array;
    }

    protected final Unsigned64[] array(Unsigned64[] unsigned64Array) {
        this.arrayBegin();
        for (int i = 0; i < unsigned64Array.length; ++i) {
            unsigned64Array[i] = new Unsigned64();
        }
        this.arrayEnd();
        return unsigned64Array;
    }

    protected final SignedLong[] array(SignedLong[] signedLongArray) {
        this.arrayBegin();
        for (int i = 0; i < signedLongArray.length; ++i) {
            signedLongArray[i] = new SignedLong();
        }
        this.arrayEnd();
        return signedLongArray;
    }

    protected final UnsignedLong[] array(UnsignedLong[] unsignedLongArray) {
        this.arrayBegin();
        for (int i = 0; i < unsignedLongArray.length; ++i) {
            unsignedLongArray[i] = new UnsignedLong();
        }
        this.arrayEnd();
        return unsignedLongArray;
    }

    protected final Float[] array(Float[] floatArray) {
        this.arrayBegin();
        for (int i = 0; i < floatArray.length; ++i) {
            floatArray[i] = new Float();
        }
        this.arrayEnd();
        return floatArray;
    }

    protected final Double[] array(Double[] doubleArray) {
        this.arrayBegin();
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = new Double();
        }
        this.arrayEnd();
        return doubleArray;
    }

    protected final Address[] array(Address[] addressArray) {
        this.arrayBegin();
        for (int i = 0; i < addressArray.length; ++i) {
            addressArray[i] = new Address();
        }
        this.arrayEnd();
        return addressArray;
    }

    protected final Pointer[] array(Pointer[] pointerArray) {
        this.arrayBegin();
        for (int i = 0; i < pointerArray.length; ++i) {
            pointerArray[i] = new Pointer();
        }
        this.arrayEnd();
        return pointerArray;
    }

    protected final <T extends Struct> T inner(Struct struct2) {
        int n = struct2.__info.getMinimumAlignment();
        int n2 = n + (this.__info.size - 1 & ~(n - 1));
        struct2.__info.enclosing = this;
        struct2.__info.offset = n2;
        this.__info.size = n2 + struct2.__info.size;
        return (T)struct2;
    }

    protected abstract class AbstractMember
    implements Member {
        private final int offset;

        protected AbstractMember(int n) {
            this(n, n);
        }

        protected AbstractMember(int n, int n2, Offset offset) {
            this.offset = Struct.this.__info.addField(n, n2, offset);
        }

        protected AbstractMember(int n, int n2) {
            this.offset = Struct.this.__info.addField(n, n2);
        }

        public final MemoryIO getMemoryIO() {
            return Struct.this.__info.getMemoryIO();
        }

        public final Struct struct() {
            return Struct.this;
        }

        public final long offset() {
            return this.offset + Struct.this.__info.offset;
        }
    }

    public class Address
    extends NumberField {
        public Address() {
            super(Constants.ADDRESS_SIZE);
        }

        public Address(Offset offset) {
            super(Constants.ADDRESS_SIZE, offset);
        }

        public final com.kenai.jaffl.Address get() {
            long l = this.getMemoryIO().getAddress(this.offset());
            return l != 0L ? new com.kenai.jaffl.Address(l) : null;
        }

        public final void set(com.kenai.jaffl.Address address) {
            this.getMemoryIO().putAddress(this.offset(), address != null ? address.nativeAddress() : 0L);
        }

        public void set(Number number) {
            this.getMemoryIO().putAddress(this.offset(), number.longValue());
        }

        public final int intValue() {
            return this.get().intValue();
        }

        public final long longValue() {
            return this.get().longValue();
        }

        public final java.lang.String toString() {
            return this.get().toString();
        }
    }

    public class AsciiString
    extends UTFString {
        public AsciiString(int n) {
            super(n, Charset.forName("ASCII"));
        }
    }

    public class AsciiStringRef
    extends UTFStringRef {
        public AsciiStringRef(int n) {
            super(n, Charset.forName("ASCII"));
        }

        public AsciiStringRef() {
            super(Integer.MAX_VALUE, Charset.forName("ASCII"));
        }
    }

    protected static final class Constants {
        static final int LONG_SIZE = Type.SLONG.size() * 8;
        static final int ADDRESS_SIZE = Type.ADDRESS.size() * 8;
        static final long LONG_MASK = LONG_SIZE == 32 ? Integer.MAX_VALUE : Long.MAX_VALUE;
        static final int LONG_ALIGN = Type.SLONG.alignment() * 8;
        static final int INT64_ALIGN = Type.SLONGLONG.alignment() * 8;
        static final int DOUBLE_ALIGN = Type.DOUBLE.alignment() * 8;
        static final int FLOAT_ALIGN = Type.FLOAT.alignment() * 8;

        protected Constants() {
        }
    }

    public final class Double
    extends NumberField {
        public Double() {
            super(64, Constants.DOUBLE_ALIGN);
        }

        public Double(Offset offset) {
            super(64, Constants.DOUBLE_ALIGN, offset);
        }

        public final double get() {
            return this.getMemoryIO().getDouble(this.offset());
        }

        public final void set(double d) {
            this.getMemoryIO().putDouble(this.offset(), d);
        }

        public void set(Number number) {
            this.getMemoryIO().putDouble(this.offset(), number.doubleValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return (long)this.get();
        }

        public final float floatValue() {
            return (float)this.get();
        }

        public final double doubleValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return java.lang.String.valueOf(this.get());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum<T extends java.lang.Enum<T>>
    extends Enum32<T> {
        public Enum(Class<T> clazz) {
            super(clazz);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum16<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        public Enum16(Class<E> clazz) {
            super(16, clazz);
        }

        @Override
        public final E get() {
            return EnumMapper.getInstance().valueOf(this.intValue(), this.enumClass);
        }

        public final void set(E e) {
            this.getMemoryIO().putShort(this.offset(), (short)EnumMapper.getInstance().intValue((java.lang.Enum)e));
        }

        @Override
        public void set(Number number) {
            this.getMemoryIO().putShort(this.offset(), number.shortValue());
        }

        @Override
        public final int intValue() {
            return this.getMemoryIO().getShort(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum32<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        public Enum32(Class<E> clazz) {
            super(32, clazz);
        }

        @Override
        public final E get() {
            return EnumMapper.getInstance().valueOf(this.intValue(), this.enumClass);
        }

        public final void set(E e) {
            this.getMemoryIO().putInt(this.offset(), EnumMapper.getInstance().intValue((java.lang.Enum)e));
        }

        @Override
        public void set(Number number) {
            this.getMemoryIO().putInt(this.offset(), number.intValue());
        }

        @Override
        public final int intValue() {
            return this.getMemoryIO().getInt(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum64<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        public Enum64(Class<E> clazz) {
            super(64, Constants.INT64_ALIGN, clazz);
        }

        @Override
        public final E get() {
            return EnumMapper.getInstance().valueOf(this.intValue(), this.enumClass);
        }

        public final void set(E e) {
            this.getMemoryIO().putLong(this.offset(), EnumMapper.getInstance().intValue((java.lang.Enum)e));
        }

        @Override
        public void set(Number number) {
            this.getMemoryIO().putLong(this.offset(), number.longValue());
        }

        @Override
        public final int intValue() {
            return (int)this.longValue();
        }

        @Override
        public final long longValue() {
            return this.getMemoryIO().getLong(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum8<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        public Enum8(Class<E> clazz) {
            super(8, clazz);
        }

        @Override
        public final E get() {
            return EnumMapper.getInstance().valueOf(this.intValue(), this.enumClass);
        }

        public final void set(E e) {
            this.getMemoryIO().putByte(this.offset(), (byte)EnumMapper.getInstance().intValue((java.lang.Enum)e));
        }

        @Override
        public void set(Number number) {
            this.getMemoryIO().putByte(this.offset(), number.byteValue());
        }

        @Override
        public final int intValue() {
            return this.getMemoryIO().getByte(this.offset());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class EnumField<E>
    extends NumberField {
        protected final Class<E> enumClass;

        public EnumField(int n, Class<E> clazz) {
            this(n, n, clazz);
        }

        public EnumField(int n, Offset offset, Class<E> clazz) {
            this(n, n, offset, clazz);
        }

        public EnumField(int n, int n2, Class<E> clazz) {
            super(n, n2);
            this.enumClass = clazz;
        }

        public EnumField(int n, int n2, Offset offset, Class<E> clazz) {
            super(n, n2, offset);
            this.enumClass = clazz;
        }

        public abstract E get();

        @Override
        public final java.lang.String toString() {
            return this.get().toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EnumLong<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        public EnumLong(Class<E> clazz) {
            super(Constants.LONG_SIZE, Constants.LONG_ALIGN, clazz);
        }

        @Override
        public final E get() {
            return EnumMapper.getInstance().valueOf(this.intValue(), this.enumClass);
        }

        public final void set(E e) {
            this.getMemoryIO().putNativeLong(this.offset(), EnumMapper.getInstance().intValue((java.lang.Enum)e));
        }

        @Override
        public void set(Number number) {
            this.getMemoryIO().putNativeLong(this.offset(), number.longValue());
        }

        @Override
        public final int intValue() {
            return (int)this.longValue();
        }

        @Override
        public final long longValue() {
            return this.getMemoryIO().getNativeLong(this.offset());
        }
    }

    public class Float
    extends NumberField {
        public Float() {
            super(32, Constants.FLOAT_ALIGN);
        }

        public Float(Offset offset) {
            super(32, Constants.FLOAT_ALIGN, offset);
        }

        public final float get() {
            return this.getMemoryIO().getFloat(this.offset());
        }

        public final void set(float f) {
            this.getMemoryIO().putFloat(this.offset(), f);
        }

        public void set(Number number) {
            this.getMemoryIO().putFloat(this.offset(), number.floatValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final double doubleValue() {
            return this.get();
        }

        public final float floatValue() {
            return this.get();
        }

        public final long longValue() {
            return (long)this.get();
        }

        public final java.lang.String toString() {
            return java.lang.String.valueOf(this.get());
        }
    }

    static final class Info {
        Struct enclosing = null;
        int offset = 0;
        MemoryIO io;
        int size = 0;
        int minAlign = 1;
        boolean isUnion = false;
        boolean resetIndex = false;

        Info() {
        }

        public final MemoryIO getMemoryIO(int n) {
            return this.enclosing != null ? this.enclosing.__info.getMemoryIO(n) : (this.io != null ? this.io : (this.io = this.allocateMemory(n)));
        }

        public final MemoryIO getMemoryIO() {
            return this.getMemoryIO(16);
        }

        final boolean isDirect() {
            return this.enclosing != null && this.enclosing.__info.isDirect() || this.io != null && this.io.isDirect();
        }

        final int size() {
            return this.size;
        }

        final int getMinimumAlignment() {
            return this.minAlign;
        }

        private final MemoryIO allocateMemory(int n) {
            if (ParameterFlags.isDirect(n)) {
                return MemoryIO.allocateDirect(this.size(), true);
            }
            return MemoryIO.allocate(this.size());
        }

        public final void useMemory(MemoryIO memoryIO) {
            this.io = memoryIO;
        }

        protected final int addField(int n, int n2, Offset offset) {
            this.size = Math.max(this.size, offset.intValue() + (n >> 3));
            this.minAlign = Math.max(this.minAlign, n2 >> 3);
            return offset.intValue();
        }

        protected final int addField(int n, int n2) {
            int n3;
            int n4 = (n2 >> 3) - 1;
            int n5 = n3 = this.resetIndex ? 0 : this.size;
            if ((n3 & n4) != 0) {
                n3 = (n3 & ~n4) + (n2 >> 3);
            }
            this.size = Math.max(this.size, n3 + (n >> 3));
            this.minAlign = Math.max(this.minAlign, n2 >> 3);
            return n3;
        }
    }

    protected static interface Member {
        public Struct struct();

        public MemoryIO getMemoryIO();

        public long offset();
    }

    protected abstract class NumberField
    extends Number
    implements Member {
        private final int offset;

        protected NumberField(int n) {
            this(n, n);
        }

        protected NumberField(int n, Offset offset) {
            this(n, n, offset);
        }

        protected NumberField(int n, int n2, Offset offset) {
            this.offset = Struct.this.__info.addField(n, n2, offset);
        }

        protected NumberField(int n, int n2) {
            this.offset = Struct.this.__info.addField(n, n2);
        }

        public final MemoryIO getMemoryIO() {
            return Struct.this.__info.getMemoryIO();
        }

        public final Struct struct() {
            return Struct.this;
        }

        public final long offset() {
            return this.offset + Struct.this.__info.offset;
        }

        public abstract void set(Number var1);

        public double doubleValue() {
            return this.longValue();
        }

        public float floatValue() {
            return this.intValue();
        }

        public long longValue() {
            return this.intValue();
        }

        public java.lang.String toString() {
            return Integer.toString(this.intValue(), 10);
        }
    }

    public static final class Offset
    extends Number {
        private final int offset;

        public Offset(int n) {
            this.offset = n;
        }

        public int intValue() {
            return this.offset;
        }

        public long longValue() {
            return this.offset;
        }

        public float floatValue() {
            return this.offset;
        }

        public double doubleValue() {
            return this.offset;
        }
    }

    public final class Padding
    extends AbstractMember {
        Padding(Type type, int n) {
            super(type.size() * 8 * n, type.alignment() * 8);
        }
    }

    public class Pointer
    extends NumberField {
        public Pointer() {
            super(Constants.ADDRESS_SIZE);
        }

        public Pointer(Offset offset) {
            super(Constants.ADDRESS_SIZE, offset);
        }

        public final com.kenai.jaffl.Pointer get() {
            return this.getMemoryIO().getPointer(this.offset());
        }

        public final int size() {
            return com.kenai.jaffl.Address.SIZE;
        }

        public final void set(com.kenai.jaffl.Pointer pointer) {
            this.getMemoryIO().putPointer(this.offset(), pointer);
        }

        public void set(Number number) {
            this.getMemoryIO().putAddress(this.offset(), number.longValue());
        }

        public final int intValue() {
            return (int)this.getMemoryIO().getAddress(this.offset());
        }

        public final long longValue() {
            return this.getMemoryIO().getAddress(this.offset());
        }

        public final java.lang.String toString() {
            return this.get().toString();
        }
    }

    public class Signed16
    extends NumberField {
        public Signed16() {
            super(16);
        }

        public Signed16(Offset offset) {
            super(16, offset);
        }

        public final short get() {
            return this.getMemoryIO().getShort(this.offset());
        }

        public final void set(short s) {
            this.getMemoryIO().putShort(this.offset(), s);
        }

        public void set(Number number) {
            this.getMemoryIO().putShort(this.offset(), number.shortValue());
        }

        public final short shortValue() {
            return this.get();
        }

        public final int intValue() {
            return this.get();
        }
    }

    public class Signed32
    extends NumberField {
        public Signed32() {
            super(32);
        }

        public Signed32(Offset offset) {
            super(32, offset);
        }

        public final int get() {
            return this.getMemoryIO().getInt(this.offset());
        }

        public final void set(int n) {
            this.getMemoryIO().putInt(this.offset(), n);
        }

        public void set(Number number) {
            this.getMemoryIO().putInt(this.offset(), number.intValue());
        }

        public final int intValue() {
            return this.get();
        }
    }

    public class Signed64
    extends NumberField {
        public Signed64() {
            super(64, Constants.INT64_ALIGN);
        }

        public Signed64(Offset offset) {
            super(64, Constants.INT64_ALIGN, offset);
        }

        public final long get() {
            return this.getMemoryIO().getLong(this.offset());
        }

        public final void set(long l) {
            this.getMemoryIO().putLong(this.offset(), l);
        }

        public void set(Number number) {
            this.getMemoryIO().putLong(this.offset(), number.longValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return Long.toString(this.get());
        }
    }

    public class Signed8
    extends NumberField {
        public Signed8() {
            super(8);
        }

        public Signed8(Offset offset) {
            super(8, offset);
        }

        public final byte get() {
            return this.getMemoryIO().getByte(this.offset());
        }

        public final void set(byte by) {
            this.getMemoryIO().putByte(this.offset(), by);
        }

        public void set(Number number) {
            this.getMemoryIO().putByte(this.offset(), number.byteValue());
        }

        public final byte byteValue() {
            return this.get();
        }

        public final short shortValue() {
            return this.get();
        }

        public final int intValue() {
            return this.get();
        }
    }

    public class SignedLong
    extends NumberField {
        public SignedLong() {
            super(Constants.LONG_SIZE, Constants.LONG_ALIGN);
        }

        public SignedLong(Offset offset) {
            super(Constants.LONG_SIZE, Constants.LONG_ALIGN, offset);
        }

        public final long get() {
            return this.getMemoryIO().getNativeLong(this.offset());
        }

        public final void set(long l) {
            this.getMemoryIO().putNativeLong(this.offset(), l);
        }

        public void set(Number number) {
            this.getMemoryIO().putNativeLong(this.offset(), number.longValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return Long.toString(this.get());
        }
    }

    public abstract class String
    extends AbstractMember {
        private final Charset charset;
        private final int length;

        protected String(int n, int n2, int n3, Charset charset) {
            super(n, n2);
            this.length = n3;
            this.charset = charset;
        }

        protected String(int n, int n2, Offset offset, int n3, Charset charset) {
            super(n, n2, offset);
            this.length = n3;
            this.charset = charset;
        }

        public final int length() {
            return this.length;
        }

        protected abstract MemoryIO getStringMemory();

        public final java.lang.String get() {
            return this.getStringMemory().getString(0L, this.length, this.charset);
        }

        public final void set(java.lang.String string) {
            this.getStringMemory().putString(0L, string, this.length, this.charset);
        }

        public final java.lang.String toString() {
            return this.get();
        }
    }

    public class UTF8String
    extends UTFString {
        public UTF8String(int n) {
            super(n, Charset.forName("UTF-8"));
        }
    }

    public class UTF8StringRef
    extends UTFStringRef {
        public UTF8StringRef(int n) {
            super(n, Charset.forName("UTF-8"));
        }

        public UTF8StringRef() {
            super(Integer.MAX_VALUE, Charset.forName("UTF-8"));
        }
    }

    public class UTFString
    extends String {
        public UTFString(int n, Charset charset) {
            super(n * 8, 8, n, charset);
        }

        protected MemoryIO getStringMemory() {
            return this.getMemoryIO().slice(this.offset(), this.length());
        }
    }

    public class UTFStringRef
    extends String {
        public UTFStringRef(int n, Charset charset) {
            super(Constants.ADDRESS_SIZE, Constants.ADDRESS_SIZE, n, charset);
        }

        public UTFStringRef(Charset charset) {
            this(Integer.MAX_VALUE, charset);
        }

        protected MemoryIO getStringMemory() {
            return this.getMemoryIO().getMemoryIO(this.offset(), this.length());
        }
    }

    public class Unsigned16
    extends NumberField {
        public Unsigned16() {
            super(16);
        }

        public Unsigned16(Offset offset) {
            super(16, offset);
        }

        public final int get() {
            int n = this.getMemoryIO().getShort(this.offset());
            return n < 0 ? (n & Short.MAX_VALUE) + 32768 : n;
        }

        public final void set(int n) {
            this.getMemoryIO().putShort(this.offset(), (short)n);
        }

        public void set(Number number) {
            this.getMemoryIO().putShort(this.offset(), number.shortValue());
        }

        public final int intValue() {
            return this.get();
        }
    }

    public class Unsigned32
    extends NumberField {
        public Unsigned32() {
            super(32);
        }

        public Unsigned32(Offset offset) {
            super(32, offset);
        }

        public final long get() {
            long l = this.getMemoryIO().getInt(this.offset());
            return l < 0L ? (l & Integer.MAX_VALUE) + 0x80000000L : l;
        }

        public final void set(long l) {
            this.getMemoryIO().putInt(this.offset(), (int)l);
        }

        public void set(Number number) {
            this.getMemoryIO().putInt(this.offset(), number.intValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }
    }

    public class Unsigned64
    extends NumberField {
        public Unsigned64() {
            super(64, Constants.INT64_ALIGN);
        }

        public Unsigned64(Offset offset) {
            super(64, Constants.INT64_ALIGN, offset);
        }

        public final long get() {
            return this.getMemoryIO().getLong(this.offset());
        }

        public final void set(long l) {
            this.getMemoryIO().putLong(this.offset(), l);
        }

        public void set(Number number) {
            this.getMemoryIO().putLong(this.offset(), number.longValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return Long.toString(this.get());
        }
    }

    public class Unsigned8
    extends NumberField {
        public Unsigned8() {
            super(8);
        }

        public Unsigned8(Offset offset) {
            super(8, offset);
        }

        public final short get() {
            short s = this.getMemoryIO().getByte(this.offset());
            return s < 0 ? (short)((s & 0x7F) + 128) : s;
        }

        public final void set(short s) {
            this.getMemoryIO().putByte(this.offset(), (byte)s);
        }

        public void set(Number number) {
            this.getMemoryIO().putByte(this.offset(), number.byteValue());
        }

        public final short shortValue() {
            return this.get();
        }

        public final int intValue() {
            return this.get();
        }
    }

    public class UnsignedLong
    extends NumberField {
        public UnsignedLong() {
            super(Constants.LONG_SIZE, Constants.LONG_ALIGN);
        }

        public UnsignedLong(Offset offset) {
            super(Constants.LONG_SIZE, Constants.LONG_ALIGN, offset);
        }

        public final long get() {
            long l = this.getMemoryIO().getNativeLong(this.offset());
            return l < 0L ? (l & Constants.LONG_MASK) + Constants.LONG_MASK + 1L : l;
        }

        public final void set(long l) {
            this.getMemoryIO().putNativeLong(this.offset(), l);
        }

        public void set(Number number) {
            this.getMemoryIO().putNativeLong(this.offset(), number.longValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return Long.toString(this.get());
        }
    }
}

