/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.util;

import com.kenai.jaffl.util.BufferPool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBufferPool
implements BufferPool {
    private final int bufferSize;
    private final int poolSize;
    private final BufferPool parent;
    private final ArrayList<ByteBuffer> list;

    public SimpleBufferPool(int n, int n2) {
        this(new DefaultPool(), n, n2);
    }

    public SimpleBufferPool(BufferPool bufferPool, int n, int n2) {
        this.parent = bufferPool;
        this.bufferSize = n;
        this.poolSize = n2;
        this.list = new ArrayList(n2);
    }

    @Override
    public ByteBuffer get(int n) {
        if (n <= this.bufferSize && !this.list.isEmpty()) {
            ByteBuffer byteBuffer = this.list.remove(this.list.size() - 1);
            byteBuffer.rewind().limit(n);
            return byteBuffer;
        }
        ByteBuffer byteBuffer = this.parent.get(Math.max(n, this.bufferSize));
        byteBuffer.rewind().limit(n);
        return byteBuffer;
    }

    @Override
    public void put(ByteBuffer byteBuffer) {
        if (this.list.size() < this.poolSize && byteBuffer.capacity() == this.bufferSize) {
            this.list.add(byteBuffer);
        } else {
            this.parent.put(byteBuffer);
        }
    }

    @Override
    public void putAll(List<ByteBuffer> list) {
        for (ByteBuffer byteBuffer : list) {
            this.put(byteBuffer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultPool
    implements BufferPool {
        DefaultPool() {
        }

        @Override
        public ByteBuffer get(int n) {
            return ByteBuffer.allocateDirect(n).order(ByteOrder.nativeOrder());
        }

        @Override
        public void put(ByteBuffer byteBuffer) {
        }

        @Override
        public void putAll(List<ByteBuffer> list) {
        }
    }
}

