/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Type;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CallContextCache {
    private final Map<Signature, CallContextRef> contextCache = new ConcurrentHashMap<Signature, CallContextRef>();
    private final ReferenceQueue<CallContext> contextReferenceQueue = new ReferenceQueue();

    public static final CallContextCache getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private CallContextCache() {
    }

    public final CallContext getCallContext(Type type, Type[] typeArray, CallingConvention callingConvention) {
        CallContext callContext;
        Signature signature = new Signature(type, typeArray, callingConvention);
        CallContextRef callContextRef = this.contextCache.get(signature);
        if (callContextRef != null && (callContext = (CallContext)callContextRef.get()) != null) {
            return callContext;
        }
        while ((callContextRef = (CallContextRef)this.contextReferenceQueue.poll()) != null) {
            this.contextCache.remove(callContextRef.signature);
        }
        callContext = new CallContext(type, (Type[])typeArray.clone(), callingConvention);
        this.contextCache.put(signature, new CallContextRef(signature, callContext, this.contextReferenceQueue));
        return callContext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CallContextRef
    extends SoftReference<CallContext> {
        final Signature signature;

        public CallContextRef(Signature signature, CallContext callContext, ReferenceQueue<CallContext> referenceQueue) {
            super(callContext, referenceQueue);
            this.signature = signature;
        }
    }

    private static final class Signature {
        private final Type returnType;
        private final Type[] parameterTypes;
        private final CallingConvention convention;
        private int hashCode = 0;

        public Signature(Type type, Type[] typeArray, CallingConvention callingConvention) {
            if (type == null || typeArray == null) {
                throw new NullPointerException("null return type or parameter types array");
            }
            this.returnType = type;
            this.parameterTypes = typeArray;
            this.convention = callingConvention;
        }

        public boolean equals(Object object) {
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Signature signature = (Signature)object;
            if (this.convention != signature.convention) {
                return false;
            }
            if (this.returnType != signature.returnType && !this.returnType.equals(signature.returnType)) {
                return false;
            }
            if (this.parameterTypes.length == signature.parameterTypes.length) {
                for (int i = 0; i < this.parameterTypes.length; ++i) {
                    if (this.parameterTypes[i] == signature.parameterTypes[i] || this.parameterTypes[i] != null && this.parameterTypes[i].equals(signature.parameterTypes[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private final int calculateHashCode() {
            int n = 7;
            n = 53 * n + (this.returnType != null ? this.returnType.hashCode() : 0);
            int n2 = 1;
            for (int i = 0; i < this.parameterTypes.length; ++i) {
                n2 = 31 * n2 + this.parameterTypes[i].hashCode();
            }
            n = 53 * n + n2;
            n = 53 * n + this.convention.hashCode();
            return n;
        }

        public int hashCode() {
            return this.hashCode != 0 ? this.hashCode : (this.hashCode = this.calculateHashCode());
        }
    }

    private static final class SingletonHolder {
        static final CallContextCache INSTANCE = new CallContextCache();

        private SingletonHolder() {
        }
    }
}

