/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.Closure;
import com.kenai.jffi.DirectClosureBuffer;
import com.kenai.jffi.Foreign;
import com.kenai.jffi.MemoryIO;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

final class ClosurePool {
    private final List<MagazineHolder> partial = new LinkedList<MagazineHolder>();
    private final List<MagazineHolder> full = new LinkedList<MagazineHolder>();
    private final Set<Magazine> magazines = new HashSet<Magazine>();
    private final CallContext callContext;
    private static final Closure NULL_CLOSURE = new Closure(){

        public void invoke(Closure.Buffer buffer) {
        }
    };

    ClosurePool(CallContext callContext) {
        this.callContext = callContext;
    }

    synchronized void recycle(Magazine magazine) {
        magazine.recycle();
        if (!magazine.isEmpty()) {
            MagazineHolder magazineHolder = new MagazineHolder(this, magazine);
            if (magazine.isFull()) {
                this.full.add(magazineHolder);
            } else {
                this.partial.add(magazineHolder);
            }
        } else {
            this.magazines.remove(magazine);
        }
    }

    private synchronized MagazineHolder getMagazineHolder() {
        if (!this.partial.isEmpty()) {
            return this.partial.get(0);
        }
        if (!this.full.isEmpty()) {
            MagazineHolder magazineHolder = this.full.remove(0);
            this.partial.add(magazineHolder);
            return magazineHolder;
        }
        Magazine magazine = new Magazine(this.callContext);
        MagazineHolder magazineHolder = new MagazineHolder(this, magazine);
        this.partial.add(magazineHolder);
        this.magazines.add(magazine);
        return magazineHolder;
    }

    public synchronized Closure.Handle newClosureHandle(Closure closure) {
        Magazine.Slot slot = null;
        MagazineHolder magazineHolder = null;
        do {
            if ((slot = (magazineHolder = this.getMagazineHolder()).magazine.get()) != null) continue;
            this.partial.remove(0);
        } while (slot == null);
        slot.proxy.closure = closure;
        return new Handle(slot, magazineHolder);
    }

    private static final class Handle
    implements Closure.Handle {
        private final MagazineHolder holder;
        private final Magazine.Slot slot;
        private volatile boolean disposed = false;

        Handle(Magazine.Slot slot, MagazineHolder magazineHolder) {
            this.slot = slot;
            this.holder = magazineHolder;
        }

        public long getAddress() {
            return this.slot.cbAddress;
        }

        public void setAutoRelease(boolean bl) {
            this.slot.autorelease = bl;
        }

        @Deprecated
        public void free() {
            this.dispose();
        }

        public synchronized void dispose() {
            if (this.disposed) {
                throw new IllegalStateException("closure already disposed");
            }
            this.disposed = true;
            this.slot.autorelease = true;
        }
    }

    private static final class Magazine {
        private static final MemoryIO IO = MemoryIO.getInstance();
        private final CallContext ctx;
        private final long magazine;
        private boolean nativeEmpty = false;
        private final List<Slot> free = new ArrayList<Slot>();
        private final List<Slot> all = new ArrayList<Slot>();

        Magazine(CallContext callContext) {
            this.ctx = callContext;
            this.magazine = Foreign.getInstance().newClosureMagazine(callContext.getAddress(), Proxy.METHOD);
        }

        Slot get() {
            if (!this.free.isEmpty()) {
                return this.free.remove(this.free.size() - 1);
            }
            return !this.nativeEmpty ? this.newSlot() : null;
        }

        private Slot newSlot() {
            Proxy proxy = new Proxy(this.ctx);
            long l = Foreign.getInstance().closureMagazineGet(this.magazine, proxy);
            if (l == 0L) {
                this.nativeEmpty = true;
                return null;
            }
            Slot slot = new Slot(l, proxy);
            this.all.add(slot);
            return slot;
        }

        boolean isFull() {
            return this.free.size() == this.all.size();
        }

        boolean isEmpty() {
            return this.free.isEmpty();
        }

        void recycle() {
            this.free.clear();
            for (Slot slot : this.all) {
                if (!slot.autorelease) continue;
                slot.proxy.closure = NULL_CLOSURE;
                this.free.add(slot);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                boolean bl = true;
                for (Slot slot : this.all) {
                    if (slot.autorelease) continue;
                    bl = false;
                    break;
                }
                if (this.magazine != 0L && bl) {
                    Foreign.getInstance().freeClosureMagazine(this.magazine);
                }
            }
            finally {
                super.finalize();
            }
        }

        static final class Slot {
            final long handle;
            final long cbAddress;
            final Proxy proxy;
            volatile boolean autorelease;

            public Slot(long l, Proxy proxy) {
                this.handle = l;
                this.proxy = proxy;
                this.autorelease = true;
                this.cbAddress = IO.getAddress(l);
            }
        }
    }

    private static final class MagazineHolder {
        private final WeakReference<ClosurePool> poolref;
        private final Magazine magazine;

        public MagazineHolder(ClosurePool closurePool, Magazine magazine) {
            this.poolref = new WeakReference<ClosurePool>(closurePool);
            this.magazine = magazine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                ClosurePool closurePool = (ClosurePool)this.poolref.get();
                if (closurePool != null) {
                    closurePool.recycle(this.magazine);
                }
            }
            finally {
                super.finalize();
            }
        }
    }

    static final class Proxy {
        static final Method METHOD = Proxy.getMethod();
        final CallContext callContext;
        volatile Closure closure = ClosurePool.access$100();

        private static final Method getMethod() {
            try {
                return Proxy.class.getDeclaredMethod("invoke", Long.TYPE, Long.TYPE);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        Proxy(CallContext callContext) {
            this.callContext = callContext;
        }

        void invoke(long l, long l2) {
            this.closure.invoke(new DirectClosureBuffer(this.callContext, l, l2));
        }
    }
}

