/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.Closure;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.Platform;

final class DirectClosureBuffer
implements Closure.Buffer {
    private static final MemoryIO IO = MemoryIO.getInstance();
    private static final long ADDRESS_MASK = Platform.getPlatform().addressMask();
    private static final NativeWordIO WordIO = NativeWordIO.getInstance();
    private static final int PARAM_SIZE = Platform.getPlatform().addressSize() / 8;
    private final long retval;
    private final long parameters;
    private final CallContext callContext;

    public DirectClosureBuffer(CallContext callContext, long l, long l2) {
        this.callContext = callContext;
        this.retval = l;
        this.parameters = l2;
    }

    public final byte getByte(int n) {
        return IO.getByte(IO.getAddress(this.parameters + (long)(n * PARAM_SIZE)));
    }

    public final short getShort(int n) {
        return IO.getShort(IO.getAddress(this.parameters + (long)(n * PARAM_SIZE)));
    }

    public final int getInt(int n) {
        return IO.getInt(IO.getAddress(this.parameters + (long)(n * PARAM_SIZE)));
    }

    public final long getLong(int n) {
        return IO.getLong(IO.getAddress(this.parameters + (long)(n * PARAM_SIZE)));
    }

    public final float getFloat(int n) {
        return IO.getFloat(IO.getAddress(this.parameters + (long)(n * PARAM_SIZE)));
    }

    public final double getDouble(int n) {
        return IO.getDouble(IO.getAddress(this.parameters + (long)(n * PARAM_SIZE)));
    }

    public final long getAddress(int n) {
        return IO.getAddress(IO.getAddress(this.parameters + (long)(n * PARAM_SIZE))) & ADDRESS_MASK;
    }

    public final long getStruct(int n) {
        return IO.getAddress(this.parameters + (long)(n * PARAM_SIZE));
    }

    public final void setByteReturn(byte by) {
        WordIO.put(this.retval, by);
    }

    public final void setShortReturn(short s) {
        WordIO.put(this.retval, s);
    }

    public final void setIntReturn(int n) {
        WordIO.put(this.retval, n);
    }

    public final void setLongReturn(long l) {
        IO.putLong(this.retval, l);
    }

    public final void setFloatReturn(float f) {
        IO.putFloat(this.retval, f);
    }

    public final void setDoubleReturn(double d) {
        IO.putDouble(this.retval, d);
    }

    public final void setAddressReturn(long l) {
        IO.putAddress(this.retval, l);
    }

    public void setStructReturn(long l) {
        IO.copyMemory(l, this.retval, this.callContext.getReturnType().size());
    }

    public void setStructReturn(byte[] byArray, int n) {
        IO.putByteArray(this.retval, byArray, n, this.callContext.getReturnType().size());
    }

    private static abstract class NativeWordIO {
        private NativeWordIO() {
        }

        public static final NativeWordIO getInstance() {
            return Platform.getPlatform().addressSize() == 32 ? NativeWordIO32.INSTANCE : NativeWordIO64.INSTANCE;
        }

        abstract void put(long var1, int var3);

        abstract int get(long var1);
    }

    private static final class NativeWordIO32
    extends NativeWordIO {
        private static final MemoryIO IO = MemoryIO.getInstance();
        static final NativeWordIO INSTANCE = new NativeWordIO32();

        private NativeWordIO32() {
        }

        void put(long l, int n) {
            IO.putInt(l, n);
        }

        int get(long l) {
            return IO.getInt(l);
        }
    }

    private static final class NativeWordIO64
    extends NativeWordIO {
        private static final MemoryIO IO = MemoryIO.getInstance();
        static final NativeWordIO INSTANCE = new NativeWordIO64();

        private NativeWordIO64() {
        }

        void put(long l, int n) {
            IO.putLong(l, n);
        }

        int get(long l) {
            return (int)IO.getLong(l);
        }
    }
}

