/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallInfo;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Foreign;
import com.kenai.jffi.Type;

public final class Function
implements CallInfo {
    private final long contextAddress;
    private final long functionAddress;
    private final int parameterCount;
    private final int rawParameterSize;
    private final Type returnType;
    private final Type[] paramTypes;
    private volatile boolean disposed = false;

    public Function(long l, Type type, Type ... typeArray) {
        this(l, type, typeArray, CallingConvention.DEFAULT, true);
    }

    public Function(long l, Type type, Type[] typeArray, CallingConvention callingConvention) {
        this(l, type, typeArray, callingConvention, true);
    }

    public Function(long l, Type type, Type[] typeArray, CallingConvention callingConvention, boolean bl) {
        this.functionAddress = l;
        int n = (!bl ? 2 : 0) | (callingConvention == CallingConvention.STDCALL ? 1 : 0);
        long l2 = Foreign.getInstance().newFunction(l, type.handle(), Type.nativeHandles(typeArray), n);
        if (l2 == 0L) {
            throw new RuntimeException("Failed to create native function");
        }
        this.contextAddress = l2;
        this.returnType = type;
        this.paramTypes = (Type[])typeArray.clone();
        this.parameterCount = typeArray.length;
        this.rawParameterSize = Foreign.getInstance().getFunctionRawParameterSize(l2);
    }

    public final int getParameterCount() {
        return this.parameterCount;
    }

    public final int getRawParameterSize() {
        return this.rawParameterSize;
    }

    final long getContextAddress() {
        return this.contextAddress;
    }

    public final long getFunctionAddress() {
        return this.functionAddress;
    }

    public final Type getReturnType() {
        return this.returnType;
    }

    public final Type getParameterType(int n) {
        return this.paramTypes[n];
    }

    public final synchronized void dispose() {
        if (this.disposed) {
            throw new RuntimeException("function already freed");
        }
        Foreign.getInstance().freeFunction(this.contextAddress);
        this.disposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.contextAddress != 0L && !this.disposed) {
                Foreign.getInstance().freeFunction(this.contextAddress);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
        finally {
            super.finalize();
        }
    }
}

