/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Properties;

final class Init {
    private static final String bootPropertyFilename = "boot.properties";
    private static final String bootLibraryPropertyName = "jffi.boot.library.path";
    private static final String stubLibraryName = String.format("jffi-%d.%d", Foreign.VERSION_MAJOR, Foreign.VERSION_MINOR);
    private static volatile boolean loaded = false;

    private Init() {
    }

    static final void load() {
        if (loaded) {
            return;
        }
        String string = Init.getStubLibraryName();
        String string2 = Init.getBootPath();
        if (string2 != null && Init.loadFromBootPath(string, string2)) {
            return;
        }
        try {
            System.loadLibrary(string);
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Init.loadFromJar();
            return;
        }
    }

    private static final String getBootPath() {
        String string = System.getProperty(bootLibraryPropertyName);
        if (string != null) {
            return string;
        }
        InputStream inputStream = Init.class.getResourceAsStream(bootPropertyFilename);
        if (inputStream != null) {
            Properties properties = new Properties();
            try {
                properties.load(inputStream);
                return properties.getProperty(bootLibraryPropertyName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static final boolean loadFromBootPath(String string, String string2) {
        String[] stringArray = string2.split(File.pathSeparator);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = new File(new File(stringArray[i]), System.mapLibraryName(string)).getAbsolutePath();
            try {
                System.load(string3);
                return true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                String string4;
                String string5;
                if (Platform.getPlatform().getOS() != Platform.OS.DARWIN) continue;
                if (string3.endsWith("dylib")) {
                    string5 = "dylib";
                    string4 = "jnilib";
                } else {
                    string5 = "jnilib";
                    string4 = "dylib";
                }
                try {
                    System.load(string3.substring(0, string3.lastIndexOf(string5)) + string4);
                    return true;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                    // empty catch block
                }
                continue;
            }
        }
        return false;
    }

    private static final void loadFromJar() {
        InputStream inputStream = Init.getStubLibraryStream();
        File file = null;
        try {
            file = File.createTempFile("jffi", null);
            file.deleteOnExit();
            FileChannel fileChannel = new FileOutputStream(file).getChannel();
            ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
            long l = 0L;
            while (inputStream.available() > 0) {
                l += fileChannel.transferFrom(readableByteChannel, l, Math.max(4096, inputStream.available()));
            }
            fileChannel.close();
            System.load(file.getAbsolutePath());
        }
        catch (IOException iOException) {
            throw new UnsatisfiedLinkError(iOException.getMessage());
        }
    }

    private static final InputStream getStubLibraryStream() {
        String string = Init.getStubLibraryPath();
        InputStream inputStream = Init.class.getResourceAsStream(string);
        if (inputStream == null && Platform.getPlatform().getOS() == Platform.OS.DARWIN) {
            inputStream = Init.class.getResourceAsStream(string.replaceAll("dylib", "jnilib"));
        }
        if (inputStream == null) {
            throw new UnsatisfiedLinkError("Could not locate stub library (" + string + ") in jar file");
        }
        return inputStream;
    }

    private static final String getStubLibraryName() {
        return stubLibraryName;
    }

    private static final String getStubLibraryPath() {
        return "/jni/" + Platform.getPlatform().getName() + "/" + System.mapLibraryName(stubLibraryName);
    }
}

