/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.ObjectBuffer;
import com.kenai.jffi.Platform;

public abstract class Invoker {
    private static final long ADDRESS_SIZE = Platform.getPlatform().addressSize();
    private static final long ADDRESS_MASK = Platform.getPlatform().addressMask();
    private final Foreign foreign = Foreign.getInstance();

    public static final Invoker getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private Invoker() {
    }

    public final int invokeVrI(Function function) {
        return this.foreign.invokeVrI(function.getContextAddress());
    }

    public final float invokeVrF(Function function) {
        return this.foreign.invokeVrF(function.getContextAddress());
    }

    public final int invokeNoErrnoVrI(Function function) {
        return this.foreign.invokeNoErrnoVrI(function.getContextAddress());
    }

    public final int invokeIrI(Function function, int n) {
        return this.foreign.invokeIrI(function.getContextAddress(), n);
    }

    public final int invokeNoErrnoIrI(Function function, int n) {
        return this.foreign.invokeNoErrnoIrI(function.getContextAddress(), n);
    }

    public final float invokeIrF(Function function, int n) {
        return this.foreign.invokeIrF(function.getContextAddress(), n);
    }

    public final int invokeIIrI(Function function, int n, int n2) {
        return this.foreign.invokeIIrI(function.getContextAddress(), n, n2);
    }

    public final int invokeNoErrnoIIrI(Function function, int n, int n2) {
        return this.foreign.invokeNoErrnoIIrI(function.getContextAddress(), n, n2);
    }

    public final float invokeIIrF(Function function, int n, int n2) {
        return this.foreign.invokeIIrF(function.getContextAddress(), n, n2);
    }

    public final int invokeIIIrI(Function function, int n, int n2, int n3) {
        return this.foreign.invokeIIIrI(function.getContextAddress(), n, n2, n3);
    }

    public final int invokeNoErrnoIIIrI(Function function, int n, int n2, int n3) {
        return this.foreign.invokeNoErrnoIIIrI(function.getContextAddress(), n, n2, n3);
    }

    public final float invokeIIIrF(Function function, int n, int n2, int n3) {
        return this.foreign.invokeIIIrF(function.getContextAddress(), n, n2, n3);
    }

    public final long invokeVrL(Function function) {
        return this.foreign.invokeVrL(function.getContextAddress());
    }

    public final long invokeLrL(Function function, long l) {
        return this.foreign.invokeLrL(function.getContextAddress(), l);
    }

    public final long invokeLLrL(Function function, long l, long l2) {
        return this.foreign.invokeLLrL(function.getContextAddress(), l, l2);
    }

    public final long invokeLLLrL(Function function, long l, long l2, long l3) {
        return this.foreign.invokeLLLrL(function.getContextAddress(), l, l2, l3);
    }

    public final long invokeLLLLrL(Function function, long l, long l2, long l3, long l4, long l5) {
        return this.foreign.invokeLLLLrL(function.getContextAddress(), l, l2, l3, l4);
    }

    public final long invokeLLLLLrL(Function function, long l, long l2, long l3, long l4, long l5) {
        return this.foreign.invokeLLLLLrL(function.getContextAddress(), l, l2, l3, l4, l5);
    }

    public final long invokeLLLLLLrL(Function function, long l, long l2, long l3, long l4, long l5, long l6) {
        return this.foreign.invokeLLLLLLrL(function.getContextAddress(), l, l2, l3, l4, l5, l6);
    }

    public final long invokeVrN(Function function) {
        return this.foreign.invokeVrN(function.getContextAddress());
    }

    public final long invokeNrN(Function function, long l) {
        return this.foreign.invokeNrN(function.getContextAddress(), l);
    }

    public final long invokeNNrN(Function function, long l, long l2) {
        return this.foreign.invokeNNrN(function.getContextAddress(), l, l2);
    }

    public final long invokeNNNrN(Function function, long l, long l2, long l3) {
        return this.foreign.invokeNNNrN(function.getContextAddress(), l, l2, l3);
    }

    public final long invokeNNNNrN(Function function, long l, long l2, long l3, long l4) {
        return this.foreign.invokeNNNNrN(function.getContextAddress(), l, l2, l3, l4);
    }

    public final long invokeNNNNNrN(Function function, long l, long l2, long l3, long l4, long l5) {
        return this.foreign.invokeNNNNNrN(function.getContextAddress(), l, l2, l3, l4, l5);
    }

    public final long invokeNNNNNNrN(Function function, long l, long l2, long l3, long l4, long l5, long l6) {
        return this.foreign.invokeNNNNNNrN(function.getContextAddress(), l, l2, l3, l4, l5, l6);
    }

    public abstract long invokeAddress(Function var1, HeapInvocationBuffer var2);

    public final int invokeInt(Function function, HeapInvocationBuffer heapInvocationBuffer) {
        ObjectBuffer objectBuffer = heapInvocationBuffer.objectBuffer();
        return objectBuffer != null ? this.invokeArrayWithObjectsInt32(function, heapInvocationBuffer, objectBuffer) : this.foreign.invokeArrayReturnInt(function.getContextAddress(), heapInvocationBuffer.array());
    }

    public final long invokeLong(Function function, HeapInvocationBuffer heapInvocationBuffer) {
        ObjectBuffer objectBuffer = heapInvocationBuffer.objectBuffer();
        return objectBuffer != null ? this.foreign.invokeArrayWithObjectsInt64(function.getContextAddress(), heapInvocationBuffer.array(), objectBuffer.objectCount(), objectBuffer.info(), objectBuffer.objects()) : this.foreign.invokeArrayReturnLong(function.getContextAddress(), heapInvocationBuffer.array());
    }

    public final float invokeFloat(Function function, HeapInvocationBuffer heapInvocationBuffer) {
        ObjectBuffer objectBuffer = heapInvocationBuffer.objectBuffer();
        return objectBuffer != null ? this.foreign.invokeArrayWithObjectsFloat(function.getContextAddress(), heapInvocationBuffer.array(), objectBuffer.objectCount(), objectBuffer.info(), objectBuffer.objects()) : this.foreign.invokeArrayReturnFloat(function.getContextAddress(), heapInvocationBuffer.array());
    }

    public final double invokeDouble(Function function, HeapInvocationBuffer heapInvocationBuffer) {
        ObjectBuffer objectBuffer = heapInvocationBuffer.objectBuffer();
        return objectBuffer != null ? this.foreign.invokeArrayWithObjectsDouble(function.getContextAddress(), heapInvocationBuffer.array(), objectBuffer.objectCount(), objectBuffer.info(), objectBuffer.objects()) : this.foreign.invokeArrayReturnDouble(function.getContextAddress(), heapInvocationBuffer.array());
    }

    public final byte[] invokeStruct(Function function, HeapInvocationBuffer heapInvocationBuffer) {
        byte[] byArray = new byte[function.getReturnType().size()];
        this.invokeStruct(function, heapInvocationBuffer, byArray, 0);
        return byArray;
    }

    public final void invokeStruct(Function function, HeapInvocationBuffer heapInvocationBuffer, byte[] byArray, int n) {
        ObjectBuffer objectBuffer = heapInvocationBuffer.objectBuffer();
        if (objectBuffer != null) {
            this.foreign.invokeArrayWithObjectsReturnStruct(function.getContextAddress(), heapInvocationBuffer.array(), objectBuffer.objectCount(), objectBuffer.info(), objectBuffer.objects(), byArray, n);
        } else {
            this.foreign.invokeArrayReturnStruct(function.getContextAddress(), heapInvocationBuffer.array(), byArray, n);
        }
    }

    public final Object invokeObject(Function function, HeapInvocationBuffer heapInvocationBuffer) {
        ObjectBuffer objectBuffer = heapInvocationBuffer.objectBuffer();
        return this.foreign.invokeArrayWithObjectsReturnObject(function.getContextAddress(), heapInvocationBuffer.array(), objectBuffer.objectCount(), objectBuffer.info(), objectBuffer.objects());
    }

    public final void invoke(Function function, long l, long[] lArray) {
        this.foreign.invokePointerParameterArray(function.getContextAddress(), l, lArray);
    }

    private final int invokeArrayWithObjectsInt32(Function function, HeapInvocationBuffer heapInvocationBuffer, ObjectBuffer objectBuffer) {
        Object[] objectArray = objectBuffer.objects();
        int[] nArray = objectBuffer.info();
        int n = objectBuffer.objectCount();
        switch (n) {
            case 1: {
                return this.foreign.invokeArrayO1Int32(function.getContextAddress(), heapInvocationBuffer.array(), objectArray[0], nArray[0], nArray[1], nArray[2]);
            }
            case 2: {
                return this.foreign.invokeArrayO2Int32(function.getContextAddress(), heapInvocationBuffer.array(), objectArray[0], nArray[0], nArray[1], nArray[2], objectArray[1], nArray[3], nArray[4], nArray[5]);
            }
        }
        return this.foreign.invokeArrayWithObjectsInt32(function.getContextAddress(), heapInvocationBuffer.array(), n, nArray, objectArray);
    }

    static /* synthetic */ long access$000() {
        return ADDRESS_SIZE;
    }

    private static final class ILP32
    extends Invoker {
        private static final Invoker INSTANCE = new ILP32();

        private ILP32() {
        }

        public final long invokeAddress(Function function, HeapInvocationBuffer heapInvocationBuffer) {
            return (long)this.invokeInt(function, heapInvocationBuffer) & ADDRESS_MASK;
        }

        static /* synthetic */ Invoker access$200() {
            return INSTANCE;
        }
    }

    private static final class LP64
    extends Invoker {
        private static final Invoker INSTANCE = new LP64();

        private LP64() {
        }

        public long invokeAddress(Function function, HeapInvocationBuffer heapInvocationBuffer) {
            return this.invokeLong(function, heapInvocationBuffer);
        }

        static /* synthetic */ Invoker access$100() {
            return INSTANCE;
        }
    }

    private static final class SingletonHolder {
        private static final Invoker INSTANCE = Invoker.access$000() == 64L ? LP64.access$100() : ILP32.access$200();

        private SingletonHolder() {
        }
    }
}

