/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.Platform;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;

public abstract class MemoryIO {
    private final Foreign foreign = Foreign.getInstance();
    private static final long ADDRESS_MASK = Platform.getPlatform().addressMask();

    public static MemoryIO getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private MemoryIO() {
    }

    private static final MemoryIO newMemoryIO() {
        try {
            return !Boolean.getBoolean("jffi.unsafe.disabled") && MemoryIO.isUnsafeAvailable() ? MemoryIO.newUnsafeImpl() : MemoryIO.newNativeImpl();
        }
        catch (Throwable throwable) {
            return MemoryIO.newNativeImpl();
        }
    }

    private static final MemoryIO newNativeImpl() {
        return Platform.getPlatform().addressSize() == 32 ? MemoryIO.newNativeImpl32() : MemoryIO.newNativeImpl64();
    }

    private static final MemoryIO newNativeImpl32() {
        return new NativeImpl32();
    }

    private static final MemoryIO newNativeImpl64() {
        return new NativeImpl64();
    }

    private static final MemoryIO newUnsafeImpl() {
        return Platform.getPlatform().addressSize() == 32 ? MemoryIO.newUnsafeImpl32() : MemoryIO.newUnsafeImpl64();
    }

    private static final MemoryIO newUnsafeImpl32() {
        return new UnsafeImpl32();
    }

    private static final MemoryIO newUnsafeImpl64() {
        return new UnsafeImpl64();
    }

    public abstract byte getByte(long var1);

    public abstract short getShort(long var1);

    public abstract int getInt(long var1);

    public abstract long getLong(long var1);

    public abstract float getFloat(long var1);

    public abstract double getDouble(long var1);

    public abstract long getAddress(long var1);

    public abstract void putByte(long var1, byte var3);

    public abstract void putShort(long var1, short var3);

    public abstract void putInt(long var1, int var3);

    public abstract void putLong(long var1, long var3);

    public abstract void putFloat(long var1, float var3);

    public abstract void putDouble(long var1, double var3);

    public abstract void putAddress(long var1, long var3);

    public final void copyMemory(long l, long l2, long l3) {
        if (l2 + l3 < l || l + l3 < l2) {
            this._copyMemory(l, l2, l3);
        } else {
            this.foreign.memmove(l2, l, l3);
        }
    }

    abstract void _copyMemory(long var1, long var3, long var5);

    public abstract void setMemory(long var1, long var3, byte var5);

    public final void memcpy(long l, long l2, long l3) {
        this._copyMemory(l2, l, l3);
    }

    public final void memmove(long l, long l2, long l3) {
        this.foreign.memmove(l, l2, l3);
    }

    public final void memset(long l, int n, long l2) {
        this.setMemory(l, l2, (byte)n);
    }

    public final void putByteArray(long l, byte[] byArray, int n, int n2) {
        this.foreign.putByteArray(l, byArray, n, n2);
    }

    public final void getByteArray(long l, byte[] byArray, int n, int n2) {
        this.foreign.getByteArray(l, byArray, n, n2);
    }

    public final void putCharArray(long l, char[] cArray, int n, int n2) {
        this.foreign.putCharArray(l, cArray, n, n2);
    }

    public final void getCharArray(long l, char[] cArray, int n, int n2) {
        this.foreign.getCharArray(l, cArray, n, n2);
    }

    public final void putShortArray(long l, short[] sArray, int n, int n2) {
        this.foreign.putShortArray(l, sArray, n, n2);
    }

    public final void getShortArray(long l, short[] sArray, int n, int n2) {
        this.foreign.getShortArray(l, sArray, n, n2);
    }

    public final void putIntArray(long l, int[] nArray, int n, int n2) {
        this.foreign.putIntArray(l, nArray, n, n2);
    }

    public final void getIntArray(long l, int[] nArray, int n, int n2) {
        this.foreign.getIntArray(l, nArray, n, n2);
    }

    public final void putLongArray(long l, long[] lArray, int n, int n2) {
        this.foreign.putLongArray(l, lArray, n, n2);
    }

    public final void getLongArray(long l, long[] lArray, int n, int n2) {
        this.foreign.getLongArray(l, lArray, n, n2);
    }

    public final void putFloatArray(long l, float[] fArray, int n, int n2) {
        this.foreign.putFloatArray(l, fArray, n, n2);
    }

    public final void getFloatArray(long l, float[] fArray, int n, int n2) {
        this.foreign.getFloatArray(l, fArray, n, n2);
    }

    public final void putDoubleArray(long l, double[] dArray, int n, int n2) {
        this.foreign.putDoubleArray(l, dArray, n, n2);
    }

    public final void getDoubleArray(long l, double[] dArray, int n, int n2) {
        this.foreign.getDoubleArray(l, dArray, n, n2);
    }

    public final long allocateMemory(long l, boolean bl) {
        return this.foreign.allocateMemory(l, bl);
    }

    public final void freeMemory(long l) {
        this.foreign.freeMemory(l);
    }

    public final long getStringLength(long l) {
        return this.foreign.strlen(l);
    }

    public final byte[] getZeroTerminatedByteArray(long l) {
        return this.foreign.getZeroTerminatedByteArray(l);
    }

    public final byte[] getZeroTerminatedByteArray(long l, int n) {
        return this.foreign.getZeroTerminatedByteArray(l, n);
    }

    @Deprecated
    public final byte[] getZeroTerminatedByteArray(long l, long l2) {
        return this.foreign.getZeroTerminatedByteArray(l, (int)l2);
    }

    public final void putZeroTerminatedByteArray(long l, byte[] byArray, int n, int n2) {
        this.foreign.putZeroTerminatedByteArray(l, byArray, n, n2);
    }

    public final long indexOf(long l, byte by) {
        long l2 = this.foreign.memchr(l, by, Integer.MAX_VALUE);
        return l2 != 0L ? l2 - l : -1L;
    }

    public final long indexOf(long l, byte by, int n) {
        long l2 = this.foreign.memchr(l, by, n);
        return l2 != 0L ? l2 - l : -1L;
    }

    public final ByteBuffer newDirectByteBuffer(long l, int n) {
        return this.foreign.newDirectByteBuffer(l, n);
    }

    public final long getDirectBufferAddress(Buffer buffer) {
        return this.foreign.getDirectBufferAddress(buffer);
    }

    private static final void verifyAccessor(Class clazz, Class clazz2) throws NoSuchMethodException {
        String string = clazz2.getSimpleName();
        String string2 = string.substring(0, 1).toUpperCase() + string.substring(1);
        Method method = clazz.getDeclaredMethod("get" + string2, Long.TYPE);
        if (!method.getReturnType().equals(clazz2)) {
            throw new NoSuchMethodException("Incorrect return type for " + method.getName());
        }
        clazz.getDeclaredMethod("put" + string2, Long.TYPE, clazz2);
    }

    static final boolean isUnsafeAvailable() {
        try {
            Class[] classArray;
            Class<?> clazz = Class.forName("sun.misc.Unsafe");
            for (Class clazz2 : classArray = new Class[]{Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE}) {
                MemoryIO.verifyAccessor(clazz, clazz2);
            }
            clazz.getDeclaredMethod("getAddress", Long.TYPE);
            clazz.getDeclaredMethod("putAddress", Long.TYPE, Long.TYPE);
            clazz.getDeclaredMethod("allocateMemory", Long.TYPE);
            clazz.getDeclaredMethod("freeMemory", Long.TYPE);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static /* synthetic */ MemoryIO access$000() {
        return MemoryIO.newMemoryIO();
    }

    private static abstract class NativeImpl
    extends MemoryIO {
        protected static final Foreign foreign = Foreign.getInstance();

        private NativeImpl() {
        }

        public final byte getByte(long l) {
            return foreign.getByte(l);
        }

        public final short getShort(long l) {
            return foreign.getShort(l);
        }

        public final int getInt(long l) {
            return foreign.getInt(l);
        }

        public final long getLong(long l) {
            return foreign.getLong(l);
        }

        public final float getFloat(long l) {
            return foreign.getFloat(l);
        }

        public final double getDouble(long l) {
            return foreign.getDouble(l);
        }

        public final void putByte(long l, byte by) {
            foreign.putByte(l, by);
        }

        public final void putShort(long l, short s) {
            foreign.putShort(l, s);
        }

        public final void putInt(long l, int n) {
            foreign.putInt(l, n);
        }

        public final void putLong(long l, long l2) {
            foreign.putLong(l, l2);
        }

        public final void putFloat(long l, float f) {
            foreign.putFloat(l, f);
        }

        public final void putDouble(long l, double d) {
            foreign.putDouble(l, d);
        }

        public final void setMemory(long l, long l2, byte by) {
            foreign.setMemory(l, l2, by);
        }

        public final void _copyMemory(long l, long l2, long l3) {
            foreign.copyMemory(l, l2, l3);
        }
    }

    private static final class NativeImpl32
    extends NativeImpl {
        private NativeImpl32() {
        }

        public final long getAddress(long l) {
            return foreign.getAddress(l) & ADDRESS_MASK;
        }

        public final void putAddress(long l, long l2) {
            foreign.putAddress(l, l2 & ADDRESS_MASK);
        }
    }

    private static final class NativeImpl64
    extends NativeImpl {
        private NativeImpl64() {
        }

        public final long getAddress(long l) {
            return foreign.getAddress(l);
        }

        public final void putAddress(long l, long l2) {
            foreign.putAddress(l, l2);
        }
    }

    private static final class SingletonHolder {
        private static final MemoryIO INSTANCE = MemoryIO.access$000();

        private SingletonHolder() {
        }
    }

    private static abstract class UnsafeImpl
    extends MemoryIO {
        protected static Unsafe unsafe = (Unsafe)Unsafe.class.cast(UnsafeImpl.getUnsafe());

        private UnsafeImpl() {
        }

        private static final Object getUnsafe() {
            try {
                Class<?> clazz = Class.forName("sun.misc.Unsafe");
                Field field = clazz.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                return field.get(clazz);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public final byte getByte(long l) {
            return unsafe.getByte(l);
        }

        public final short getShort(long l) {
            return unsafe.getShort(l);
        }

        public final int getInt(long l) {
            return unsafe.getInt(l);
        }

        public final long getLong(long l) {
            return unsafe.getLong(l);
        }

        public final float getFloat(long l) {
            return unsafe.getFloat(l);
        }

        public final double getDouble(long l) {
            return unsafe.getDouble(l);
        }

        public final void putByte(long l, byte by) {
            unsafe.putByte(l, by);
        }

        public final void putShort(long l, short s) {
            unsafe.putShort(l, s);
        }

        public final void putInt(long l, int n) {
            unsafe.putInt(l, n);
        }

        public final void putLong(long l, long l2) {
            unsafe.putLong(l, l2);
        }

        public final void putFloat(long l, float f) {
            unsafe.putFloat(l, f);
        }

        public final void putDouble(long l, double d) {
            unsafe.putDouble(l, d);
        }

        public final void _copyMemory(long l, long l2, long l3) {
            unsafe.copyMemory(l, l2, l3);
        }

        public final void setMemory(long l, long l2, byte by) {
            unsafe.setMemory(l, l2, by);
        }
    }

    private static final class UnsafeImpl32
    extends UnsafeImpl {
        private UnsafeImpl32() {
        }

        public final long getAddress(long l) {
            return unsafe.getAddress(l) & ADDRESS_MASK;
        }

        public final void putAddress(long l, long l2) {
            unsafe.putAddress(l, l2 & ADDRESS_MASK);
        }
    }

    private static final class UnsafeImpl64
    extends UnsafeImpl {
        private UnsafeImpl64() {
        }

        public final long getAddress(long l) {
            return unsafe.getAddress(l);
        }

        public final void putAddress(long l, long l2) {
            unsafe.putAddress(l, l2);
        }
    }
}

