/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;

public abstract class Platform {
    private final OS os;
    private final CPU cpu;
    private final int addressSize;
    private final long addressMask;
    private final int longSize;
    private final int javaVersionMajor;

    private static final OS determineOS() {
        String string = System.getProperty("os.name").split(" ")[0].toLowerCase();
        if (string.startsWith("mac") || string.startsWith("darwin")) {
            return OS.DARWIN;
        }
        if (string.startsWith("linux")) {
            return OS.LINUX;
        }
        if (string.startsWith("sunos") || string.startsWith("solaris")) {
            return OS.SOLARIS;
        }
        if (string.startsWith("aix")) {
            return OS.AIX;
        }
        if (string.startsWith("openbsd")) {
            return OS.OPENBSD;
        }
        if (string.startsWith("freebsd")) {
            return OS.FREEBSD;
        }
        if (string.startsWith("windows")) {
            return OS.WINDOWS;
        }
        throw new ExceptionInInitializerError("Unsupported operating system");
    }

    private static final Platform determinePlatform(OS oS) {
        switch (oS) {
            case DARWIN: {
                return new Darwin();
            }
            case WINDOWS: {
                return new Windows();
            }
            case UNKNOWN: {
                throw new ExceptionInInitializerError("Unsupported operating system");
            }
        }
        return new Default(oS);
    }

    private static final CPU determineCPU() {
        String string = System.getProperty("os.arch", "unknown").toLowerCase();
        if ("x86".equals(string) || "i386".equals(string) || "i86pc".equals(string)) {
            return CPU.I386;
        }
        if ("x86_64".equals(string) || "amd64".equals(string)) {
            return CPU.X86_64;
        }
        if ("ppc".equals(string) || "powerpc".equals(string)) {
            return CPU.PPC;
        }
        if ("powerpc64".equals(string)) {
            return CPU.PPC64;
        }
        try {
            return CPU.valueOf(string.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ExceptionInInitializerError("Unsupported CPU architecture: " + string);
        }
    }

    private Platform(OS oS) {
        this.os = oS;
        this.cpu = Platform.determineCPU();
        int n = Integer.getInteger("sun.arch.data.model", 0);
        if (n != 32 && n != 64) {
            switch (this.cpu) {
                case I386: 
                case PPC: 
                case SPARC: {
                    n = 32;
                    break;
                }
                case X86_64: 
                case PPC64: 
                case SPARCV9: 
                case S390X: {
                    n = 64;
                    break;
                }
                default: {
                    throw new ExceptionInInitializerError("Cannot determine cpu address size");
                }
            }
        }
        this.addressSize = n;
        this.addressMask = this.addressSize == 32 ? 0xFFFFFFFFL : -1L;
        this.longSize = oS == OS.WINDOWS ? 32 : this.addressSize;
        int n2 = 5;
        try {
            String string = System.getProperty("java.version");
            if (string != null) {
                String[] stringArray = string.split("\\.");
                n2 = Integer.valueOf(stringArray[1]);
            }
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError("Could not determine java version");
        }
        this.javaVersionMajor = n2;
    }

    public static final Platform getPlatform() {
        return SingletonHolder.PLATFORM;
    }

    public final OS getOS() {
        return this.os;
    }

    public final CPU getCPU() {
        return this.cpu;
    }

    public final int getJavaMajorVersion() {
        return this.javaVersionMajor;
    }

    public final int longSize() {
        return this.longSize;
    }

    public final int addressSize() {
        return this.addressSize;
    }

    public final long addressMask() {
        return this.addressMask;
    }

    public String getName() {
        String string = System.getProperty("os.name").split(" ")[0];
        return this.getCPU().name().toLowerCase() + "-" + string;
    }

    public String mapLibraryName(String string) {
        if (string.matches(this.getLibraryNamePattern())) {
            return string;
        }
        return System.mapLibraryName(string);
    }

    public String getLibraryNamePattern() {
        return "lib.*\\.so.*$";
    }

    public boolean isSupported() {
        int n = Foreign.getInstance().getVersion();
        if ((n & 0xFFFF00) == (Foreign.VERSION_MAJOR << 16 | Foreign.VERSION_MINOR << 8)) {
            return true;
        }
        throw new UnsatisfiedLinkError("Incorrect native library version");
    }

    static /* synthetic */ OS access$000() {
        return Platform.determineOS();
    }

    static /* synthetic */ Platform access$100(OS oS) {
        return Platform.determinePlatform(oS);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CPU {
        I386,
        X86_64,
        PPC,
        PPC64,
        SPARC,
        SPARCV9,
        S390X,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    private static final class Darwin
    extends Platform {
        public Darwin() {
            super(OS.DARWIN);
        }

        public String mapLibraryName(String string) {
            if (string.matches(this.getLibraryNamePattern())) {
                return string;
            }
            return "lib" + string + ".dylib";
        }

        public String getLibraryNamePattern() {
            return "lib.*\\.(dylib|jnilib)$";
        }

        public String getName() {
            return "Darwin";
        }
    }

    private static final class Default
    extends Platform {
        public Default(OS oS) {
            super(oS);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OS {
        DARWIN,
        FREEBSD,
        NETBSD,
        OPENBSD,
        LINUX,
        SOLARIS,
        WINDOWS,
        AIX,
        ZLINUX,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    private static final class SingletonHolder {
        static final Platform PLATFORM = Platform.access$100(Platform.access$000());

        private SingletonHolder() {
        }
    }

    private static class Windows
    extends Platform {
        public Windows() {
            super(OS.WINDOWS);
        }

        public String getLibraryNamePattern() {
            return ".*\\.dll$";
        }
    }
}

