/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.NativeType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Type {
    public static final Type VOID = Type.builtin(NativeType.VOID);
    public static final Type FLOAT = Type.builtin(NativeType.FLOAT);
    public static final Type DOUBLE = Type.builtin(NativeType.DOUBLE);
    public static final Type LONGDOUBLE = Type.builtin(NativeType.LONGDOUBLE);
    public static final Type UINT8 = Type.builtin(NativeType.UINT8);
    public static final Type SINT8 = Type.builtin(NativeType.SINT8);
    public static final Type UINT16 = Type.builtin(NativeType.UINT16);
    public static final Type SINT16 = Type.builtin(NativeType.SINT16);
    public static final Type UINT32 = Type.builtin(NativeType.UINT32);
    public static final Type SINT32 = Type.builtin(NativeType.SINT32);
    public static final Type UINT64 = Type.builtin(NativeType.UINT64);
    public static final Type SINT64 = Type.builtin(NativeType.SINT64);
    public static final Type POINTER = Type.builtin(NativeType.POINTER);
    public static final Type UCHAR = UINT8;
    public static final Type SCHAR = SINT8;
    public static final Type USHORT = UINT16;
    public static final Type SSHORT = SINT16;
    public static final Type UINT = UINT32;
    public static final Type SINT = SINT32;
    public static final Type ULONG = Type.builtin(NativeType.ULONG);
    public static final Type SLONG = Type.builtin(NativeType.SLONG);
    public static final Type ULONG_LONG = UINT64;
    public static final Type SLONG_LONG = SINT64;

    public abstract int type();

    abstract long handle();

    public abstract int size();

    public abstract int alignment();

    public boolean equals(Object object) {
        return object instanceof Type && ((Type)object).handle() == this.handle();
    }

    public int hashCode() {
        int n = 3;
        n = 67 * n + (int)(this.handle() ^ this.handle() >>> 32);
        return n;
    }

    static final long[] nativeHandles(Type[] typeArray) {
        long[] lArray = new long[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            lArray[i] = typeArray[i].handle();
        }
        return lArray;
    }

    static final long[] nativeHandles(List<Type> list) {
        long[] lArray = new long[list.size()];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = list.get(i).handle();
        }
        return lArray;
    }

    private static final Type builtin(NativeType nativeType) {
        return new Builtin(nativeType);
    }

    static final class Builtin
    extends Type {
        private final NativeType nativeType;

        private Builtin(NativeType nativeType) {
            this.nativeType = nativeType;
        }

        public final int type() {
            return BuiltinTypeInfo.find((NativeType)this.nativeType).type;
        }

        public final long handle() {
            return BuiltinTypeInfo.find((NativeType)this.nativeType).handle;
        }

        public final int size() {
            return BuiltinTypeInfo.find((NativeType)this.nativeType).size;
        }

        public final int alignment() {
            return BuiltinTypeInfo.find((NativeType)this.nativeType).alignment;
        }
    }

    private static final class BuiltinTypeInfo {
        public static final BuiltinTypeInfo[] typeMap;
        final int type;
        final int size;
        final int alignment;
        final long handle;

        static final BuiltinTypeInfo find(NativeType nativeType) {
            return typeMap[nativeType.ordinal()];
        }

        private BuiltinTypeInfo(long l) {
            if (l == 0L) {
                throw new NullPointerException("null ffi_type handle");
            }
            this.handle = l;
            this.type = Foreign.getInstance().getTypeType(l);
            this.size = Foreign.getInstance().getTypeSize(l);
            this.alignment = Foreign.getInstance().getTypeAlign(l);
        }

        static {
            NativeType[] nativeTypeArray = NativeType.values();
            typeMap = new BuiltinTypeInfo[nativeTypeArray.length];
            for (int i = 0; i < typeMap.length; ++i) {
                long l = Foreign.getInstance().lookupBuiltinType(nativeTypeArray[i].ffiType);
                if (l == 0L) {
                    throw new RuntimeException("invalid native type " + (Object)((Object)nativeTypeArray[i]));
                }
                BuiltinTypeInfo.typeMap[i] = new BuiltinTypeInfo(l);
            }
        }
    }
}

