/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.Procedure;
import com.ziclix.python.sql.PyCursor;
import com.ziclix.python.sql.zxJDBC;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import org.python.core.Py;
import org.python.core.PyFile;
import org.python.core.PyList;
import org.python.core.PyObject;

public class DataHandler {
    private static final int INITIAL_SIZE = 4096;
    private static final String[] SYSTEM_DATAHANDLERS = new String[]{"com.ziclix.python.sql.JDBC20DataHandler"};

    public String getMetaDataName(PyObject pyObject) {
        return pyObject == Py.None ? null : pyObject.__str__().toString();
    }

    public Procedure getProcedure(PyCursor pyCursor, PyObject pyObject) throws SQLException {
        return new Procedure(pyCursor, pyObject);
    }

    public PyObject getRowId(Statement statement) throws SQLException {
        return Py.None;
    }

    public void preExecute(Statement statement) throws SQLException {
    }

    public void postExecute(Statement statement) throws SQLException {
    }

    public void setJDBCObject(PreparedStatement preparedStatement, int n, PyObject pyObject) throws SQLException {
        try {
            Object object = pyObject.__tojava__(Object.class);
            if (object instanceof BigInteger) {
                preparedStatement.setObject(n, object, -5);
            } else {
                preparedStatement.setObject(n, object);
            }
        }
        catch (Exception exception) {
            SQLException sQLException = null;
            SQLException sQLException2 = new SQLException("error setting index [" + n + "]");
            sQLException = exception instanceof SQLException ? (SQLException)exception : new SQLException(exception.getMessage());
            sQLException2.setNextException(sQLException);
            throw sQLException2;
        }
    }

    public void setJDBCObject(PreparedStatement preparedStatement, int n, PyObject pyObject, int n2) throws SQLException {
        try {
            if (DataHandler.checkNull(preparedStatement, n, pyObject, n2)) {
                return;
            }
            switch (n2) {
                case 91: {
                    Date date = (Date)pyObject.__tojava__(Date.class);
                    preparedStatement.setDate(n, date);
                    break;
                }
                case 92: {
                    Time time = (Time)pyObject.__tojava__(Time.class);
                    preparedStatement.setTime(n, time);
                    break;
                }
                case 93: {
                    Timestamp timestamp = (Timestamp)pyObject.__tojava__(Timestamp.class);
                    preparedStatement.setTimestamp(n, timestamp);
                    break;
                }
                case -1: {
                    if (pyObject instanceof PyFile) {
                        pyObject = ((PyFile)pyObject).read();
                    }
                    String string = (String)pyObject.__tojava__(String.class);
                    BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
                    preparedStatement.setCharacterStream(n, (Reader)bufferedReader, string.length());
                    break;
                }
                case -7: {
                    preparedStatement.setBoolean(n, pyObject.__nonzero__());
                    break;
                }
                default: {
                    if (pyObject instanceof PyFile) {
                        pyObject = ((PyFile)pyObject).read();
                    }
                    preparedStatement.setObject(n, pyObject.__tojava__(Object.class), n2);
                    break;
                }
            }
        }
        catch (Exception exception) {
            SQLException sQLException = null;
            SQLException sQLException2 = new SQLException("error setting index [" + n + "], type [" + n2 + "]");
            sQLException = exception instanceof SQLException ? (SQLException)exception : new SQLException(exception.getMessage());
            sQLException2.setNextException(sQLException);
            throw sQLException2;
        }
    }

    public PyObject getPyObject(ResultSet resultSet, int n, int n2) throws SQLException {
        PyObject pyObject = Py.None;
        switch (n2) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                String string = resultSet.getString(n);
                pyObject = string == null ? Py.None : Py.newUnicode(string);
                break;
            }
            case -16: 
            case -1: {
                Reader reader = resultSet.getCharacterStream(n);
                pyObject = reader == null ? Py.None : Py.newUnicode(DataHandler.read(reader));
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = resultSet.getBigDecimal(n);
                pyObject = bigDecimal == null ? Py.None : Py.newFloat(bigDecimal.doubleValue());
                break;
            }
            case -7: 
            case 16: {
                pyObject = resultSet.getBoolean(n) ? Py.True : Py.False;
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                pyObject = Py.newInteger(resultSet.getInt(n));
                break;
            }
            case -5: {
                pyObject = Py.newLong(resultSet.getLong(n));
                break;
            }
            case 6: 
            case 7: {
                pyObject = Py.newFloat(resultSet.getFloat(n));
                break;
            }
            case 8: {
                pyObject = Py.newFloat(resultSet.getDouble(n));
                break;
            }
            case 92: {
                pyObject = Py.newTime(resultSet.getTime(n));
                break;
            }
            case 93: {
                pyObject = Py.newDatetime(resultSet.getTimestamp(n));
                break;
            }
            case 91: {
                Object object = resultSet.getObject(n);
                pyObject = object instanceof Date ? Py.newDate((Date)object) : Py.java2py(object);
                break;
            }
            case 0: {
                pyObject = Py.None;
                break;
            }
            case 1111: 
            case 2000: {
                pyObject = Py.java2py(resultSet.getObject(n));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                pyObject = Py.java2py(resultSet.getBytes(n));
                break;
            }
            case 2004: {
                Blob blob = resultSet.getBlob(n);
                pyObject = blob == null ? Py.None : Py.java2py(DataHandler.read(blob.getBinaryStream()));
                break;
            }
            case 2005: 
            case 2009: 
            case 2011: {
                Clob clob = resultSet.getClob(n);
                pyObject = clob == null ? Py.None : Py.java2py(DataHandler.read(clob.getCharacterStream()));
                break;
            }
            case 2003: {
                throw this.createUnsupportedTypeSQLException("ARRAY", n);
            }
            case 70: {
                throw this.createUnsupportedTypeSQLException("DATALINK", n);
            }
            case 2001: {
                throw this.createUnsupportedTypeSQLException("DISTINCT", n);
            }
            case 2006: {
                throw this.createUnsupportedTypeSQLException("REF", n);
            }
            case -8: {
                throw this.createUnsupportedTypeSQLException("STRUCT", n);
            }
            case 2002: {
                throw this.createUnsupportedTypeSQLException("STRUCT", n);
            }
            default: {
                throw this.createUnsupportedTypeSQLException(new Integer(n2), n);
            }
        }
        return resultSet.wasNull() || pyObject == null ? Py.None : pyObject;
    }

    protected final SQLException createUnsupportedTypeSQLException(Object object, int n) {
        Object[] objectArray = new Object[]{object, new Integer(n)};
        String string = zxJDBC.getString("unsupportedTypeForColumn", objectArray);
        return new SQLException(string);
    }

    public PyObject getPyObject(CallableStatement callableStatement, int n, int n2) throws SQLException {
        PyObject pyObject = Py.None;
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                String string = callableStatement.getString(n);
                pyObject = string == null ? Py.None : Py.newUnicode(string);
                break;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = callableStatement.getBigDecimal(n);
                pyObject = bigDecimal == null ? Py.None : Py.newFloat(bigDecimal.doubleValue());
                break;
            }
            case -7: {
                pyObject = callableStatement.getBoolean(n) ? Py.True : Py.False;
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                pyObject = Py.newInteger(callableStatement.getInt(n));
                break;
            }
            case -5: {
                pyObject = Py.newLong(callableStatement.getLong(n));
                break;
            }
            case 6: 
            case 7: {
                pyObject = Py.newFloat(callableStatement.getFloat(n));
                break;
            }
            case 8: {
                pyObject = Py.newFloat(callableStatement.getDouble(n));
                break;
            }
            case 92: {
                pyObject = Py.newTime(callableStatement.getTime(n));
                break;
            }
            case 93: {
                pyObject = Py.newDatetime(callableStatement.getTimestamp(n));
                break;
            }
            case 91: {
                pyObject = Py.newDate(callableStatement.getDate(n));
                break;
            }
            case 0: {
                pyObject = Py.None;
                break;
            }
            case 1111: {
                pyObject = Py.java2py(callableStatement.getObject(n));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                pyObject = Py.java2py(callableStatement.getBytes(n));
                break;
            }
            default: {
                this.createUnsupportedTypeSQLException(n2, n);
            }
        }
        return callableStatement.wasNull() || pyObject == null ? Py.None : pyObject;
    }

    public void registerOut(CallableStatement callableStatement, int n, int n2, int n3, String string) throws SQLException {
        try {
            callableStatement.registerOutParameter(n, n3);
        }
        catch (Throwable throwable) {
            SQLException sQLException = null;
            SQLException sQLException2 = new SQLException("error setting index [" + n + "], coltype [" + n2 + "], datatype [" + n3 + "], datatypename [" + string + "]");
            sQLException = throwable instanceof SQLException ? (SQLException)throwable : new SQLException(throwable.getMessage());
            sQLException2.setNextException(sQLException);
            throw sQLException2;
        }
    }

    public static final boolean checkNull(PreparedStatement preparedStatement, int n, PyObject pyObject, int n2) throws SQLException {
        if (pyObject == null || Py.None == pyObject) {
            preparedStatement.setNull(n, n2);
            return true;
        }
        return false;
    }

    public static final byte[] read(InputStream inputStream) {
        int n = 0;
        byte[] byArray = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
        try {
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw zxJDBC.makeException(iOException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw zxJDBC.makeException(iOException);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String read(Reader reader) {
        int n = 0;
        char[] cArray = new char[4096];
        StringBuilder stringBuilder = new StringBuilder(4096);
        try {
            while ((n = reader.read(cArray)) != -1) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw zxJDBC.makeException(iOException);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                throw zxJDBC.makeException(iOException);
            }
        }
        return stringBuilder.toString();
    }

    public static final DataHandler getSystemDataHandler() {
        DataHandler dataHandler = new DataHandler();
        for (String string : SYSTEM_DATAHANDLERS) {
            try {
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(DataHandler.class);
                dataHandler = (DataHandler)constructor.newInstance(dataHandler);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return dataHandler;
    }

    public PyObject __chain__() {
        return new PyList(Py.javas2pys(this));
    }

    public String toString() {
        return this.getClass().getName();
    }

    private static interface Java6Types {
        public static final int ROWID = -8;
        public static final int NCHAR = -15;
        public static final int NVARCHAR = -9;
        public static final int LONGNVARCHAR = -16;
        public static final int NCLOB = 2011;
        public static final int SQLXML = 2009;
    }
}

