/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.DataHandler;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.python.core.PySystemState;

public class DataHandlerTest
extends TestCase {
    private DataHandler _handler;

    protected void setUp() throws Exception {
        PySystemState.initialize();
        this._handler = new DataHandler();
    }

    public void testGetPyObjectResultSetIntInt() throws Exception {
        ResultSet resultSet = (ResultSet)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)new DefaultReturnHandler());
        List<String> list = Arrays.asList("ARRAY", "DATALINK", "DISTINCT", "REF", "ROWID", "STRUCT");
        for (Field field : Types.class.getDeclaredFields()) {
            String string = field.getName();
            int n = field.getInt(null);
            if (list.contains(string)) {
                try {
                    this._handler.getPyObject(resultSet, 1, n);
                    DataHandlerTest.fail((String)"SQLException expected");
                }
                catch (SQLException sQLException) {}
                continue;
            }
            DataHandlerTest.assertNotNull((String)(string + " should return None"), (Object)this._handler.getPyObject(resultSet, 1, n));
        }
    }

    static class DefaultReturnHandler
    implements InvocationHandler {
        DefaultReturnHandler() {
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Class<Number> clazz = method.getReturnType();
            if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
                return Boolean.FALSE;
            }
            if (Character.TYPE.equals(clazz)) {
                return Character.valueOf('0');
            }
            if (Byte.TYPE.equals(clazz)) {
                return (byte)0;
            }
            if (Short.TYPE.equals(clazz)) {
                return (short)0;
            }
            if (Integer.TYPE.equals(clazz)) {
                return 0;
            }
            if (Long.TYPE.equals(clazz)) {
                return 0L;
            }
            if (Float.TYPE.equals(clazz)) {
                return Float.valueOf(0.0f);
            }
            if (Double.TYPE.equals(clazz)) {
                return 0.0;
            }
            if (clazz.isPrimitive()) {
                throw new RuntimeException("unhandled primitve type " + clazz);
            }
            if (clazz.isAssignableFrom(BigInteger.class)) {
                return BigInteger.ZERO;
            }
            if (clazz.isAssignableFrom(BigDecimal.class)) {
                return BigDecimal.ZERO;
            }
            if (clazz.isAssignableFrom(Number.class)) {
                return 0;
            }
            return null;
        }
    }
}

