/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.DataHandler;
import com.ziclix.python.sql.FilterDataHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.python.core.Py;
import org.python.core.PyFile;
import org.python.core.PyObject;
import org.python.core.util.StringUtil;

public class JDBC20DataHandler
extends FilterDataHandler {
    public JDBC20DataHandler(DataHandler dataHandler) {
        super(dataHandler);
    }

    public void setJDBCObject(PreparedStatement preparedStatement, int n, PyObject pyObject, int n2) throws SQLException {
        if (DataHandler.checkNull(preparedStatement, n, pyObject, n2)) {
            return;
        }
        switch (n2) {
            case 2005: {
                if (pyObject instanceof PyFile) {
                    pyObject = ((PyFile)pyObject).read();
                }
                String string = (String)pyObject.__tojava__(String.class);
                int n3 = string.length();
                InputStream inputStream = new ByteArrayInputStream(StringUtil.toBytes(string));
                inputStream = new BufferedInputStream(inputStream);
                preparedStatement.setBinaryStream(n, inputStream, n3);
                break;
            }
            case 2004: {
                byte[] byArray = null;
                Object object = null;
                object = pyObject instanceof PyFile ? pyObject.__tojava__(InputStream.class) : pyObject.__tojava__(Object.class);
                if (object instanceof InputStream) {
                    byArray = JDBC20DataHandler.read((InputStream)object);
                } else if (object instanceof byte[]) {
                    byArray = (byte[])object;
                }
                if (byArray != null) {
                    preparedStatement.setBytes(n, byArray);
                    break;
                }
            }
            default: {
                super.setJDBCObject(preparedStatement, n, pyObject, n2);
            }
        }
    }

    public PyObject getPyObject(ResultSet resultSet, int n, int n2) throws SQLException {
        PyObject pyObject = Py.None;
        switch (n2) {
            case 2: 
            case 3: {
                try {
                    BigDecimal bigDecimal = resultSet.getBigDecimal(n);
                    pyObject = bigDecimal == null ? Py.None : Py.newFloat(bigDecimal.doubleValue());
                }
                catch (SQLException sQLException) {
                    pyObject = super.getPyObject(resultSet, n, n2);
                }
                break;
            }
            case 2005: {
                Reader reader = resultSet.getCharacterStream(n);
                pyObject = reader == null ? Py.None : Py.newUnicode(JDBC20DataHandler.read(reader));
                break;
            }
            case 2004: {
                Blob blob = resultSet.getBlob(n);
                pyObject = blob == null ? Py.None : Py.java2py(JDBC20DataHandler.read(blob.getBinaryStream()));
                break;
            }
            case 2003: {
                Array array = resultSet.getArray(n);
                pyObject = array == null ? Py.None : Py.java2py(array.getArray());
                break;
            }
            default: {
                return super.getPyObject(resultSet, n, n2);
            }
        }
        return resultSet.wasNull() || pyObject == null ? Py.None : pyObject;
    }
}

