/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.ConnectionFunc;
import com.ziclix.python.sql.PyCursor;
import com.ziclix.python.sql.PyExtendedCursor;
import com.ziclix.python.sql.PyStatement;
import com.ziclix.python.sql.zxJDBC;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.python.core.ClassDictInit;
import org.python.core.ContextManager;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyUnicode;
import org.python.core.ThreadState;
import org.python.util.Generic;

public class PyConnection
extends PyObject
implements ClassDictInit,
ContextManager {
    protected boolean closed = false;
    protected boolean supportsTransactions;
    protected boolean supportsMultipleResultSets;
    protected Connection connection;
    private Set<PyCursor> cursors = Collections.synchronizedSet(this.cursors);
    private Set<PyStatement> statements;
    protected static PyList __members__;
    protected static PyList __methods__;

    public PyConnection(Connection connection) throws SQLException {
        this.connection = connection;
        this.statements = Generic.newSetFromMap(new WeakHashMap());
        this.statements = Collections.synchronizedSet(this.statements);
        this.supportsTransactions = this.connection.getMetaData().supportsTransactions();
        this.supportsMultipleResultSets = this.connection.getMetaData().supportsMultipleResultSets();
        if (this.supportsTransactions) {
            this.connection.setAutoCommit(false);
        }
    }

    public String toString() {
        try {
            return String.format("<PyConnection object at %s user='%s', url='%s'>", Py.idstr(this), this.connection.getMetaData().getUserName(), this.connection.getMetaData().getURL());
        }
        catch (SQLException sQLException) {
            return String.format("<PyConnection object at %s", Py.idstr(this));
        }
    }

    public static void classDictInit(PyObject pyObject) {
        PyObject pyObject2 = Py.newString("$Revision: 7015 $").__getslice__(Py.newInteger(11), Py.newInteger(-2));
        pyObject.__setitem__("__version__", pyObject2);
        pyObject.__setitem__("autocommit", (PyObject)new PyInteger(0));
        pyObject.__setitem__("close", (PyObject)new ConnectionFunc("close", 0, 0, 0, zxJDBC.getString("close")));
        pyObject.__setitem__("commit", (PyObject)new ConnectionFunc("commit", 1, 0, 0, zxJDBC.getString("commit")));
        pyObject.__setitem__("cursor", (PyObject)new ConnectionFunc("cursor", 2, 0, 4, zxJDBC.getString("cursor")));
        pyObject.__setitem__("rollback", (PyObject)new ConnectionFunc("rollback", 3, 0, 0, zxJDBC.getString("rollback")));
        pyObject.__setitem__("nativesql", (PyObject)new ConnectionFunc("nativesql", 4, 1, 1, zxJDBC.getString("nativesql")));
        pyObject.__setitem__("__enter__", (PyObject)new ConnectionFunc("__enter__", 5, 0, 0, "__enter__"));
        pyObject.__setitem__("__exit__", (PyObject)new ConnectionFunc("__exit__", 6, 3, 3, "__exit__"));
        pyObject.__setitem__("initModule", null);
        pyObject.__setitem__("toString", null);
        pyObject.__setitem__("setConnection", null);
        pyObject.__setitem__("getPyClass", null);
        pyObject.__setitem__("connection", null);
        pyObject.__setitem__("classDictInit", null);
        pyObject.__setitem__("cursors", null);
    }

    public void __setattr__(String string, PyObject pyObject) {
        if ("autocommit".equals(string)) {
            try {
                if (this.supportsTransactions) {
                    this.connection.setAutoCommit(pyObject.__nonzero__());
                }
            }
            catch (SQLException sQLException) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, sQLException);
            }
            return;
        }
        super.__setattr__(string, pyObject);
    }

    public PyObject __findattr_ex__(String string) {
        if ("autocommit".equals(string)) {
            try {
                return this.connection.getAutoCommit() ? Py.One : Py.Zero;
            }
            catch (SQLException sQLException) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, sQLException);
            }
        }
        if ("dbname".equals(string)) {
            try {
                return Py.newString(this.connection.getMetaData().getDatabaseProductName());
            }
            catch (SQLException sQLException) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, sQLException);
            }
        }
        if ("dbversion".equals(string)) {
            try {
                return Py.newString(this.connection.getMetaData().getDatabaseProductVersion());
            }
            catch (SQLException sQLException) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, sQLException);
            }
        }
        if ("drivername".equals(string)) {
            try {
                return Py.newString(this.connection.getMetaData().getDriverName());
            }
            catch (SQLException sQLException) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, sQLException);
            }
        }
        if ("driverversion".equals(string)) {
            try {
                return Py.newString(this.connection.getMetaData().getDriverVersion());
            }
            catch (SQLException sQLException) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, sQLException);
            }
        }
        if ("url".equals(string)) {
            try {
                return Py.newString(this.connection.getMetaData().getURL());
            }
            catch (SQLException sQLException) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, sQLException);
            }
        }
        if ("__connection__".equals(string)) {
            return Py.java2py(this.connection);
        }
        if ("__cursors__".equals(string)) {
            return Py.java2py(Collections.unmodifiableSet(this.cursors));
        }
        if ("__statements__".equals(string)) {
            return Py.java2py(Collections.unmodifiableSet(this.statements));
        }
        if ("__methods__".equals(string)) {
            return __methods__;
        }
        if ("__members__".equals(string)) {
            return __members__;
        }
        if ("closed".equals(string)) {
            return Py.newBoolean(this.closed);
        }
        return super.__findattr_ex__(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closed) {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, "connection is closed");
        }
        this.closed = true;
        Set<PyObject> set = this.cursors;
        synchronized (set) {
            for (PyCursor pyObject : this.cursors) {
                pyObject.close();
            }
            this.cursors.clear();
        }
        set = this.statements;
        synchronized (set) {
            for (PyStatement pyStatement : this.statements) {
                pyStatement.close();
            }
            this.statements.clear();
        }
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
            throw zxJDBC.makeException(sQLException);
        }
    }

    public void commit() {
        if (this.closed) {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, "connection is closed");
        }
        if (!this.supportsTransactions) {
            return;
        }
        try {
            this.connection.commit();
        }
        catch (SQLException sQLException) {
            throw zxJDBC.makeException(sQLException);
        }
    }

    public void rollback() {
        if (this.closed) {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, "connection is closed");
        }
        if (!this.supportsTransactions) {
            return;
        }
        try {
            this.connection.rollback();
        }
        catch (SQLException sQLException) {
            throw zxJDBC.makeException(sQLException);
        }
    }

    public PyObject nativesql(PyObject pyObject) {
        if (this.closed) {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, "connection is closed");
        }
        if (pyObject == Py.None) {
            return Py.None;
        }
        try {
            if (pyObject instanceof PyUnicode) {
                return Py.newUnicode(this.connection.nativeSQL(pyObject.toString()));
            }
            return Py.newString(this.connection.nativeSQL(pyObject.__str__().toString()));
        }
        catch (SQLException sQLException) {
            throw zxJDBC.makeException(sQLException);
        }
    }

    public PyCursor cursor() {
        return this.cursor(false);
    }

    public PyCursor cursor(boolean bl) {
        return this.cursor(bl, Py.None, Py.None);
    }

    public PyCursor cursor(boolean bl, PyObject pyObject, PyObject pyObject2) {
        if (this.closed) {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, "connection is closed");
        }
        PyExtendedCursor pyExtendedCursor = new PyExtendedCursor(this, bl, pyObject, pyObject2);
        this.cursors.add(pyExtendedCursor);
        return pyExtendedCursor;
    }

    void remove(PyCursor pyCursor) {
        if (this.closed) {
            return;
        }
        this.cursors.remove(pyCursor);
    }

    void add(PyStatement pyStatement) {
        if (this.closed) {
            return;
        }
        this.statements.add(pyStatement);
    }

    boolean contains(PyStatement pyStatement) {
        if (this.closed) {
            return false;
        }
        return this.statements.contains(pyStatement);
    }

    public PyObject __enter__(ThreadState threadState) {
        return this;
    }

    public PyObject __enter__() {
        return this;
    }

    public boolean __exit__(ThreadState threadState, PyException pyException) {
        if (pyException == null) {
            this.commit();
        } else {
            this.rollback();
        }
        return false;
    }

    public boolean __exit__(PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        if (pyObject == null || pyObject == Py.None) {
            this.commit();
        } else {
            this.rollback();
        }
        return false;
    }

    static {
        PyObject[] pyObjectArray = new PyObject[]{new PyString("close"), new PyString("commit"), new PyString("cursor"), new PyString("rollback"), new PyString("nativesql")};
        __methods__ = new PyList(pyObjectArray);
        pyObjectArray = new PyObject[]{new PyString("autocommit"), new PyString("dbname"), new PyString("dbversion"), new PyString("drivername"), new PyString("driverversion"), new PyString("url"), new PyString("__connection__"), new PyString("__cursors__"), new PyString("__statements__"), new PyString("closed")};
        __members__ = new PyList(pyObjectArray);
    }
}

