/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql.handler;

import com.ziclix.python.sql.DataHandler;
import com.ziclix.python.sql.FilterDataHandler;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.jdbc.OracleResultSet;
import oracle.sql.BLOB;
import oracle.sql.ROWID;
import org.python.core.Py;
import org.python.core.PyInteger;
import org.python.core.PyObject;

public class OracleDataHandler
extends FilterDataHandler {
    public OracleDataHandler(DataHandler dataHandler) {
        super(dataHandler);
    }

    public String getMetaDataName(PyObject pyObject) {
        String string = super.getMetaDataName(pyObject);
        return string == null ? null : string.toUpperCase();
    }

    public void setJDBCObject(PreparedStatement preparedStatement, int n, PyObject pyObject, int n2) throws SQLException {
        if (DataHandler.checkNull(preparedStatement, n, pyObject, n2)) {
            return;
        }
        switch (n2) {
            case 91: {
                Timestamp timestamp = (Timestamp)pyObject.__tojava__(Timestamp.class);
                if (timestamp != Py.NoConversion) {
                    preparedStatement.setTimestamp(n, timestamp);
                    break;
                }
                super.setJDBCObject(preparedStatement, n, pyObject, n2);
                break;
            }
            case 3: {
                Object object = pyObject.__tojava__(Double.class);
                if (object != Py.NoConversion) {
                    preparedStatement.setDouble(n, (Double)object);
                    break;
                }
                super.setJDBCObject(preparedStatement, n, pyObject, n2);
                break;
            }
            case 2: {
                super.setJDBCObject(preparedStatement, n, pyObject, 8);
                break;
            }
            case -8: {
                preparedStatement.setString(n, (String)pyObject.__tojava__(String.class));
                break;
            }
            case -102: 
            case -101: {
                super.setJDBCObject(preparedStatement, n, pyObject, 93);
                break;
            }
            default: {
                super.setJDBCObject(preparedStatement, n, pyObject, n2);
            }
        }
    }

    public PyObject getPyObject(ResultSet resultSet, int n, int n2) throws SQLException {
        PyObject pyObject = Py.None;
        switch (n2) {
            case 91: {
                pyObject = Py.newDatetime(resultSet.getTimestamp(n));
                break;
            }
            case 2: {
                int n3;
                int n4;
                String string = resultSet.getString(n);
                if (string == null) {
                    pyObject = Py.None;
                    break;
                }
                try {
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    n4 = resultSetMetaData.getScale(n);
                    n3 = resultSetMetaData.getPrecision(n);
                }
                catch (SQLException sQLException) {
                    n3 = 0;
                    n4 = 0;
                }
                if (n4 == -127) {
                    if (n3 == 0) {
                        pyObject = string.indexOf(46) == -1 ? PyInteger.TYPE.__call__(Py.newString(string)) : Py.newDecimal(string);
                        break;
                    }
                    pyObject = Py.newFloat(resultSet.getBigDecimal(n).doubleValue());
                    break;
                }
                pyObject = n4 == 0 && (n3 != 0 || string.indexOf(46) == -1) ? PyInteger.TYPE.__call__(Py.newString(string)) : Py.newDecimal(string);
                break;
            }
            case 2004: {
                BLOB bLOB = ((OracleResultSet)resultSet).getBLOB(n);
                pyObject = bLOB == null ? Py.None : Py.java2py(OracleDataHandler.read(bLOB.getBinaryStream()));
                break;
            }
            case -102: 
            case -101: {
                pyObject = super.getPyObject(resultSet, n, 93);
                break;
            }
            case -8: {
                ROWID rOWID = ((OracleResultSet)resultSet).getROWID(n);
                if (rOWID == null) break;
                pyObject = Py.java2py(rOWID.stringValue());
                break;
            }
            default: {
                pyObject = super.getPyObject(resultSet, n, n2);
            }
        }
        return resultSet.wasNull() ? Py.None : pyObject;
    }

    public void registerOut(CallableStatement callableStatement, int n, int n2, int n3, String string) throws SQLException {
        if (n3 == 1111) {
            if ("REF CURSOR".equals(string)) {
                callableStatement.registerOutParameter(n, -10);
                return;
            }
            if ("PL/SQL RECORD".equals(string)) {
                callableStatement.registerOutParameter(n, -10);
                return;
            }
        }
        super.registerOut(callableStatement, n, n2, n3, string);
    }
}

